###################################################################
######## adaptdation a prhymo du script rhum :
# lancement :
#   Rscript prhymo.r <territoire> <debug : TRUE/FALSE> 
#   Rscript prhymo.r martinique TRUE
#
########                                                      #####
###################################################################


rm(list = ls())

##############################################
######## lecture des PARAMETRES   ############
##############################################
args = commandArgs(trailingOnly=TRUE)
if (length(args)>0) {
  # default output file
  print(args[1])
  region <- args[1]
  debug <- args[2]
}else{
  region<-'martinique'
  debug <- 'TRUE'
}


script_dir <- '/home/debian/prhymo/3-traitements-r/'
source(paste0(script_dir,"/prhymo/config.r"), encoding = "UTF-8")


# schéma contenant la configuration de l'arbre baysien
bay_schema <- 'stats_shared'
data_schema <- paste0('ref_', region)
out_schema <- paste0('output_', region)
trt_schema <-  paste0('trt_', region)

tgh_cols <- 'toponyme,rang,longueur,alt_am,alt_av,pente_lit,largeur_pb,classe_enc,her1,her2,substrat,typ_detail,typ_simple'
if(region=='hexagone'){
  trt_schema <-  'trt_metro'
  tgh_cols <- 'toponyme,rang,agence,longueur,alt_am,alt_av,pente_lit,largeur_pb,surf_bv,larg_fdv,qspe_crue,pente_val,substrat,rap_encais,drain_prin,origine_tgh_id,q_etiage_n'
}
  
usra_table <- 'usra'

print(data_schema)
print(out_schema)
print(debug)

out_dir <- './OUTPUT/'


#######CHEMIN VERS LEQUEL SERA EXPORTER LES RESULATS
ch_output<-paste0(script_dir,'/prhymo/OUTPUT/',region,"/")

### NOM des parametres elementaires a calculer
vectparam <- c("hyd_qte","mor_riv", "hyd_dyn","hyd_mes",  "con_lat", "con_amp","con_pro", "con_sed","mor_pll","mor_ssl")

### liste des descripteurs (presents dans les arbres)  qui ne seront pas utilises ( souvent car pas de donnees sur le territoire)
DESCR_MANQUANT<-as.character()  ## Si pas de descripteurs manquants
#DESCR_MANQUANT <- c("canaux","curage", "carriere", "digue")

######################################
###LECTURE DES LIBRAIRIES  ###########
######################################

library(sqldf) # pour utilisation SQL
# pour eviter un conflit avec Rpostgres
options(sqldf.driver = "SQLite")

library(DBI) # pour utilisation SQL
library(foreign) # pour lire les dbf
library(bnlearn) ## pour bayesien
library(stringr) ## pour chaines de caractere
library(logging)  
library(gRain)
logReset()
addHandler(writeToConsole)
setLevel("DEBUG", getHandler("writeToConsole"))
getHandler("writeToConsole")[["level"]]==loglevels["DEBUG"]
if(debug=='debug'){
   setLevel('DEBUG') 
}


#### PG connection
con <- dbConnect(RPostgres::Postgres()
  , host = db_host
  , port = db_port
  , dbname = db_name
  , user = db_user,password = db_pass)

# ######################################
# ###############Lecture des USRA  ######
# ########################################
usra <- dbReadTable(con, Id(schema = data_schema, table = usra_table))


# ########################################
# ###############Calculs bayesiens  ######
# ########################################

source(paste0(script_dir,"/fonctions_bayesien_prhymo.r"), encoding = "UTF-8")

for (p in 1:length(vectparam)) {
  paramelem <- vectparam[p]
  tablename <- paste0('arb_', paramelem)
  doc_arbre <- dbReadTable(con, Id(schema = bay_schema, table = tablename))
  descripteurs <- as.character(doc_arbre$parametre[which(doc_arbre$parents == "Descr")])

  # # declaration de l'arbre et des arcs et des matrices de probabilites conditionnelles
  logdebug(paste0("loading arbre_mat for",paramelem))
  net.disc <- arbre_mat(bay_schema, paramelem)
  logdebug("arbre_mat ok")
  # # calcul bayesien
  usraResult2 <- calc_grain(
    net.disc,
    Rep = 1, 
    nom_alteration = tolower(paramelem),
    mod_alteration = c(1, 2, 3, 4, 5),
    descripteurs = setdiff(descripteurs, DESCR_MANQUANT),
    df_usra = usra,
    id_usra = "usra_id",
    schema = bay_schema)

  logdebug("calc ok")
  usra <- merge(usra, usraResult2[, c("usra_id", names(usraResult2)[(length(names(usraResult2)) - 6):length(names(usraResult2))])], by.x = "usra_id", by.y = "usra_id")
  logdebug("usra merge ok")
}

print(paste('main: enregistrement de la table usra_rst en BD; nrows: ', nrow(usra), ' ncols: ', ncol(usra)))
dbWriteTable(con, Id(schema = out_schema, table = "usra_rst"), usra, overwrite = TRUE)
print('main: enregistrement de la table usra_rst en BD OK')
save.image(file = paste0(ch_output, "result.Rdata"))


###################################################################
################## SYNTHESE DES PARAMETRES ELEMENTAIRES (USRA)######
##################################################################
load(paste0(ch_output, "result.Rdata"))
usra_sauv2 <- usra

## Passer de 5 classe a 3 classes
print('main: PAsser de 5 classe a 3 classes')
usra <- from5to3classes(usra,vectparam)

print('main: PAsser les 5 classes en texte')
usra <- from5toText(usra,vectparam)

## Chaque parametre est pondere afin de faire une synthese en 3 elements de qualite
### PONDERATION des parametres elementaires : hyd_qte_3c = 0.5 ,  hyd_dyn_3c = 0.25 , hyd_mes_3c = 0.25
print('main: PONDERATION des parametres elementaires 1')
usra$hydro <- ceiling(usra$hyd_qte_3c * 0.5 +
                        usra$hyd_dyn_3c * 0.25 +
                        usra$hyd_mes_3c * 0.25 - 0.0001)

### PONDERATION des parametres elementaires : con_lat_3c = 1/3 ,  con_amp_3c = 1/3 , con_sed_3c = 1/3
print('main: PONDERATION des parametres elementaires 2')
usra$continuite <- ceiling(usra$con_lat_3c * 0.3 +
                             usra$con_amp_3c * 0.2 +
                             usra$con_pro_3c * 0.2 +
                             usra$con_sed_3c * 0.3 - 0.0001)


### PONDERATION des parametres elementaires : mor_riv_3c = 0.4 ,  mor_pll_3c = 0.4 , mor_pll_3c = 0.2
print('main: PONDERATION des parametres elementaires 3')
usra$morpho <- ceiling(usra$mor_riv_3c * 0.3 +
                         usra$mor_pll_3c * 0.3 +
                         usra$mor_ssl_3c * 0.4 - 0.0001)

usra$synthese <- 2
usra$synthese[usra$hydro + usra$continuite + usra$morpho <= 4] <- 1

usra$av_attenue <- ''
# conversion en texte lisible
usra <- addTextValues(usra)

print('main: Export des resultats')
## Export des resultats
dev.off()
dbDisconnect(con)
con <- dbConnect(RPostgres::Postgres()
                 , host = db_host
                 , port = db_port
                 , dbname = db_name
                 , user = db_user,password = db_pass)

dbExecute(con, paste0("DROP TABLE if exists ",out_schema,".usra_synth_rst CASCADE"));
dbWriteTable(con, Id(schema = out_schema, table = "usra_synth_rst"), usra, overwrite = TRUE)
print('main: Export des resultats OK' )
###############################
#### AGREGATION AUX TRONCONS ##
###############################
print('main: AGREGATION AUX TRONCONS' )


##  on fait la moyenne de la note par troncon
TH <- dbGetQuery(con, paste0("select tgh_id,",tgh_cols," from ",data_schema,".tgh order by tgh_id"))


for (i in tolower(vectparam)) {
  for (j in 1:5) {
    N <- names(TH)
    print(paste(i,j))
    #tapply => applique une moyenne en groupant par tgh 
    TH <- cbind(TH, as.numeric(tapply(usra[, paste0(i, j)], usra$tgh_id, mean, na.rm = T)))
    names(TH) <- c(N, paste0(i[1], j))
  }
  TH[!is.na(TH[paste0(i, j)]), i] <- c(lapply(split(TH[!is.na(TH[paste0(i, j)]), paste0(i, 1:5)], TH$tgh_id[!is.na(TH[paste0(i, j)])]), function(x) (1:5)[tail(which(x==max(x)),1)]), recursive = T)
  TH[, i] <- round(TH[, i])
  mod_alteration = c(1, 2, 3, 4, 5)
  moda <- paste0(i, mod_alteration)
  TH<-indice_conf2(TH,i, moda,nom_Nconf = paste0("av_", i) )
}

print('main: PAsser les 5 classes en texte')
TH <- from5toText(TH,vectparam)

# sqldf kills the connection ?
dbWriteTable(con, Id(schema = out_schema, table = "tgh_rst"), TH, overwrite = TRUE)
print('main: write table tgh_rst' )

###################################################################
################## SYNTHESE DES PARAMETRES ELEMENTAIRES (TH)######
##################################################################
print('main: SYNTHESE DES PARAMETRES ELEMENTAIRES (TH)' )
TH_sauv2 <- TH
TH <- from5to3classes(TH,vectparam)

## Chaque parametre est pondere afin de faire une synthese en 3 elements de qualite

### PONDERATION des parametres elementaires : 
TH$hydro <- ceiling(TH$hyd_qte_3c * 0.5 +
                      TH$hyd_dyn_3c * 0.25 +
                      TH$hyd_mes_3c * 0.25 - 0.0001)
                      
TH$continuite <- ceiling(TH$con_lat_3c * 0.3 +
                             TH$con_amp_3c * 0.2 +
                             TH$con_pro_3c * 0.2 +
                             TH$con_sed_3c * 0.3 - 0.0001)

TH$morpho <- ceiling(TH$mor_riv_3c * 0.3 +
                         TH$mor_pll_3c * 0.3 +
                         TH$mor_ssl_3c * 0.4 - 0.0001)

TH$synthese <- 2
TH$synthese[TH$hydro + TH$continuite + TH$morpho <= 4] <- 1

TH$av_attenue <- ''

# conversion en texte lisible
TH <- addTextValues(TH)

## Export des resultats
dev.off()
dbExecute(con, paste0("DROP TABLE if exists ",out_schema,".tgh_synth_rst CASCADE"));
dbWriteTable(con, Id(schema = out_schema, table = "tgh_synth_rst"), TH, overwrite = TRUE)



#####################################
#### AGREGATION A LA MASSE D'EAU   ##
#####################################

usrame_query <- paste0('select m.code_me,me.usra_id,me.me_ogc_fid,st_length(u.geom) as l_usra from ',
                     data_schema,
                     '.usra_me me  inner join ',data_schema,'.usra u on me.usra_id=u.usra_id inner join ',data_schema,'.me m on m.ogc_fid=me.me_ogc_fid')
USRAME <- dbGetQuery(con, usrame_query)

names(USRAME) <- tolower(names(USRAME))
USRAME2 <- merge(usra, USRAME[, c("usra_id", "me_ogc_fid", "l_usra","code_me")], by = "usra_id")
USRAME2 <- USRAME2[!is.na(USRAME2$me_ogc_fid),]
ME <- sqldf("select me_ogc_fid, code_me,sum(l_usra) as l_me from USRAME2 group by me_ogc_fid order by me_ogc_fid")

### Somme pondere par la longueur
for (i in tolower(vectparam)) {
  for (j in 1:5) {
    N <- names(ME)
    ME <- cbind(ME, as.numeric(tapply(USRAME2[, paste0(i, j)] * USRAME2$l_usra, USRAME2$me_ogc_fid, sum, na.rm = T) / ME$l_me))
    names(ME) <- c(N, paste0(i[1], j))
  }
  ME[!is.na(ME[paste0(i, j)]), i] <- c(lapply(split(ME[!is.na(ME[paste0(i, j)]), paste0(i, 1:5)], ME$me_ogc_fid[!is.na(ME[paste0(i, j)])]), function(x) (1:5)[tail(which(x==max(x)),1)]), recursive = T)
  ME[, i] <- round(ME[, i])
  mod_alteration = c(1, 2, 3, 4, 5)
  moda <- paste0(i, mod_alteration)
  ME<-indice_conf2(ME,i, moda,nom_Nconf = paste0("av_", i) )
}
print('main: Passer les 5 classes en texte')
ME <- from5toText(ME,vectparam)

dbWriteTable(con, Id(schema = out_schema, table = "me_rst"), ME, overwrite = TRUE)


###################################################################
################## SYNTHESE DES PARAMETRES ELEMENTAIRES (ME)######
##################################################################

ME_sauv2 <- ME

## PAsser de 5 classe a 3 classes
ME <- from5to3classes(ME,vectparam)


## Chaque parametre est pondere afin de faire une synMEese en 3 elements de qualite
### PONDERATION des parametres elementaires : 
ME$hydro <- ceiling(ME$hyd_qte_3c * 0.5 +
                      ME$hyd_dyn_3c * 0.25 +
                      ME$hyd_mes_3c * 0.25 - 0.0001)

ME$continuite <- ceiling(ME$con_lat_3c * 0.3 +
                             ME$con_amp_3c * 0.2 +
                             ME$con_pro_3c * 0.2 +
                             ME$con_sed_3c * 0.3 - 0.0001)

ME$morpho <- ceiling(ME$mor_riv_3c * 0.3 +
                         ME$mor_pll_3c * 0.3 +
                         ME$mor_ssl_3c * 0.4 - 0.0001)

ME$synthese <- 2
ME$synthese[ME$hydro + ME$continuite + ME$morpho <= 4] <- 1
ME$av_attenue <- ''

# conversion en texte lisible
ME <- addTextValues(ME)


## Export des resultats
dev.off()

dbExecute(con, paste0("DROP TABLE if exists ",out_schema,".me_synth_rst CASCADE"));
dbWriteTable(con, Id(schema = out_schema, table = "me_synth_rst"), ME, overwrite = TRUE)

dbDisconnect(con)