-- 23 fevrier 2022
-- script sql d'import des fichiers CSV en BD
--
-- les schémas suivants sont utilisés pour les calculs:
-- calculs bayesiens en base:


drop schema stats_hexagone cascade ;
drop schema stats_guadeloupe cascade ;
drop schema stats_martinique cascade ;
drop schema stats_guyane cascade ;
drop schema stats_reunion cascade ;
drop schema stats_mayotte cascade ;

create schema stats_hexagone;
create schema stats_guadeloupe;
create schema stats_martinique;
create schema stats_guyane;
create schema stats_reunion;
create schema stats_mayotte;
create schema stats_shared;


-- fn permettant de créer une table a partir d'un CSV:
-- loads csv file into database:
-- code from: https://stackoverflow.com/questions/21018256/can-i-automatically-create-a-table-in-postgresql-from-a-csv-file-with-headers
-- modified to force float type for all columns: todo: code to update types: int and float
drop FUNCTION load_csv_file;
CREATE OR REPLACE FUNCTION load_csv_file(
    target_schema text,
    target_table text,
    csv_path text,
    col_count integer,
    delim text default ',')
  RETURNS text AS
$BODY$
declare

iter integer; -- dummy integer to iterate columns with
col text; -- variable to keep the column name at each iteration
col_first text; -- first column name, e.g., top left corner on a csv file or spreadsheet
msg text := ''; -- return value
rec record;
begin
    create table temp_table ();

    -- add just enough number of columns
    for iter in 1..col_count
    loop
        execute format('alter table temp_table add column col_%s text;', iter);
    end loop;

    -- copy the data from csv file
    execute format('copy temp_table from %L with delimiter %L quote ''"'' csv ', csv_path, delim);

    iter := 1;
    col_first := (select col_1 from temp_table limit 1);

    -- update the column names based on the first row which has the column names
    for col in execute format('select unnest(string_to_array(trim(temp_table::text, ''()''), '','')) from temp_table where col_1 = %L', col_first)
    loop
        execute format('alter table temp_table rename column col_%s to %s', iter, col);
        iter := iter + 1;
    end loop;

    -- delete the columns row
    execute format('delete from temp_table where %s = %L', col_first, col_first);

    -- change the temp table name to the name given as parameter, if not blank
    if length(target_table) > 0 then
        execute format('alter table temp_table rename to %I', target_table);
        execute format('alter table %I set schema %I', target_table, target_schema);

        -- changes columns types
        for rec in execute format('select table_schema, table_name, column_name
                            from information_schema.columns
                            where table_schema = %L and table_name = %L', target_schema, target_table)
        loop
            execute format('alter table %1$I.%2$I alter column %3$I type %4$s using %3$I::%4$s',
                rec.table_schema,
                rec.table_name,
                rec.column_name,
                case when strpos(rec.column_name, target_table) > 0 then 'int' else 'float' end);
        end loop;
    end if;

    msg := format('table %I.%I created', target_schema, target_table);
    return msg;

end;
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;
