#!/bin/bash

# 17 fevrier 2022
# script pour charger les valeurs et proba des descripteurs dans la table bay.descripteur
# chargement sans modif de schéma, regroupement dans des tables uniques
#
# 22 fevrier: adaptaion pour charger une table par fichier csv => isomodele
# schémas stats_* pour stocker les tables
# fuck \R dans certains fichiers !
# cmd: sed -i 's/\r/\n/g'  "/data/prhymo/RHUM/donnees/Phase3_CALCULS_BAYESIENS/_CALCULS_BAYESIENS/Mod ILE v2 - 976/E_MPH_GHY/Enfants/retrecis.csv"

# load variables
. ./config.sh

DESC_PATH=$(realpath ${DESC_PATH})

echo $DESC_PATH

echo $CORRES_PATH

echo $DBNAME
echo $DBHOST

# spaces in filenames:
IFS=$'\n'

REGIONS="hexagone
guadeloupe
guyane
martinique
mayotte
reunion
shared"

REGIONSTXT="HEXAGONE
GUADELOUPE
GUYANE
MARTINIQUE
MAYOTTE
REUNION
SHARED"



for region in ${REGIONS}; do
  echo "${region}"
  cd "$DESC_PATH"
  psql -X -U prhymo_admin -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -c "
    drop schema if exists stats_${region} cascade;
    create schema stats_${region}"

  # descripteurs
  for csv in $(find ${DESC_PATH} -type f  -name "*.csv" | grep Descripteurs | grep ${region}); do
  #  echo "descripteur: ${csv##*/}"
    f=${csv##*/}
    name=${f%.*}
    dir=$(dirname ${csv})
    dir=$(dirname ${dir})
    themename=$(basename ${dir})
    themename=${themename:2}

    echo "name: ${name}, f: ${f}, theme: ${themename}, ${csv}"
    psql -X -U prhymo_admin -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -c "
    create table stats_${region}.desc_${themename}_${name} (
      id int generated always as identity primary key ,
      modalite int not null,
      label text not null,
      prob float)"
    psql -X -U prhymo_admin -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -c "COPY stats_${region}.desc_${themename}_${name} (modalite, label, prob) from '${csv}' with (format csv, header true, delimiter ';', encoding 'ISO-8859-1')"
  done

  # arbres
  for csv in $(find ${DESC_PATH} -type f  -name "*.csv" | grep Arbre | grep ${region}); do
  #  echo "descripteur: ${csv##*/}"
    dir=$(dirname ${csv})
    dir=$(dirname ${dir})
    name=$(basename ${dir})
    name=${name:2}
    echo "name: ${name}, csv: ${csv}"
    psql -X -U prhymo_admin -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -c "
      create table stats_${region}.arb_${name} (
        id int generated always as identity primary key ,
        parametre text not null,
        parents text not null,
        pelem char);

        COPY stats_${region}.arb_${name} (parametre, parents, pelem) from '${csv}' with (format csv, header true, delimiter ';', encoding 'ISO-8859-1')"
  done

  # enfants
  for csv in $(find ${DESC_PATH} -type f  -name "*.csv" | grep Enfants | grep ${region}); do
    f=${csv##*/}
    name=${f%.*}
    dir=$(dirname ${csv})
    dir=$(dirname ${dir})
    dir=$(basename ${dir})
    dir=$(echo ${dir} | tr "[:upper:]" "[:lower:]") # dir tolower
    dir=${dir:2}
    numcol=$(head -1 "${csv}" | sed 's/[^;]//g' | wc -c  | xargs) # count csv columns
   echo "tablename: stats_${region}.enf_${dir}_${name}, numcol: ${numcol}"
   psql -XAt -U prhymo_admin -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -c "select * from load_csv_file('stats_${region}', 'enf_${dir}_${name}',
      '${csv}',
      ${numcol}, ';')"
  done
done

for region in ${REGIONSTXT}; do
  echo "${region}"
  # th_me
  for dbf in $(find ${CORRES_PATH} -type f  -name "*.dbf" | grep CORRESPONDANCE | grep ${region}); do
    echo ${dbf}
    if [ "$region" = "GUADELOUPE" ]; then
      sch="trt_guadeloupe"
    elif [ "$region" = "MARTINIQUE" ]; then
      sch="trt_martinique"
    elif [ "$region" = "GUYANE" ]; then
      sch="trt_guyane"
    elif [ "$region" = "REUNION" ]; then
      sch="trt_reunion"
    elif [ "$region" = "MAYOTTE" ]; then
      sch="trt_mayotte"
    fi
    ogr2ogr -overwrite -f PostgreSQL PG:"host=${DBHOST} dbname=${DBNAME} port=${DBPORT} active_schema=${sch}" -lco FID=id "${dbf}"
  done
done
