library(bnlearn)
library(stringr)


###################################
# Fonction arbre #############
###################################
table2arbre <- function(schema, paramelem) {
  arb_query <- paste0('select parametre, parents, pelem from ', schema, '.arb_', paramelem)
  TAB <- dbGetQuery(con, arb_query)
  model <- ""
  for (i in TAB[TAB[, 2] == "Descr", 1]) model <- paste0(model, "[", i, "]")
  for (i in TAB[TAB[, 2] != "Descr", 1]) model <- paste0(model, "[", i, "|", TAB[TAB[, 1] == i, 2], "]")
  #print(model)
  NET <- model2network(model)
  NET
}

listParam <- function(schema, paramelem) {
  arb_query <- paste0('select parametre, parents, pelem from ', schema, '.arb_', paramelem)
  TAB <- dbGetQuery(con, arb_query)
  TAB$TYP <- as.character(TAB[, 2])
  TAB$TYP[TAB$TYP != "Descr"] <- "Enfants"
  TAB$NBPARENTS <- str_count(as.character(TAB[, 2]), ":") + 1
  TAB <- TAB[, c(1, 4, 5)]
  TAB
}


###################################
# Fonction mat_enfant #############
###################################

mat_enfant <- function(schema, paramelem, nom, nb_parent, net) {
  tablename <- paste0('enf_', paramelem, '_', nom)
  TAB <- dbReadTable(con, Id(schema = bay_schema, table = tablename))
  #on transforme en numeric
  for (i in 1:ncol(TAB)) {
    TAB[, i] <- as.character(TAB[, i])
    if (!is.na(as.numeric(as.character(TAB[, i]))[1])) TAB[, i] <- as.numeric(as.character(TAB[, i]))
  }


  ### On réordonne les colonnes en fonction de ce qui est attendu dans l'arbre
  listechamp_bon_ordre <- net[['nodes']][[nom]]$parents  # va chercher dans l'arbre (net créé par table2arbre) pour remettre les colonnes dans l'odre (alphabétique ? )
  autres_colonnes <- names(TAB)[!(names(TAB) %in% listechamp_bon_ordre)]
  #print(names(TAB))
  #print(c(listechamp_bon_ordre, autres_colonnes))
  TAB <- TAB[, c(listechamp_bon_ordre, autres_colonnes)]
  #print(names(TAB))

  ## on tri les colonnes des parents
  expr <- paste("TAB[order(", paste("TAB[,", nb_parent:1, "]", sep = "", collapse = ","), "),]")
  TAB <- eval(parse(text = expr))


  # liste des modalités Parent
  for (i in 1:nb_parent) {
    TAB[, i] <- as.character(TAB[, i])
    assign(paste0("mod_P", i), as.character(sort(unique(TAB[, i]))))
    #print(paste("les modalités de ", names(TAB)[i], "sont : "))
    #print(sort(unique(TAB[, i])))
  }
  # Modalité Enfant
  mod_Enfant <- gsub(nom, "", names(TAB)[(nb_parent + 1):(ncol(TAB) - 1)])
  logdebug(paste("les modalités de l'enfant", nom, " sont : "))
  #print(mod_Enfant)
  #création de la matrice sous forme d'un vecteur
  cpt <- matrix(as.matrix(t(TAB[, (nb_parent + 1):(ncol(TAB) - 1)])))
  print(t(TAB[, (nb_parent + 1):(ncol(TAB) - 1)])) 
  cptok <- cpt
  logdebug(paste("nb lignes",nrow(TAB)))
  logdebug(paste("sum ",sum(cptok)))
  sumcpt <- sum(cptok)
  nbrow <- nrow(TAB)
  if (round(sumcpt) / nbrow != 1) { 
    
    print(as.integer(nbrow),digits=10)
    print(as.integer(sumcpt),digits=10)
    print(paste("sum div ",as.integer(sumcpt) / as.integer(nbrow)))
    print(paste("!!!!!", nom, "a un probleme, la somme ne fait pas 1, vérifier la somme")) 
    stop()
    #browser()
    }
  ###calul du nombre de dimensions
  DIM <- length(mod_Enfant)
  for (i in 1:nb_parent) DIM <- c(DIM, length(get(paste0("mod_P", i))))
  dim(cpt) <- DIM


  ##nom des dimensions
  EXPRESSION <- paste0('list("', nom, '"=mod_Enfant ')
  for (i in 1:nb_parent) EXPRESSION <- paste0(EXPRESSION, ',"', names(TAB)[i], '"=', paste0("mod_P", i))  #chg de l'ordre
  EXPRESSION <- paste(EXPRESSION, ")")
  #print(EXPRESSION)
  dimnames(cpt) <- eval(parse(text = EXPRESSION))
  #print(dimnames(cpt))
  #return
  cpt
}


#########################################
# Fonction mat_descripteurs #############
#########################################

mat_descripteurs <- function(schema, paramelem, nom) {
  desc_query <- paste0('select modalite, label, prob from ', schema, '.desc_', paramelem, '_', nom)
  TAB <- dbGetQuery(con, desc_query)
  TAB[, 3] <- as.numeric(as.character(TAB[, 3]))
  TAB[, 3] <- TAB[, 3] / sum(TAB[, 3])
  cpt <- matrix(TAB[, 3], ncol = nrow(TAB), dimnames = list(NULL, TAB[, 1]))
  #return
  #print("cpt des descripteurs : ")
  #print(cpt)
  cpt
}


###finalisation du reaseau : attrbution des matrices à l'arbre
arbre_mat <- function(schema, paramelem) {

  net <- table2arbre(schema, paramelem) #création de l'arbre
  #print(net[['nodes']]['q_etiage']$parents)
  # todo: does it generates Rplots.pdf ?
  #plot(net)
  PARAM <- listParam(schema, paramelem)  # list des paramétres et du nombre de parents
  Expression <- ""
  # constructions des matrices
  for (i in 1:nrow(PARAM)) {

    if (PARAM[i, 2] == "Descr") assign(paste0("cpt", PARAM[i, 1]), mat_descripteurs(schema, paramelem, PARAM[i, 1]))
    if (PARAM[i, 2] != "Descr") assign(paste0("cpt", PARAM[i, 1]), mat_enfant(schema, paramelem, PARAM[i, 1], PARAM[i, 3], net))
    #logdebug(paste0("cpt", PARAM[i, 1]))
    #logdebug(dim(get(paste0("cpt", PARAM[i, 1]))))
    #logdebug(get(paste0("cpt", PARAM[i, 1])))
    Expression <- paste0(Expression, PARAM[i, 1], "=", paste0("cpt", PARAM[i, 1]), ",")
  }
  Expression <- paste0("custom.fit(net, dist=list(", substr(Expression, 1, nchar(Expression) - 1), "))")
  #print(Expression)
  net.disc <- eval(parse(text = Expression))
  net.disc

}


indice_conf2 <- function(dframe, nom_alteration, moda, nom_Nconf = "av_") {
  for (h in 1:nrow(dframe)) {
    dframe[h, nom_Nconf] <- '-'
    les3Pb_fortes <- sort(as.numeric(dframe[h, moda]), decreasing = TRUE)[1:3]
    #pour récupérer les indices dans le tableau de ces 3 probas les plus fortes
    ind1<- -1
    ind2<- -1
    ind3<- -1
    k<-1
    for (v in dframe[h, moda]){
      if(v==les3Pb_fortes[1] && ind1==-1){
        ind1=k
        k<-k+1
        next;
      }
      if(v==les3Pb_fortes[2]&& ind2==-1){
        ind2=k
        k<-k+1
        next;
      }
      if(v==les3Pb_fortes[3]&& ind3==-1){
        ind3=k
        k<-k+1
        next;
      }
      k<-k+1
    }
    inx_les3Pb_fortes<-c(ind1,ind2,ind3)
    #inx_les3Pb_fortes <- match(les3Pb_fortes,dframe[h, moda])
    #2 classes ou plus ont une probabilité inférieure de moins de 10% à la classe la plus probable
    if (les3Pb_fortes[2]>0.9*les3Pb_fortes[1] & les3Pb_fortes[3]>0.9*les3Pb_fortes[1]) {
      dframe[h, nom_Nconf] <- 'A'

    } else {
      if (les3Pb_fortes[2]>0.9*les3Pb_fortes[1]) {
        if (abs(inx_les3Pb_fortes[1] - inx_les3Pb_fortes[2]) >= 3) {
          dframe[h, nom_Nconf] <- 'B'
        }
        if (abs(inx_les3Pb_fortes[1] - inx_les3Pb_fortes[2])  == 2 ) {
          dframe[h, nom_Nconf] <- 'C'
        }
        if (abs(inx_les3Pb_fortes[1] - inx_les3Pb_fortes[2])  == 1) {
          dframe[h, nom_Nconf] <- 'D'
        }
       
       
      }
    } }
  dframe #return
}

##################
####CALCUL ######
#################
calc_grain <- function(net.disc   #nom de l'arbre
                     , Rep
                     , nom_alteration
                     , mod_alteration
                     , descripteurs
                     , df_usra
                     , id_usra
                     ,  schema) {
  print(paste('calc_grain: calcul pour alteration: ', nom_alteration))
  
  descList <- list()
  for (i in descripteurs) {
    desc_query <- paste0('select modalite, label, prob from ', schema, '.desc_', nom_alteration, '_', i)
    TABMOD <- dbGetQuery(con, desc_query)

    descList[[ i ]] <- TABMOD
    if(!(i %in% colnames(df_usra)))
    {
      loginfo(paste('!!! colonne',i,'non présente dans la table usra'))
      stop()
    }

    df_usra[, i] <- as.character(df_usra[, i])
    # for (j in tolower(unique(df_usra[, i]))) {  // script rhum pb avec les valeurs N/A a voir si le fix est correct
    for (j in sort(tolower(unique(df_usra[, i])),TRUE)) {
      #print(j)
      logdebug(paste(i,j))
      # df_usra[tolower(df_usra[, i]) == j, i] <- as.character(TABMOD$modalite[tolower(TABMOD$label) == j][1]) // script rhum pb avec les valeurs N/A a voir si le fix est correct
      df_usra[!is.na(df_usra[, i]) & tolower(df_usra[, i]) == j, i] <- as.character(TABMOD$modalite[tolower(TABMOD$label) == j][1])
    }
  
    if (is.na(sum(as.numeric(df_usra[, i])))) {
      print(sum(as.numeric(df_usra[, i])))
      print(paste0("calc_grain: Les modalites ne correspondent pas pour ",i))
      stop()
    }
  }

  ##liste des combinaisons possibles en fonction de modalites des USRA
  NAMESDATAT <- names(df_usra)
  for (i in c(descripteurs, id_usra)) { df_usra[, i] <- as.character(df_usra[, i]) }
  df_usra <- df_usra[order(df_usra[, id_usra]),]
  df_usra$uniK <- c(lapply(split(df_usra[, descripteurs], df_usra[, id_usra]), function(x) paste0(x, sep = "", collapse = "")), recursive = T)
  usra_uniK <- df_usra[!duplicated(df_usra[, descripteurs]), descripteurs]


  usra_uniK$IDunik <- 1:nrow(usra_uniK)
  usra_uniK$uniK <- c(lapply(split(usra_uniK[, descripteurs], usra_uniK$IDunik), function(x) paste0(x, sep = "", collapse = "")), recursive = T)
  print(paste("calc_grain: identification des caracteristiques uniques: ", nrow(usra_uniK)))


  ###POUR COMPRENDRE
  DF_USRASAUV <<- df_usra
  DF_USRAUNIKSAUV <<- usra_uniK
  ##pour chaque modalite on va calculer les requetes bayesiennes
  cn<-compile(as.grain(net.disc))
  for (j in usra_uniK$IDunik) {

    ev=list()
    for (d in descripteurs) { 
      # init des proba de depart en fonction de la valeur prise par les descripteurs pour cette usra
      #print(as.numeric(usra_uniK[j, d]))
      prob<-'prob'
      desc_proba<-descList[[d]]$prob
      desc_proba[]<-0
      desc_proba[as.numeric(usra_uniK[j, d])]<-1
      #print(desc_proba)
      ev[[ d ]] <- as.vector(desc_proba)
    }

    #print(ev)
    cn2 <-setEvidence(cn, evidence=ev)

    res2<-querygrain(cn2)
    print(res2[[nom_alteration]])
    for (e in 1:5) {
        usra_uniK[j, paste0(nom_alteration, mod_alteration[e])] <- round(res2[[nom_alteration]][e], 3)
    }
  }
  print(paste("calc_bay: calcul requetes bayesiennes OK pour alteration", nom_alteration))

  #### on cherche la meilleur note
  print("on cherche la meilleur note")
  usra_uniK[, nom_alteration] <- c(lapply(split(usra_uniK[, paste0(nom_alteration, mod_alteration)], usra_uniK$IDunik), function(x) mod_alteration[tail(which(x==max(x)),1)]), recursive = T)

  ### etre sur que la somme fait 1
  #print("etre sur que la somme fait 1")
  moda <- paste0(nom_alteration, mod_alteration)
  usra_uniK[, moda] <- round(usra_uniK[, moda] / rowSums(usra_uniK[, moda]), 3)
  usra_uniK<-indice_conf2(usra_uniK,nom_alteration, moda,nom_Nconf = paste0("av_", nom_alteration) )
  df_usra <- merge(df_usra, usra_uniK[, !(names(usra_uniK) %in% c(descripteurs, "IDunik"))], by = "uniK")

  df_usra  #return
} 


#####################################################
# Fonction pour passer de 5 a 3 classes   #############
#####################################################
from5to3classes <- function(usra, vectparam) {
  for (i in tolower(vectparam)) {
      # "tres faible" et "faible" -> "faible"
      usra[usra[, i] == 1, paste(i, "3c", sep = "_")] <- 1
      usra[usra[, i] == 2, paste(i, "3c", sep = "_")] <- 1

      # "moyen" -> "moyen"
      usra[usra[, i] == 3, paste(i, "3c", sep = "_")] <- 2

      # "tres fort" et "fort" -> "fort"
      usra[usra[, i] == 4, paste(i, "3c", sep = "_")] <- 3
      usra[usra[, i] == 5, paste(i, "3c", sep = "_")] <- 3 
  }
  usra
}
#####################################################
# Fonction pour passer en valeur text   #############
#####################################################
from5toText <- function(usra, vectparam) {
  for (i in tolower(vectparam)) {
      usra[usra[, i] == 1, paste(i, "cl", sep = "_")] <- 'tres_faible'
      usra[usra[, i] == 2, paste(i, "cl", sep = "_")] <- 'faible'
      usra[usra[, i] == 3, paste(i, "cl", sep = "_")] <- 'moyen'
      usra[usra[, i] == 4, paste(i, "cl", sep = "_")] <- 'fort'
      usra[usra[, i] == 5, paste(i, "cl", sep = "_")] <- 'tres_fort'
  }
  usra
}

##########################################################
# Fonction pour ajouter les valeurs textuelles   #########
##########################################################
addTextValues <- function(usra) {
  usra$hydro_txt[usra$hydro == 1] <- 'faible'
  usra$hydro_txt[usra$hydro == 2] <- 'moyen'
  usra$hydro_txt[usra$hydro == 3] <- 'fort'
  usra$conti_txt[usra$continuite == 1] <- 'faible'
  usra$conti_txt[usra$continuite == 2] <- 'moyen'
  usra$conti_txt[usra$continuite == 3] <- 'fort'
  usra$morpho_txt[usra$morpho == 1] <- 'faible'
  usra$morpho_txt[usra$morpho == 2] <- 'moyen'
  usra$morpho_txt[usra$morpho == 3] <- 'fort'


  usra$synth_txt[usra$synthese == 1] <- 'faible'
  usra$synth_txt[usra$synthese == 2] <- 'fort'
  usra
}
