set work_mem='8GB';

--- redémarrer ici pour affiner apres avoir modifié usra_work
--alter table trt_metro.usra_work add column startpoint Geometry;
--alter table trt_metro.usra_work add column endpoint Geometry;
--alter table trt_metro.usra_work add column startpointLinks integer;
--alter table trt_metro.usra_work add column endpointLinks integer;
UPDATE trt_metro.usra_work 
set startpoint=ST_STARTPOINT(geom),
endpoint=ST_ENDPOINT(geom);

--create index on trt_metro.usra_work  using gist(startpoint);
--create index on trt_metro.usra_work  using gist(endpoint);
--create index on trt_metro.routing_all using gist(line);
--alter table trt_metro.routing_all_vertices_pgr add column nbLinks integer;

--with tmp as (
--select distinct vert.id,count(vert.id)
--from trt_metro.routing_all_vertices_pgr vert 
--inner join trt_metro.routing_all route on
--	route.source=vert.id or route.target=vert.id
--group by vert.id
--)
--update trt_metro.routing_all_vertices_pgr work
--set nbLinks=t.count 
--from tmp t
--where work.id=t.id;

-- attributs pour détecter les confluences
with tmp as (
    select w.usra_simple_id,count(w.usra_simple_id) from trt_metro.usra_work w 
    inner join trt_metro.usra_work w2 on 
    ((st_dwithin(w.endpoint,w2.startpoint ,2)
    or
    st_dwithin(w.endpoint,w2.endpoint ,2))
    and w.usra_simple_id<>w2.usra_simple_id
    )
    group by w.usra_simple_id
)
update trt_metro.usra_work work
set endpointLinks=t.count 
from tmp t
where work.usra_simple_id=t.usra_simple_id;

with tmp as (
    select w.usra_simple_id,count(w.usra_simple_id) from trt_metro.usra_work w 
    inner join trt_metro.usra_work w2 on 
    ((st_dwithin(w.startpoint,w2.startpoint ,2)
    or
    st_dwithin(w.startpoint,w2.endpoint ,2))
    and w.usra_simple_id<>w2.usra_simple_id
    )
    group by w.usra_simple_id
)
update trt_metro.usra_work work
set startpointLinks=t.count 
from tmp t
where work.usra_simple_id=t.usra_simple_id;

with tmp as (
    select w.usra_simple_id  from trt_metro.usra_work w 
    inner join trt_metro.usra_work w2 on 
    (
	not(st_dwithin(w.endpoint,w2.startpoint ,2)
    or
    st_dwithin(w.endpoint,w2.endpoint ,2))
	and st_dwithin(w.endpoint,w2.geom ,2)
    and w.usra_simple_id<>w2.usra_simple_id
    )
    group by w.usra_simple_id
)
update trt_metro.usra_work work
set endpointLinks=2
from tmp t
where work.usra_simple_id=t.usra_simple_id;

with tmp as (
    select w.usra_simple_id from trt_metro.usra_work w 
    inner join trt_metro.usra_work w2 on 
    (not(st_dwithin(w.startpoint,w2.startpoint ,2)
    or
    st_dwithin(w.startpoint,w2.endpoint ,2))
	and st_dwithin(w.startpoint,w2.geom ,2)
    and w.usra_simple_id<>w2.usra_simple_id
    )
    group by w.usra_simple_id
)
update trt_metro.usra_work work
set startpointLinks=2
from tmp t
where work.usra_simple_id=t.usra_simple_id;

-- 1/ on cherche sur la ligne la plus proche, le point qui est le plus proche mais on ajoute un coefficient lié aux nombre de connections du noeud pour bien se caler
-- aux confluences
--prevent use of seq scan for this request
set enable_seqscan = off;
with tmp as (
    select u.usra_simple_id, t.geom, t.dist
    from trt_metro.usra_work u
          cross join lateral (
			  select *,dist/confluenceFactor as distWithFactor from (
			  	select *,
			  		CASE WHEN u.startpointLinks = v.nbLinks-1 THEN 7
					WHEN u.startpointLinks >= 2 AND v.nbLinks-1 > 2 THEN 5 
					ELSE 1
					END confluenceFactor
			  		from (
					select line.geom as geom_lines, 
					f.geom,
					line.geom <-> u.startpoint as dist_lines,
					f.geom <-> u.startpoint as dist
					from trt_metro.routing_all line
					inner join trt_metro.bdtopo_nodes f
					on ST_DWITHIN(line.geom,f.geom,0)
					where ST_DWITHIN(line.geom,u.startpoint,300)
				) s
				left join trt_metro.routing_all_vertices_pgr v
					on ST_DWITHIN(v.the_geom,s.geom,0)
				) dd
		 order by dist_lines,distWithFactor asc
		 limit 1
 ) as t
) update trt_metro.usra_work u set startpoint_nearest_bdtopo = t.geom,
                            startpoint_nearest_bdtopo_dist = t.dist,
                            startpoint_nearest_bdtopo_line = st_makeline(t.geom,st_startpoint(u.geom))
from tmp t
where u.usra_simple_id = t.usra_simple_id;

with tmp as (
    select u.usra_simple_id, t.geom, t.dist
    from trt_metro.usra_work u
          cross join lateral (
			  select *,dist/confluenceFactor as distWithFactor from (
			  	select *,
			  		CASE WHEN u.endpointLinks = v.nbLinks-1 THEN 7
					WHEN u.endpointLinks >= 2 AND v.nbLinks-1 > 2 THEN 5 
					ELSE 1
					END confluenceFactor
			  		from (
					select line.geom as geom_lines, 
					f.geom,
					line.geom <-> u.endpoint as dist_lines,
					f.geom <-> u.endpoint as dist
					from trt_metro.routing_all line
					inner join trt_metro.bdtopo_nodes f
					on ST_DWITHIN(line.geom,f.geom,0)
					where ST_DWITHIN(line.geom,u.endpoint,300)
				) s
				left join trt_metro.routing_all_vertices_pgr v
					on ST_DWITHIN(v.the_geom,s.geom,0)
				) dd
		 order by dist_lines,distWithFactor asc
		 limit 1
 ) as t
) update trt_metro.usra_work u set endpoint_nearest_bdtopo = t.geom,
                            endpoint_nearest_bdtopo_dist = t.dist,
                            endpoint_nearest_bdtopo_line = st_makeline(t.geom,st_endpoint(u.geom))
from tmp t
where u.usra_simple_id = t.usra_simple_id;

set enable_seqscan = on;


drop table trt_metro.routing_all_points_to_split ;
create table trt_metro.routing_all_points_to_split as
(
    select endpoint_nearest_bdtopo as geom 
    from 
        trt_metro.usra_work tgh
    left join trt_metro.routing_all_vertices_pgr nodes
    on 
        st_DWithin(tgh.endpoint_nearest_bdtopo,nodes.the_geom,0)
    where 
        nodes.id is null

    UNION ALL 
    select startpoint_nearest_bdtopo as geom 
    from 
        trt_metro.usra_work tgh
    left join trt_metro.routing_all_vertices_pgr nodes
    on 
        st_DWithin(tgh.startpoint_nearest_bdtopo,nodes.the_geom,0)
    where 
        nodes.id is null
	);


-- découpage du la table de routing 
-- *************************************************************
drop table if exists trt_metro.routing_usra_final_splitted;
drop table if exists points;
drop table if exists lines;
drop table if exists locus;
drop table if exists loc_with_idx;
create temporary table points as (
	select distinct(geom) from trt_metro.routing_all_points_to_split
);
create temporary table lines as (
	select row_number() over() as id,(l.dump).geom from (select ST_DUMP(geom) as dump from trt_metro.routing_all) l--,points p where st_dwithin(l.geom, p.geom, 0.01)
);
CREATE INDEX "sidx_points_geom"
    ON points USING gist
    (geom)
    TABLESPACE pg_default;
CREATE INDEX "sidx_lines_geom"
    ON lines USING gist
    (geom)
    TABLESPACE pg_default;
ALTER TABLE lines
  ADD CONSTRAINT lines_pkey PRIMARY KEY(id);
--ALTER TABLE points
--  ADD CONSTRAINT points_pkey PRIMARY KEY(id);
create temporary table locus as (
 -- on genere la position du debut de la ligne (index 0)  pour le premier segment à découper
    select l.id, 0 as l
    from lines l
    UNION ALL
        -- on genere la position de la fin de la ligne (index 1)  pour le dernier segment à découper
    select l.id, 1 as l
    from lines l
    UNION ALL

        -- calcul des positions des points par rapport aux lignes
    select l.id, ST_LineLocatePoint(l.geom, p.geom) as  l
    from lines l, points p
    where st_dwithin(l.geom, p.geom, 0.01) and ST_LineLocatePoint(l.geom, p.geom)>0 and ST_LineLocatePoint(l.geom, p.geom)<1
    order by id, l
);
-- deuxieme table qui ajoute un index croissant par position croissante, pour permettre de faire la jointure plus tard sur elle-meme:
create temporary table loc_with_idx as (
    select id, l, rank() over (partition by id order by l) as idx
    from locus
);
-- decoupage final de chaque ligne avec les positions des points sur la ligne, grace a st_line_substring
create table trt_metro.routing_usra_final_splitted as (select /*row_number() over () as id, */ST_LineSubstring(l.geom, loc1.l, loc2.l) as geom,'route' as obj_type
from loc_with_idx loc1, loc_with_idx loc2, lines l
where l.id = loc1.id
and loc1.id = loc2.id
and loc2.idx = loc1.idx+1);
-- *************************************************************
SET search_path TO trt_metro,public;


alter table trt_metro.routing_usra_final_splitted add column id int generated always as identity primary key ;
ALTER TABLE trt_metro.routing_usra_final_splitted  ADD COLUMN "source" integer;
ALTER TABLE trt_metro.routing_usra_final_splitted  ADD COLUMN "target" integer;
SELECT pgr_createTopology('routing_usra_final_splitted', 0.01, 'geom', 'id','source','target','true',true);

--Ajout d'une colonne avec le cout pour optimiser les temps de calcul ensuite
ALTER TABLE trt_metro.routing_usra_final_splitted
    ADD COLUMN cost float;

UPDATE trt_metro.routing_usra_final_splitted set cost=st_length(geom);


-- Ajout d'un cout avec la distance aux usra pour ameliorer le routing
ALTER TABLE trt_metro.routing_usra_final_splitted
    ADD COLUMN cost_usra float;

show work_mem;
-- 
with tmp as (
    select u.id, t.geom, t.dist
    from trt_metro.routing_usra_final_splitted u 
          cross join lateral (    
            select f.geom as geom, 
            f.geom <-> st_lineinterpolatepoint(u.geom,0.5) as dist
            from trt_metro.usra_work f
     order by dist asc
     limit 1
     ) as t
) 
update trt_metro.routing_usra_final_splitted u set cost_usra = t.dist
from tmp t
where u.id = t.id; --

-- creation de la table des usra a partir du nouveau reseau BD topo

drop table trt_metro.usra_all_new;
create table trt_metro.usra_all_new as ( 
select * from (
	select usra_simple_id,troncon_id,(pgr_dijkstra(
  'SELECT id, source, target, (cost+cost_usra*100) as cost, (cost+cost_usra*100) as reverse_cost 
  FROM trt_metro.routing_usra_final_splitted as s,
      (SELECT ST_Expand(ST_Extent(geom),20000) as box FROM trt_metro.usra_work as b
        WHERE b.usra_simple_id = '|| (SELECT tgh.usra_simple_id ) || ') as box WHERE s.geom && box.box',
 (select nodes.id as startid
  from trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(tgh.startpoint_nearest_bdtopo,nodes.the_geom,0)), 
	(select nodes.id as endid
    from
        trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(tgh.endpoint_nearest_bdtopo,nodes.the_geom,0)),
	true)).edge
	from trt_metro.usra_work tgh -- where usra_simple_id % 2 = 0
) as r 
join trt_metro.routing_usra_final_splitted t on r.edge = t.id
); -- 30 min


-- fin optim perfs
create index on trt_metro.usra_all_new using gist(geom);


-- Union des geom

drop table trt_metro.usra_all_new_union;
create table trt_metro.usra_all_new_union  as(
	select usra_simple_id,troncon_id,ST_LineMerge(ST_UNION(geom)) as geom 
from trt_metro.usra_all_new
group by usra_simple_id,troncon_id
) ;

create index on trt_metro.usra_all_new_union using gist(geom);


-- 1ere analyse intersections entre USRA
drop table trt_metro.usra_all_new_union_intersections;
create table trt_metro.usra_all_new_union_intersections as (
    select 
        ST_LineMerge(ST_Intersection(u.geom,u2.geom)) as geominter,
        u.geom as geom1,
        u2.geom as geom2,
        u.usra_simple_id as id1,
        u2.usra_simple_id as id2 
    from trt_metro.usra_all_new_union u
    inner join trt_metro.usra_all_new_union u2
        on ST_Overlaps(u.geom,u2.geom)
    where u.usra_simple_id<u2.usra_simple_id
);


create index on trt_metro.usra_all_new_union_intersections using gist(geominter);


-- supprimer les intersections si l'intersection n'est pas connectés aux usra de chaque coté
drop table if exists intertoremovecompletely;
create temporary table intertoremovecompletely as (
    select * from trt_metro.usra_all_new_union_intersections 
	where id1 not in(
		 select 
		id1 as idinter from trt_metro.usra_all_new_union_intersections i
		 inner join trt_metro.usra_all_new_union un
		 on st_dwithin(un.geom,geominter,0)
		inner join trt_metro.usra_all_new_union un2
		 on st_dwithin(un2.geom,geominter,0)
			where 
			st_intersects(st_startpoint(ST_LineMerge(geominter)),ST_Difference(un.geom,geominter)) 
			and st_intersects(st_endpoint(ST_LineMerge(geominter)),ST_Difference(un2.geom,geominter))
			--and id1=54
	group by id1
	)
);

update trt_metro.usra_all_new_union u 
set geom=ST_Difference(geom1,geominter) from intertoremovecompletely inter where u.usra_simple_id=inter.id1;

update trt_metro.usra_all_new_union u 
set geom=ST_Difference(geom2,geominter) from intertoremovecompletely inter where u.usra_simple_id=inter.id2;

--

alter table trt_metro.usra_all_new_union_intersections add column angle1 float;

alter table trt_metro.usra_all_new_union_intersections add column angle2 float;

update trt_metro.usra_all_new_union_intersections 
set angle1=abs(sin(st_angle(ST_LineMerge(geominter),ST_Difference(geom1,geominter)))),
angle2=abs(sin(st_angle(ST_LineMerge(geominter),ST_Difference(geom2,geominter))));

update trt_metro.usra_all_new_union_intersections 
set geom1=ST_Difference(geom1,geominter)
where angle1>angle2 or (angle2 is null and angle1 is not null);

update trt_metro.usra_all_new_union_intersections 
set geom2=ST_Difference(geom2,geominter)
where angle1<angle2 or (angle1 is null and angle2 is not null);

-- mise à jour des geom pour supprimer les intersections en doublons
with intern as (
    select id1 as idinter,geom1 from trt_metro.usra_all_new_union_intersections i
    where angle1>angle2 or (angle2 is null and angle1 is not null)
)
update trt_metro.usra_all_new_union u 
set geom=inter.geom1 from intern inter where u.usra_simple_id=inter.idinter;

with intern as (
    select id2 as idinter,geom2 from trt_metro.usra_all_new_union_intersections 
    where angle1<angle2 or (angle1 is null and angle2 is not null)
)
update trt_metro.usra_all_new_union u 
set geom=inter.geom2 from intern inter where u.usra_simple_id=inter.idinter;

--recalcul de l'intersection
-- => cf plus haut
-- boucler plusieurs fois sur ce process d intersections pour avoir une couche clean 
drop table trt_metro.usra_all_new_union_intersections;
create table trt_metro.usra_all_new_union_intersections as (
    select 
        ST_LineMerge(ST_Intersection(u.geom,u2.geom)) as geominter,
        u.geom as geom1,
        u2.geom as geom2,
        u.usra_simple_id as id1,
        u2.usra_simple_id as id2 
    from trt_metro.usra_all_new_union u
    inner join trt_metro.usra_all_new_union u2
        on ST_Overlaps(u.geom,u2.geom)
    where u.usra_simple_id<u2.usra_simple_id
);
create index on trt_metro.usra_all_new_union_intersections using gist(geominter);


-- 2ieme passe
alter table trt_metro.usra_all_new_union_intersections add column angle1 float;

alter table trt_metro.usra_all_new_union_intersections add column angle2 float;

update trt_metro.usra_all_new_union_intersections 
set angle1=abs(sin(st_angle(ST_LineMerge(geominter),ST_Difference(geom1,geominter)))),
angle2=abs(sin(st_angle(ST_LineMerge(geominter),ST_Difference(geom2,geominter))));

update trt_metro.usra_all_new_union_intersections 
set geom1=ST_Difference(geom1,geominter)
where angle1>angle2 or (angle2 is null and angle1 is not null);

update trt_metro.usra_all_new_union_intersections 
set geom2=ST_Difference(geom2,geominter)
where angle1<angle2 or (angle1 is null and angle2 is not null);

-- mise à jour des geom pour supprimer les intersections en doublons
with intern as (
    select id1 as idinter,geom1 from trt_metro.usra_all_new_union_intersections i
    where angle1>angle2 or (angle2 is null and angle1 is not null)
)
update trt_metro.usra_all_new_union u 
set geom=inter.geom1 from intern inter where u.usra_simple_id=inter.idinter;

with intern as (
    select id2 as idinter,geom2 from trt_metro.usra_all_new_union_intersections 
    where angle1<angle2 or (angle1 is null and angle2 is not null)
)
update trt_metro.usra_all_new_union u 
set geom=inter.geom2 from intern inter where u.usra_simple_id=inter.idinter;

drop table trt_metro.usra_all_new_union_intersections;
create table trt_metro.usra_all_new_union_intersections as (
    select 
        ST_LineMerge(ST_Intersection(u.geom,u2.geom)) as geominter,
        u.geom as geom1,
        u2.geom as geom2,
        u.usra_simple_id as id1,
        u2.usra_simple_id as id2 
    from trt_metro.usra_all_new_union u
    inner join trt_metro.usra_all_new_union u2
        on ST_Overlaps(u.geom,u2.geom)
    where u.usra_simple_id<u2.usra_simple_id
);
create index on trt_metro.usra_all_new_union_intersections using gist(geominter);



---
--- 1er calcul de discontinuité avant corrections
drop table trt_metro.usra_all_new_union_discontinuite;
create table trt_metro.usra_all_new_union_discontinuite as
select e.*, t.dist,t.usra_simple_id_nearest
from trt_metro.usra_all_new_union e cross join lateral (
    select u.usra_simple_id as usra_simple_id_nearest, u.geom <-> st_endpoint(e.geom) as dist
    from trt_metro.usra_all_new_union u
    where u.usra_simple_id <> e.usra_simple_id
    order by u.geom <-> st_endpoint(e.geom)
    limit 1
    ) as t
where t.dist > 0 ;


create index on trt_metro.usra_all_new_union_discontinuite using gist(geom);
alter table trt_metro.usra_all_new_union_discontinuite add column frontier_dist float;
alter table trt_metro.usra_all_new_union_discontinuite add column frontier_src text;

with tmp as (
    select u.usra_simple_id, t.id_frontier, t.source, t.dist
    from trt_metro.usra_all_new_union_discontinuite u
          cross join lateral (
     select id as id_frontier, source, f.geom <-> st_endpoint(u.geom) as dist
     from frontier f
     order by f.geom <-> st_endpoint(u.geom)
     limit 1
     ) as t
) update trt_metro.usra_all_new_union_discontinuite u set frontier_dist = t.dist,
                            frontier_src = t.source
from tmp t
where u.usra_simple_id = t.usra_simple_id;


-- test comblement discontinuité

drop table trt_metro.usra_all_new_union_discontinuite_corr;
create table trt_metro.usra_all_new_union_discontinuite_corr as(
	with discont as (
select * from trt_metro.usra_all_new_union_discontinuite where 
	"frontier_dist">1000 and "dist">0
)
select e.*, t.dist as distnearest,t.usra_simple_id_nearest2,t.nearest_geom,st_makeline(st_endpoint(e.geom),
																					   ST_ClosestPoint(t.nearest_geom, e.geom))
from discont e cross join lateral (
with cluster as (
select f.geom as origin,ST_CollectionExtract(unnest(ST_ClusterIntersecting(e2.geom))) as geom 
	from trt_metro.usra_all_new_union_discontinuite f
    inner join trt_metro.usra_all_new_union e2
    on ST_DWITHIN(f.geom,e2.geom,10000)
    where f.usra_simple_id=e.usra_simple_id
    group by f.geom
)
,cluster2 as (
	select * from cluster c where ST_intersects(c.origin,c.geom)
)   -- priorité aux usra qui sont a moins de 150m
	select * from (
        (select u.usra_simple_id as usra_simple_id_nearest2, 
			u.geom <-> st_endpoint(e.geom) as dist,
			u.geom as nearest_geom
		from trt_metro.usra_all_new_union u,cluster2
		where u.usra_simple_id <> e.usra_simple_id and not ST_intersects(u.geom,cluster2.geom)
		 and ST_DWITHIN(u.geom,st_endpoint(e.geom),150)
		order by u.geom <-> st_endpoint(e.geom)
		limit 1
		 )
    -- puis priorité aux usra qui ont le meme id de troncon meme si plus loin     
	UNION ALL
        (select u.usra_simple_id as usra_simple_id_nearest2, 
			u.geom <-> st_endpoint(e.geom) as dist,
			u.geom as nearest_geom
		from trt_metro.usra_all_new_union u,cluster2
		where u.usra_simple_id <> e.usra_simple_id and u.troncon_id=e.troncon_id
		and not ST_intersects(u.geom,cluster2.geom)
		order by u.geom <-> st_endpoint(e.geom)
		limit 1)
	UNION ALL
		(select u.usra_simple_id as usra_simple_id_nearest2, 
			u.geom <-> st_endpoint(e.geom) as dist,
			u.geom as nearest_geom
		from trt_metro.usra_all_new_union u,cluster2
		where u.usra_simple_id <> e.usra_simple_id and not ST_intersects(u.geom,cluster2.geom)
		order by u.geom <-> st_endpoint(e.geom)
		limit 1
		 )) as c limit 1
    ) as t
where t.dist > 0 --and e.usra_simple_id=15731
);

-- ajout du point vers lequel faire le routing
-- on veut router vers le startPoint d'une usra 
alter table trt_metro.usra_all_new_union_discontinuite_corr add column point_to_route geometry;
with tmp as (
    select u.usra_simple_id,t.dist,t.ge
    from trt_metro.usra_all_new_union_discontinuite_corr u
          cross join lateral (    
            select ST_StartPoint(u2.nearest_geom) as ge,
            ST_StartPoint(u2.nearest_geom) <-> st_endpoint(u.geom) as dist
            from trt_metro.usra_all_new_union_discontinuite_corr u2
			 where u2.usra_simple_id=u.usra_simple_id
     order by dist asc
     limit 1
     ) as t
)update trt_metro.usra_all_new_union_discontinuite_corr u set point_to_route = t.ge
from tmp t
where u.usra_simple_id = t.usra_simple_id;




create index on trt_metro.usra_all_new_union_discontinuite_corr using gist(geom);

-- routing des troncons fictifs (ici routing non orienté qui peut donner des resultats faux mais comble plus de discontinuités)
drop table trt_metro.usra_all_new_fictif_non_oriented;
create table trt_metro.usra_all_new_fictif_non_oriented as ( 
select * from (
	select usra_simple_id,troncon_id,(pgr_dijkstra(
  'SELECT id, source, target, (cost) as cost, (cost) as reverse_cost 
  FROM trt_metro.routing_usra_final_splitted as s,
      (SELECT ST_Expand(ST_Extent(geom),20000) as box FROM trt_metro.usra_all_new_union_discontinuite_corr as b
        WHERE b.usra_simple_id = '|| (SELECT tgh.usra_simple_id ) || ') as box WHERE s.geom && box.box',
 (select nodes.id as startid
  from trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(st_endpoint(tgh.geom),nodes.the_geom,0)), 
	(select nodes.id as endid
    from
        trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(tgh.point_to_route,nodes.the_geom,0)),
	true)).edge
	from trt_metro.usra_all_new_union_discontinuite_corr tgh 
) as r 
join trt_metro.routing_usra_final_splitted t on r.edge = t.id
) ;

create index on trt_metro.usra_all_new_fictif_non_oriented using gist(geom);
with intern as (
select f.usra_simple_id,ST_UNION(ST_Intersection(un.geom,f.geom)) as intergeom 
	from trt_metro.usra_all_new_fictif_non_oriented f
	inner join trt_metro.usra_all_new un
		 on st_dwithin(un.geom,f.geom,0)
	where st_intersects(un.geom,f.geom) 
	group by f.usra_simple_id
)
update trt_metro.usra_all_new_fictif_non_oriented u 
set geom=ST_Difference(geom,intergeom) 
from intern inter where u.usra_simple_id=inter.usra_simple_id;


drop table trt_metro.usra_all_new_fictif2 ;
create table trt_metro.usra_all_new_fictif2 as ( 
select * from (
	select usra_simple_id,troncon_id,(pgr_dijkstra(
  'SELECT id, source, target, (cost) as cost, -1 as reverse_cost 
  FROM trt_metro.routing_usra_final_splitted as s,
      (SELECT ST_Expand(ST_Extent(geom),20000) as box FROM trt_metro.usra_all_new_fictif_non_oriented as b
        WHERE b.usra_simple_id = '|| (SELECT tgh.usra_simple_id ) || ') as box WHERE s.geom && box.box',
 (select nodes.id as startid
  from trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(st_endpoint(tgh.geom),nodes.the_geom,0)), 
		
	(select nodes.id as endid
    from
        trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(st_startpoint(tgh.geom),nodes.the_geom,0)),
	true)).edge
	from trt_metro.usra_all_new_fictif_non_oriented tgh 
) as r 
join trt_metro.routing_usra_final_splitted t on r.edge = t.id
) ;

insert into trt_metro.usra_all_new_fictif2 ( 
select * from (
	select usra_simple_id,troncon_id,(pgr_dijkstra(
  'SELECT id, source, target, (cost) as cost, -1 as reverse_cost 
  FROM trt_metro.routing_usra_final_splitted as s,
      (SELECT ST_Expand(ST_Extent(geom),20000) as box FROM trt_metro.usra_all_new_fictif_non_oriented as b
        WHERE b.usra_simple_id = '|| (SELECT tgh.usra_simple_id ) || ') as box WHERE s.geom && box.box',
 (select nodes.id as startid
  from trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(st_startpoint(tgh.geom),nodes.the_geom,0)), 
		
	(select nodes.id as endid
    from
        trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(st_endpoint(tgh.geom),nodes.the_geom,0)),
	true)).edge
	from trt_metro.usra_all_new_fictif_non_oriented tgh 
) as r 
join trt_metro.routing_usra_final_splitted t on r.edge = t.id
) ;

create index on trt_metro.usra_all_new_fictif2 using gist(geom);
-- on enleve des troncons fictifs les parties qui sont déjà dans la couche usra
with intern as (
select f.usra_simple_id,ST_UNION(ST_Intersection(un.geom,f.geom)) as intergeom from trt_metro.usra_all_new_fictif2 f
	inner join trt_metro.usra_all_new un
		 on st_dwithin(un.geom,f.geom,0)
	where st_intersects(un.geom,f.geom) 
	group by f.usra_simple_id
)
update trt_metro.usra_all_new_fictif2 u 
set geom=ST_Difference(geom,intergeom) 
from intern inter where u.usra_simple_id=inter.usra_simple_id;




-- compter les différences de taille d'usra 

drop table trt_metro.usra_too_big ;
create table trt_metro.usra_too_big as ( 
select unionu.* from trt_metro.usra_all_new_union unionu, trt_metro.usra_work work 
where work.usra_simple_id=unionu.usra_simple_id 
and (GREATEST(st_length(work.geom),st_length(unionu.geom))/LEAST(st_length(work.geom),st_length(unionu.geom))>2)
);


-- export avec les anciens ID usras
-- create table trt_metro.usra_all_new_union_allattributes as 
-- (select u.*,s.usra_id,si.id_usra_dd from trt_metro.usra_all_new_union u 
-- left join syrah.usra_simple s on s.usra_simple_id=u.usra_simple_id
-- left join syrah.usra si on s.usra_id=si.usra_id)


----------------------------------------------------------------------------
-- Union des usra pour reformer les TGH (fait plus loin inutile a ce stade)

drop table if exists trt_metro.tgh_from_usra_all_new_union;
create table trt_metro.tgh_from_usra_all_new_union  as(
	select troncon_id,ST_LineMerge(ST_UNION(geom)) as geom 
from trt_metro.usra_all_new_union
group by troncon_id
) ;

create index on trt_metro.tgh_from_usra_all_new_union using gist(geom);
alter table trt_metro.tgh_from_usra_all_new_union add column num_geom integer;
update trt_metro.tgh_from_usra_all_new_union u set num_geom = ST_NumGeometries(u.geom);
-- 
----------------------------------------------------------------------------




-- UNION des troncons fictifs
drop table if exists trt_metro.usra_all_new_fictif2_union;
create table trt_metro.usra_all_new_fictif2_union  as(
	select usra_simple_id,ST_LineMerge(ST_UNION(geom)) as geom 
from trt_metro.usra_all_new_fictif2
group by usra_simple_id
) ;
create index on trt_metro.usra_all_new_fictif2_union using gist(geom);


-- fusionner les troncons fictifs dans les usra si les usra amont aval ont le meme id de troncon
with intern as(
    select fe.*,f.geom as fict_geom from trt_metro.usra_all_new_union_discontinuite d
    inner join trt_metro.usra_all_new_fictif2_union f on st_dwithin(st_endpoint(d.geom),st_startpoint(f.geom),0)
    inner join trt_metro.usra_all_new_union fe on st_dwithin(st_endpoint(f.geom),st_startpoint(fe.geom),0)
    where d.troncon_id=fe.troncon_id
)
update trt_metro.usra_all_new_union u 
set geom=ST_LineMerge(ST_UNION(u.geom,fict_geom)) 
from intern inter where u.usra_simple_id=inter.usra_simple_id;

-- recalcul des discontinuités
---
--- 2eme calcul de discontinuité avant corrections -- 12 sec
drop table trt_metro.usra_all_new_union_discontinuite;
create table trt_metro.usra_all_new_union_discontinuite as
select e.*, t.dist,t.usra_simple_id_nearest
from trt_metro.usra_all_new_union e cross join lateral (
    select u.usra_simple_id as usra_simple_id_nearest, u.geom <-> st_endpoint(e.geom) as dist
    from trt_metro.usra_all_new_union u
    where u.usra_simple_id <> e.usra_simple_id
    order by u.geom <-> st_endpoint(e.geom)
    limit 1
    ) as t
where t.dist > 0 ;


create index on trt_metro.usra_all_new_union_discontinuite using gist(geom);
alter table trt_metro.usra_all_new_union_discontinuite add column frontier_dist float;
alter table trt_metro.usra_all_new_union_discontinuite add column frontier_src text;

with tmp as (
    select u.usra_simple_id, t.id_frontier, t.source, t.dist
    from trt_metro.usra_all_new_union_discontinuite u
          cross join lateral (
     select id as id_frontier, source, f.geom <-> st_endpoint(u.geom) as dist
     from frontier f
     order by f.geom <-> st_endpoint(u.geom)
     limit 1
     ) as t
) update trt_metro.usra_all_new_union_discontinuite u set frontier_dist = t.dist,
                            frontier_src = t.source
from tmp t
where u.usra_simple_id = t.usra_simple_id;

-- on créé des troncon fictif pour combler les discontinuités : ceux ci sont fiable car le depart et l'arrivée tombe sur une extremité d'USRA 
-- mais on ne peut pas attribuer de toncon_id
drop table trt_metro.usra_all_new_union_discontinuite_fixture;
create table trt_metro.usra_all_new_union_discontinuite_fixture as (
    select f.geom as geom from trt_metro.usra_all_new_union_discontinuite d
    inner join trt_metro.usra_all_new_fictif2_union f on st_dwithin(st_endpoint(d.geom),st_startpoint(f.geom),0)
    inner join trt_metro.usra_all_new_union fe on st_dwithin(st_endpoint(f.geom),st_startpoint(fe.geom),0)
    where d.troncon_id<>fe.troncon_id
);
create index on trt_metro.usra_all_new_union_discontinuite_fixture using gist(geom);
alter table trt_metro.usra_all_new_union_discontinuite_fixture add column id int generated always as identity primary key;


-- on créé des troncon fictif pour combler les discontinuités : ceux ci arrivent au milieu d'une USRA mais font moins de 300m 
--donc il s'agit d'un bout manquant de l'affluent
drop table trt_metro.usra_all_new_union_discontinuite_fixture_affluent;
create table trt_metro.usra_all_new_union_discontinuite_fixture_affluent as (
    select f.geom as geom from trt_metro.usra_all_new_union_discontinuite d
    inner join trt_metro.usra_all_new_fictif2_union f on st_dwithin(st_endpoint(d.geom),st_startpoint(f.geom),0)
    inner join trt_metro.usra_all_new_union fe on st_dwithin(st_endpoint(f.geom),fe.geom,0)
    where d.troncon_id<>fe.troncon_id and not st_dwithin(st_endpoint(f.geom),st_startpoint(fe.geom),0) and st_length(f.geom)<300
);
create index on trt_metro.usra_all_new_union_discontinuite_fixture_affluent using gist(geom);
alter table trt_metro.usra_all_new_union_discontinuite_fixture_affluent add column id int generated always as identity primary key;


-- on peut les fusionner avec l'affluent
with intern as(
    select d.*,f.geom as fict_geom from trt_metro.usra_all_new_union_discontinuite d
    inner join trt_metro.usra_all_new_union_discontinuite_fixture_affluent f on st_dwithin(st_endpoint(d.geom),st_startpoint(f.geom),0)
)
update trt_metro.usra_all_new_union u 
set geom=ST_LineMerge(ST_UNION(u.geom,fict_geom)) 
from intern inter where u.usra_simple_id=inter.usra_simple_id;

-- on créé des troncon fictif pour combler les discontinuités : ceux ci sont problématiques car ils arrivent au milieu d'une USRA et font plus de 300m
drop table trt_metro.usra_all_new_union_discontinuite_fixture_to_check;
create table trt_metro.usra_all_new_union_discontinuite_fixture_to_check as (
    select f.geom as geom from trt_metro.usra_all_new_union_discontinuite d
    inner join trt_metro.usra_all_new_fictif2_union f on st_dwithin(st_endpoint(d.geom),st_startpoint(f.geom),0)
    inner join trt_metro.usra_all_new_union fe on st_dwithin(st_endpoint(f.geom),fe.geom,0)
    where d.troncon_id<>fe.troncon_id and not st_dwithin(st_endpoint(f.geom),st_startpoint(fe.geom),0) and st_length(f.geom)>=300
);
create index on trt_metro.usra_all_new_union_discontinuite_fixture_to_check using gist(geom);
alter table trt_metro.usra_all_new_union_discontinuite_fixture_to_check add column id int generated always as identity primary key;









-- on recréé les TGH
drop table if exists trt_metro.tgh_from_usra_all_new_union;
create table trt_metro.tgh_from_usra_all_new_union  as(
	select troncon_id,ST_LineMerge(ST_UNION(geom)) as geom 
from trt_metro.usra_all_new_union
group by troncon_id
) ;

create index on trt_metro.tgh_from_usra_all_new_union using gist(geom);

alter table trt_metro.tgh_from_usra_all_new_union add column num_geom integer;

update trt_metro.tgh_from_usra_all_new_union u set num_geom = ST_NumGeometries(u.geom);



-----------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------
-- discontinuité inter tgh - test 
-----------------------------------------------------------------------------------------------------
drop table trt_metro.tgh_final_discontinuite;
create table trt_metro.tgh_final_discontinuite as (
    select 
    troncon_id,
    CASE WHEN ST_EndPoint(ST_GeometryN(geom,1))<->ST_StartPoint(ST_GeometryN(geom,2))<ST_EndPoint(ST_GeometryN(geom,2))<->ST_StartPoint(ST_GeometryN(geom,1)) THEN 
        ST_EndPoint(ST_GeometryN(geom,1)) 
        ELSE ST_EndPoint(ST_GeometryN(geom,2)) 
        END endpointgeom,
    CASE WHEN ST_EndPoint(ST_GeometryN(geom,1))<->ST_StartPoint(ST_GeometryN(geom,2))<ST_EndPoint(ST_GeometryN(geom,2))<->ST_StartPoint(ST_GeometryN(geom,1)) THEN 
        ST_StartPoint(ST_GeometryN(geom,2)) 
        ELSE ST_StartPoint(ST_GeometryN(geom,1)) 
        END startpointgeom  
 from trt_metro.tgh_from_usra_all_new_union where num_geom=2
);

drop table trt_metro.tgh_final_discontinuite_fix ;
create table trt_metro.tgh_final_discontinuite_fix as ( 
select * from (
	select troncon_id,(pgr_dijkstra(
  'SELECT id, source, target, (cost) as cost, -1 as reverse_cost 
  FROM trt_metro.routing_usra_final_splitted as s,
      (SELECT ST_Expand(ST_Extent(endpointgeom),20000) as box FROM trt_metro.tgh_final_discontinuite as b
        WHERE b.troncon_id = '|| (SELECT tgh.troncon_id ) || ') as box WHERE s.geom && box.box',
 (select nodes.id as startid
  from trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(tgh.endpointgeom,nodes.the_geom,0)), 
		
	(select nodes.id as endid
    from
        trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(tgh.startpointgeom,nodes.the_geom,0)),
	true)).edge
	from trt_metro.tgh_final_discontinuite tgh 
) as r 
join trt_metro.routing_usra_final_splitted t on r.edge = t.id
) ;

insert into trt_metro.tgh_final_discontinuite_fix ( 
select * from (
	select troncon_id,(pgr_dijkstra(
  'SELECT id, source, target, (cost) as cost, -1 as reverse_cost 
  FROM trt_metro.routing_usra_final_splitted as s,
      (SELECT ST_Expand(ST_Extent(endpointgeom),20000) as box FROM trt_metro.tgh_final_discontinuite as b
        WHERE b.troncon_id = '|| (SELECT tgh.troncon_id ) || ') as box WHERE s.geom && box.box',
 (select nodes.id as startid
  from trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(tgh.startpointgeom,nodes.the_geom,0)), 
		
	(select nodes.id as endid
    from
        trt_metro.routing_usra_final_splitted_vertices_pgr nodes
    where st_DWithin(tgh.endpointgeom,nodes.the_geom,0)),
	true)).edge
	from trt_metro.tgh_final_discontinuite tgh 
) as r 
join trt_metro.routing_usra_final_splitted t on r.edge = t.id
) ;

create index on trt_metro.tgh_final_discontinuite_fix using gist(geom);

-- UNION des troncons fictifs
drop table if exists trt_metro.tgh_final_discontinuite_fix_union;
create table trt_metro.tgh_final_discontinuite_fix_union  as(
	select troncon_id,ST_LineMerge(ST_UNION(geom)) as geom 
from trt_metro.tgh_final_discontinuite_fix
group by troncon_id
) ;
create index on trt_metro.tgh_final_discontinuite_fix_union using gist(geom);


-- fusionner les troncons fictifs dans les usra si les usra amont aval ont le meme id de troncon
with intern as(
    select * from trt_metro.tgh_final_discontinuite_fix_union d
)
update trt_metro.tgh_from_usra_all_new_union u 
set geom=ST_LineMerge(ST_UNION(u.geom,inter.geom)) 
from intern inter where u.troncon_id=inter.troncon_id;

update trt_metro.tgh_from_usra_all_new_union u set num_geom = ST_NumGeometries(u.geom);







-- création table finale en récupérant les attributs des TGH
drop table trt_metro.tgh_final;
create table trt_metro.tgh_final as (
select u.geom as new_geom,u.num_geom,tgh.*  from trt_metro.tgh_from_usra_all_new_union u
inner join syrah.tgh tgh on tgh.troncon_id=u.troncon_id);

alter table trt_metro.tgh_final drop column geom;
alter table trt_metro.tgh_final rename column new_geom TO geom;
create index on trt_metro.tgh_final using gist(geom);

-- insertion des usras tmpe qui n'ont pas de tgh
insert into trt_metro.tgh_final(geom,num_geom,troncon_id,rang,cgenelin,agence,toponyme,longueur,coorx_am,coory_am,coorx_av,coory_av) (
select u.geom,u.num_geom,u.troncon_id,
	-9 as rang,
	'' as cgenelin,
	'' as agence,
	'' as toponyme,
	st_length(u.geom) as longueur,
	st_x(ST_StartPoint(u.geom)) as coorx_am,
	st_y(ST_StartPoint(u.geom)) as coory_am,
	st_x(ST_EndPoint(u.geom)) as coorx_av,
	st_y(ST_EndPoint(u.geom)) as coory_av
from trt_metro.tgh_from_usra_all_new_union u
left join syrah.tgh tgh on tgh.troncon_id=u.troncon_id
where tgh.troncon_id is null 
);


-- recupération du rang et toponyme dans les usra syrah d'origine
with intern as (
    select u.troncon_id,orig.rang,orig.toponyme from trt_metro.tgh_final u 
    left join syrah.tgh tgh on tgh.troncon_id=u.troncon_id
    left join syrah.usra_simple s on u.troncon_id=s.id_troncon
    left join syrah.usra orig on s.usra_id=orig.usra_id
    where tgh.troncon_id is null 
    group by u.troncon_id,orig.rang,orig.toponyme
)
update trt_metro.tgh_final u 
set rang=inter.rang,
toponyme=inter.toponyme
from intern inter where u.troncon_id=inter.troncon_id;




-- transformation en geometrie simple pour des calcul de longeur juste 
-- ((troncon_id+1000000)::text||((st_dump(geom)).path[1]-1)::text)::integer => pour éviter les doublons d'id quand on a des problemes sur 2 id consecutifs

drop table if exists trt_metro.tgh_final_simple;
create table trt_metro.tgh_final_simple as
    select (st_dump(geom)).geom,(st_dump(geom)).path[1],
	num_geom, ((troncon_id+1000000)::text||((st_dump(geom)).path[1]-1)::text)::integer as troncon_id,troncon_id as origine_troncon_id, cgenelin, rang, agence, toponyme, longueur, coorx_am, coory_am, coorx_av, coory_av, alt_am, alt_av, pente_lit, surf_bv, larg_fdv, qspe_crue, pente_val, largeur_pb, rap_encais
    from trt_metro.tgh_final where num_geom>1;

delete from trt_metro.tgh_final where num_geom>1;
alter table trt_metro.tgh_final add column origine_troncon_id integer;
insert into trt_metro.tgh_final (geom, num_geom, troncon_id, cgenelin, rang, agence, toponyme, longueur, coorx_am, coory_am, coorx_av, coory_av, alt_am, alt_av, pente_lit, surf_bv, larg_fdv, qspe_crue, pente_val, largeur_pb, rap_encais, origine_troncon_id)
 (select geom, num_geom, troncon_id, cgenelin, rang, agence, toponyme, longueur, coorx_am, coory_am, coorx_av, coory_av, alt_am, alt_av, pente_lit, surf_bv, larg_fdv, qspe_crue, pente_val, largeur_pb, rap_encais, origine_troncon_id from trt_metro.tgh_final_simple);



-- récupération de la valeur de largeur_pb
with intern as (
    select * from trt_metro.tgh_final u 
    left join trt_metro."Largeurs_complementaires_SYRAH" l on l."ID_TRONCON"::integer=u.troncon_id
    where u.largeur_pb is null or u.largeur_pb =0

)
update trt_metro.tgh_final u 
set largeur_pb=inter."W"::float
from intern inter where u.troncon_id=inter.troncon_id;

with intern as (
    select * from trt_metro.tgh_final u 
    left join trt_metro."Largeurs_complementaires_SYRAH" l on l."ID_TRONCON"::integer=u.origine_troncon_id
    where u.largeur_pb is null or u.largeur_pb =0

)
update trt_metro.tgh_final u 
set largeur_pb=inter."W"::float
from intern inter where u.troncon_id=inter.troncon_id;

-- infos fournis par loic sur les 3 largeurs manquantes
update trt_metro.tgh_final u  
set largeur_pb=7 where troncon_id=602392;

update trt_metro.tgh_final u  
set largeur_pb=4 where troncon_id=602393;

update trt_metro.tgh_final u  
set largeur_pb=20 where troncon_id=602394;


-- récupération infos drain principal et q_etiage_n
alter table trt_metro.tgh_final add column drain_prin text;
alter table trt_metro.tgh_final add column q_etiage_n text;

with tmp as (
    select u.troncon_id,t.drain_prin,t.q_etiage_n from trt_metro.tgh_final u
    cross join lateral (
    select l.drain_prin,l.q_etiage_n from syrah.usra_2017_donnees_entree_bayesien_v2 l
        where l.id_troncon::integer=u.troncon_id
    limit 1) as t
    
)
update trt_metro.tgh_final u set drain_prin = t.drain_prin,q_etiage_n=t.q_etiage_n
from tmp t
where u.troncon_id = t.troncon_id;

with tmp as (
    select u.troncon_id,t.drain_prin,t.q_etiage_n from trt_metro.tgh_final u
    cross join lateral (
    select l.drain_prin,l.q_etiage_n from syrah.usra_2017_donnees_entree_bayesien_v2 l
        where l.id_troncon::integer=u.origine_troncon_id
    limit 1) as t
    where u.drain_prin is null
    
)
update trt_metro.tgh_final u set drain_prin = t.drain_prin,q_etiage_n=t.q_etiage_n
from tmp t
where u.troncon_id = t.troncon_id;


-- update longeur et coordonnées amon aval
update trt_metro.tgh_final
set longueur=ROUND(st_length(geom)::numeric,2),
coorx_am = st_x(ST_StartPoint(geom)),
coory_am = st_y(ST_StartPoint(geom)),
coorx_av = st_x(ST_EndPoint(geom)),
coory_av = st_y(ST_EndPoint(geom));

-- add columns for altitude calculation
alter table trt_metro.tgh_final add column alt_am_new float;
alter table trt_metro.tgh_final add column alt_av_new float;
alter table trt_metro.tgh_final add column pente_lit_new float;

drop table trt_metro.tgh_from_usra_all_new_union_cluster;
create table trt_metro.tgh_from_usra_all_new_union_cluster as
select st_unaryunion(unnest(st_clusterintersecting(geom))) as geom
from trt_metro.tgh_from_usra_all_new_union;

create index on trt_metro.tgh_from_usra_all_new_union_cluster using gist(geom);
alter table trt_metro.tgh_from_usra_all_new_union_cluster add column id int generated always as identity primary key;
-- vacuum analyze trt_metro.tgh_from_usra_all_new_union_cluster;


alter table trt_metro.tgh_from_usra_all_new_union_cluster add column frontier_dist float;
alter table trt_metro.tgh_from_usra_all_new_union_cluster add column frontier_src text;

with tmp as (
    select u.id, t.id_frontier, t.source, t.dist
    from trt_metro.tgh_from_usra_all_new_union_cluster u
          cross join lateral (
     select id as id_frontier, source, f.geom <-> u.geom as dist
     from frontier f
     order by f.geom <-> u.geom
     limit 1
     ) as t
) update trt_metro.tgh_from_usra_all_new_union_cluster u set frontier_dist = t.dist,
                            frontier_src = t.source
from tmp t
where u.id = t.id;

drop table trt_metro.tgh_from_usra_all_new_union_cluster_div;
create table trt_metro.tgh_from_usra_all_new_union_cluster_div as (
    select ST_Subdivide(geom,50) as geom,c.frontier_src,c.frontier_dist 
    from trt_metro.tgh_from_usra_all_new_union_cluster c
);
create index on trt_metro.tgh_from_usra_all_new_union_cluster_div using gist(geom);



-- génération des USRAs => taille max 1km
--nb usra pour 1 TGH = floor(taille TGH / 1000 )

drop table trt_metro.usra_final;
CREATE TABLE trt_metro.usra_final AS (
    WITH
    data AS (
        SELECT troncon_id,geom,
        CASE WHEN rang = 1 THEN 300 
        WHEN rang = 2 THEN 600
        WHEN rang = 3 THEN 1100
        WHEN rang = 4 THEN 2000
        WHEN rang = 5 THEN 4500
        WHEN rang = 6 THEN 12500
        WHEN rang = 7 THEN 22000
        WHEN rang = 8 THEN 40000
        ELSE 1000
        END size_usra FROM trt_metro.tgh_final
    )
    SELECT troncon_id,troncon_id||'_'||(i+1) usra_id_str,i+1 usra_index,ST_LineSubstring( d.geom, substart, 
        CASE WHEN subend > 1 THEN 1 ELSE subend END ) geom
    FROM (SELECT troncon_id, geom, ST_Length(geom) len, ceil( ST_Length(geom)/size_usra)::integer nbusra FROM data) AS d
    CROSS JOIN LATERAL (
        SELECT i,  
                ((len/nbusra) * i)/len AS substart,
                ((len/nbusra) * (i+1))/len  AS subend
            FROM generate_series(0, 
                (nbusra-1) ) AS t(i)
            WHERE ((len/nbusra) * i)/len <> 1.0  
        ) AS d2
);

alter table trt_metro.usra_final add column usra_id int generated always as identity primary key;
create index on trt_metro.usra_final using gist(geom);





