
-- script de finalisation qui va exploiter les résultats de recalage des usras syrah sur la BD topo 
-- et produire le nouveau reférentiel prhymo ref_hexagone.usra et ref_hexagone.tgh
-- le script va créer les indexs, les clefs primaire et etrangères nécessaires et spécifier correctement
-- le type de geometrie et la projection pour la colonne geom
drop table if exists ref_hexagone.usra ;
drop table if exists ref_hexagone.tgh ;
create table ref_hexagone.tgh as (
SELECT geom,
    troncon_id as tgh_id, 
    cgenelin, 
    rang, 
    agence, 
    toponyme, 
    longueur, 
    coorx_am, 
    coory_am, 
    coorx_av, 
    coory_av,
    surf_bv, 
    larg_fdv, 
    qspe_crue, 
    pente_val, 
    drain_prin,
    q_etiage_n,
    largeur_pb, 
    rap_encais, 
    origine_troncon_id as origine_tgh_id, 
    alt_am_new as alt_am, 
    alt_av_new as alt_av, 
    pente_lit_new as pente_lit
	FROM trt_metro.tgh_final);


-- correction des altitudes => infos envoyés par loic 

UPDATE ref_hexagone.tgh set alt_am=45 where tgh_id=5738;
UPDATE ref_hexagone.tgh set alt_am=37 where tgh_id=5739;
UPDATE ref_hexagone.tgh set alt_am=0 where tgh_id=17145;
UPDATE ref_hexagone.tgh set alt_am=1 where tgh_id=17371;
UPDATE ref_hexagone.tgh set alt_am=0 where tgh_id=17372;
UPDATE ref_hexagone.tgh set alt_am=370 where tgh_id=57099;
UPDATE ref_hexagone.tgh set alt_am=397 where tgh_id=57359;
UPDATE ref_hexagone.tgh set alt_am=1569 where tgh_id=57513;

UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=47;
UPDATE ref_hexagone.tgh set alt_av=107 where tgh_id=1305;
UPDATE ref_hexagone.tgh set alt_av=45 where tgh_id=5737;
UPDATE ref_hexagone.tgh set alt_av=37 where tgh_id=5738;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=16356;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=16451;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=16730;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17145;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17147;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17211;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=1729;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17296;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17297;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17303;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17339;
UPDATE ref_hexagone.tgh set alt_av=1 where tgh_id=17370;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17371;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17372;
UPDATE ref_hexagone.tgh set alt_av=1 where tgh_id=17384;
UPDATE ref_hexagone.tgh set alt_av=0.5 where tgh_id=17386;
UPDATE ref_hexagone.tgh set alt_av=0.5 where tgh_id=17388;
UPDATE ref_hexagone.tgh set alt_av=0.5 where tgh_id=17389;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17390;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17394;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=17398;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=57119;
UPDATE ref_hexagone.tgh set alt_av=370 where tgh_id=57134;
UPDATE ref_hexagone.tgh set alt_av=397 where tgh_id=57358;
UPDATE ref_hexagone.tgh set alt_av=369 where tgh_id=57359;
UPDATE ref_hexagone.tgh set alt_av=369 where tgh_id=57363;
UPDATE ref_hexagone.tgh set alt_av=335 where tgh_id=57523;
UPDATE ref_hexagone.tgh set alt_av=380 where tgh_id=57530;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=64196;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=64321;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=67052;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=67055;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=67794;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=68076;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=68152;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=68778;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=69143;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=69196;
UPDATE ref_hexagone.tgh set alt_av=0 where tgh_id=500472;

    UPDATE ref_hexagone.tgh set alt_am=0 where alt_am<0;
    UPDATE ref_hexagone.tgh set alt_av=0 where alt_av<0;
    UPDATE ref_hexagone.tgh set pente_lit= (alt_am - alt_av) *100 / ST_LENGTH(geom);
    UPDATE ref_hexagone.tgh set pente_lit=0 where pente_lit<0;
ALTER TABLE ref_hexagone.tgh
  ADD CONSTRAINT tgh_id_pkey PRIMARY KEY(tgh_id);
create index on ref_hexagone.tgh using gist(geom);

ALTER TABLE ref_hexagone.tgh
  ALTER COLUMN geom
    TYPE geometry(LineString, 2154)
    USING ST_SetSRID(geom, 2154);


create table ref_hexagone.usra as (
SELECT troncon_id as tgh_id, usra_id,usra_id_str, usra_index, geom
	FROM trt_metro.usra_final);


ALTER TABLE ref_hexagone.usra
  ALTER COLUMN geom
    TYPE geometry(LineString, 2154)
    USING ST_SetSRID(geom, 2154);

create index on ref_hexagone.usra using gist(geom);
create index on ref_hexagone.usra (tgh_id);

ALTER TABLE ref_hexagone.usra
  ADD CONSTRAINT usra_id_pkey PRIMARY KEY(usra_id);

ALTER TABLE ref_hexagone.usra
    ADD CONSTRAINT fk_usra_tgh FOREIGN KEY (tgh_id) REFERENCES ref_hexagone.tgh  (tgh_id);


