#!/bin/bash

# the input table MUST avec a alt_id int column ranging from 1 to num rows (continuous sequence)

DBNAME="prhymo"
DBHOST="localhost"
DBPORT="5432"
DBUSER="prhymo_admin"
DEM_FILE="/data/prhymo/rgealti_dds/input_ign/rgealti_5m.tif"

tabsfx="trt_metro.tgh_final"
psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "
  alter table ${tabsfx} add column alt_id int generated always as identity"


# ALTITUDES AMONT

psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "
  drop table if exists altipt_s;

  create table altipt_s (
      id int primary key,
      s float)"

psql -XAt -F " " -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "select st_x(ST_StartPoint(geom)), st_y(ST_StartPoint(geom)) from ${tabsfx} order by alt_id" \
  | gdallocationinfo -geoloc -valonly "${DEM_FILE}" | nl -b a \
  | psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "copy altipt_s(id, s) from stdin NULL ''"

# copie des alti amont dans la table 
psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "
  update ${tabsfx} s set alt_am_new = t.s
  from altipt_s t
  where s.alt_id = t.id;
  
  drop table altipt_s"

# ALTITUDES AVAL
psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "
  drop table if exists altipt_s;

  create table altipt_s (
      id int primary key,
      s float)"

psql -XAt -F " " -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "select st_x(ST_EndPoint(geom)), st_y(ST_EndPoint(geom)) from ${tabsfx} order by alt_id" \
  | gdallocationinfo -geoloc -valonly "${DEM_FILE}" | nl -b a  \
  | psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "copy altipt_s(id, s) from stdin NULL ''"

# copie des alti aval dans la table 
psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "
  update ${tabsfx} s set alt_av_new = t.s
  from altipt_s t
  where s.alt_id = t.id;
  
  drop table altipt_s"

# attention il y a des erreurs ici sur la pente quand on a des altitudes à -99999 => cette valeur est recalculée ensuite apres correction 
# des valeurs négatives
psql -XAt -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "
  update trt_metro.tgh_final
set pente_lit_new= (alt_am_new - alt_av_new) *100 / ST_LENGTH(geom)"


# TESTS
#DEM_FILE="/data/prhymo/rgealti_dds/input_ign/./RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D001_2020-11-13/RGEALTI/1_DONNEES_LIVRAISON_2021-10-00009/RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D001/RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D001.tif"
#DEM_FILE="/data/prhymo/rgealti_dds/input_ign/rgealti_5m.tif"

#psql -XAt -F " " -h ${DBHOST} -d ${DBNAME} -p ${DBPORT} -U ${DBUSER} -c "select st_x(ST_StartPoint(geom)), st_y(ST_StartPoint(geom)) from ${tabsfx} where troncon_id=56853 order by alt_id" \
#  | gdallocationinfo -geoloc -valonly "${DEM_FILE}"