-- Calcul du lien amont aval entre les usras 
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_amont_aval_usra_final(trt_schema text, 
ref_schema text,col_schema text)
returns text
language plpgsql
as
$$
DECLARE
	querystr text;

BEGIN

    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;

 
        -- 
        querystr:= 'DROP TABLE IF EXISTS '||trt_schema||'.usra_final';
        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
        -- COPY TABLE TO TRT SCHEMA
        querystr:= 'CREATE TABLE '||trt_schema||'.usra_final AS TABLE '||ref_schema||'.usra;'
        || 'create index on '||trt_schema||'.usra_final using gist(geom);'
        || 'ALTER TABLE '||trt_schema||'.usra_final ADD CONSTRAINT usra_id_pkey PRIMARY KEY(usra_id);';
        RAISE NOTICE '%',querystr;
        EXECUTE querystr;

        -- CALC USRA AMONT
        querystr:= 'alter table '||trt_schema||'.usra_final add column startpoint Geometry;
            alter table '||trt_schema||'.usra_final add column endpoint Geometry;
            UPDATE '||trt_schema||'.usra_final 
            set startpoint=ST_STARTPOINT(geom),
            endpoint=ST_ENDPOINT(geom);
            create index on '||trt_schema||'.usra_final  using gist(startpoint);
            create index on '||trt_schema||'.usra_final  using gist(endpoint);'
            ;
        RAISE NOTICE '%',querystr;
        EXECUTE querystr;

        
    return 'traitement OK';
END;
$$;

-- calcul des tetes de reseau pour préparer le calcul amont/aval
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_amont_aval_tetes(trt_schema text, 
ref_schema text,col_schema text)
returns text
language plpgsql
as
$$
DECLARE
	querystr text;

BEGIN

    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;

 


        

        querystr:= '
        
        DROP TABLE IF EXISTS '||trt_schema||'.usra_final_amonts;
        CREATE TABLE '||trt_schema||'.usra_final_amonts as(
            select tgh.* from '||trt_schema||'.usra_final tgh
            left join '||trt_schema||'.usra_final tgh2 
            on st_dwithin(tgh.startpoint::Geometry,tgh2.geom ,0.1) 
            and tgh2.usra_id<>tgh.usra_id
            where tgh2.usra_id is NULL 
        );
        INSERT INTO '||trt_schema||'.usra_final_amonts (
                    select tgh.* from '||trt_schema||'.usra_final tgh
            left join '||trt_schema||'.usra_final tgh2 
            on st_dwithin(tgh.startpoint::Geometry,tgh2.startpoint ,0.1)
			left join '||trt_schema||'.usra_final tgh3 on st_dwithin(tgh.startpoint::Geometry,tgh3.endpoint ,0.1) 
            where tgh3.usra_id is NULL and tgh2.usra_id<>tgh.usra_id
        );


        create index on '||trt_schema||'.usra_final_amonts  using gist(geom);
        create index on '||trt_schema||'.usra_final_amonts  using gist(startpoint);
        create index on '||trt_schema||'.usra_final_amonts  using gist(endpoint);
        ';
        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
    return 'traitement OK';
END;
$$;

-- Calcul du lien amont aval entre les usras
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_amont_aval(trt_schema text, 
ref_schema text,col_schema text)
returns text
language plpgsql
as
$$
DECLARE
	querystr text;
    bv_find_filter text;
    cutNumber int;
    start_loop numeric;
    end_loop numeric;
    maxloop int;
BEGIN

    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;

    bv_find_filter := '(ST_intersects(bv.geom,st_lineInterpolatePoint(us.geom,0.5)) OR ST_intersects(bv.geom,st_lineInterpolatePoint(us.geom,0.75))OR ST_intersects(bv.geom,st_lineInterpolatePoint(us.geom,0.25)))';
    if ref_schema = 'ref_hexagone' then 
        bv_find_filter := 'ST_intersects(bv.geom,us.geom)';
    end if;

         
    cutNumber:= 10000;
    if ref_schema = 'ref_guyane' then 
        cutNumber:= 300000;
    end if;

        querystr:= '
        DROP TABLE IF EXISTS '||trt_schema||'.usra_final_amont_aval;
        CREATE TABLE '||trt_schema||'.usra_final_amont_aval as (
            WITH RECURSIVE usra AS(
                select 0 as cnt,usra_id,geom,startpoint,endpoint,usra_id as usra_amont_id,ARRAY[usra_id]::int[] as list 
                from '||trt_schema||'.usra_final_amonts where usra_id>0 and usra_id<'||cutNumber||'
                UNION 
                SELECT
                        s.cnt+1 as cnt,
                        e.usra_id,
                        e.geom,
                        e.startpoint,
                        e.endpoint,
                        s.usra_amont_id,
                        array_append(s.list, e.usra_id) as list
                    FROM
                        '||trt_schema||'.usra_final e
                    INNER JOIN usra s ON ( 
                        (st_dwithin(s.endpoint,e.geom,0.1) or st_dwithin(s.geom,e.startpoint,0.1))
                        and not st_dwithin(s.startpoint,e.startpoint,0.1) -- on ne remonte pas si confluence
                        and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
                        and s.usra_id<>e.usra_id and s.cnt<300 and not ARRAY[e.usra_id] <@ s.list) -- pour éviter les boucles

            ) SELECT * FROM usra
        ); -- 2min

        ';
        RAISE NOTICE '%',querystr;
        EXECUTE querystr;

        EXECUTE 'select ceil(max(usra_id)/'||cutNumber||'::float) from '||trt_schema||'.usra_final u ' into maxloop;
        for counter in 0..maxloop loop
            start_loop := counter*cutNumber;
            end_loop := (counter+1)*cutNumber;
            raise notice 'from: % to %', start_loop,end_loop;
            querystr:= '
            insert into '||trt_schema||'.usra_final_amont_aval(
               WITH RECURSIVE usra AS(
                select 0 as cnt,usra_id,geom,startpoint,endpoint,usra_id as usra_amont_id,ARRAY[usra_id]::int[] as list 
                from '||trt_schema||'.usra_final_amonts where usra_id>='||start_loop||' and usra_id<'||end_loop||'
                UNION 
                SELECT
                        s.cnt+1 as cnt,
                        e.usra_id,
                        e.geom,
                        e.startpoint,
                        e.endpoint,
                        s.usra_amont_id,
                        array_append(s.list, e.usra_id) as list
                    FROM
                        '||trt_schema||'.usra_final e
                    INNER JOIN usra s ON ( 
                        (st_dwithin(s.endpoint,e.geom,0.1) or st_dwithin(s.geom,e.startpoint,0.1))
                        and not st_dwithin(s.startpoint,e.startpoint,0.1) -- on ne remonte pas si confluence
                        and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
                        and s.usra_id<>e.usra_id and s.cnt<300 and not ARRAY[e.usra_id] <@ s.list) -- pour éviter les boucles

            ) SELECT * FROM usra
            );
            ';

            RAISE NOTICE '%',querystr;
            EXECUTE querystr;

        end loop;


        querystr:= '
        --create extension intarray;
        create index list_index on '||trt_schema||'.usra_final_amont_aval using GIN (list gin__int_ops);
        create index on '||trt_schema||'.usra_final_amont_aval(usra_id);
        create index on '||trt_schema||'.usra_final_amont_aval(usra_amont_id);
        create index on '||trt_schema||'.usra_final_amont_aval using gist(geom); 
        DROP TABLE IF EXISTS '||trt_schema||'.usra_final_amont;
        CREATE TABLE '||trt_schema||'.usra_final_amont as(
        select us.usra_id,us.geom,ARRAY_AGG (lat.usra_amont_id)
            from '||trt_schema||'.usra_final us
        cross join lateral (
            select distinct unnest(s.list)  as usra_amont_id 
            from '||trt_schema||'.usra_final_amont_aval s 
            where us.usra_id= s.usra_id
            ) lat
        group by us.usra_id
        ); -- 8 min 34

        CREATE INDEX ON '||trt_schema||'.usra_final_amont(usra_id);
        create index list_index2 on '||trt_schema||'.usra_final_amont using GIN (array_agg gin__int_ops);
        create index on '||trt_schema||'.usra_final_amont using gist(geom); 



        ';
        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
    

    return 'traitement OK';
END;
$$;


-- Calcul du lien amont aval entre les bv 
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_bv_amont_aval(trt_schema text, 
ref_schema text,col_schema text)
returns text
language plpgsql
as
$$
DECLARE
	querystr text;
    bv_find_filter text;
BEGIN

    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;

    bv_find_filter := '(ST_intersects(bv.geom,st_lineInterpolatePoint(us.geom,0.5)) OR ST_intersects(bv.geom,st_lineInterpolatePoint(us.geom,0.75))OR ST_intersects(bv.geom,st_lineInterpolatePoint(us.geom,0.25)))';
    if ref_schema = 'ref_hexagone' then 
        bv_find_filter := 'ST_intersects(bv.geom,us.geom)';
    end if;

    querystr:= '
    -- lister pour chaque usra ses intersections avec les BV
    DROP TABLE IF EXISTS '||trt_schema||'.usra_final_bv;
    create table '||trt_schema||'.usra_final_bv as(
    With us as (
    select * from '||trt_schema||'.usra_final us
    )
    select us.usra_id,lat.bv_id from  us
    cross join lateral (
        select distinct bv.bv_id
        from '||ref_schema||'.bv bv 
        where '||bv_find_filter||'
        ) lat
    )
    ;
    CREATE INDEX ON '||trt_schema||'.usra_final_bv(usra_id);
    CREATE INDEX ON '||trt_schema||'.usra_final_bv(bv_id);
    ';
    RAISE NOTICE '%',querystr;
	EXECUTE querystr;

    querystr:= '
    DROP TABLE IF EXISTS '||trt_schema||'.usra_final_bv_amont;
    create table '||trt_schema||'.usra_final_bv_amont as(
        select u.usra_id,lat.bv_id from '||ref_schema||'.usra u
        cross join lateral (
        with amont as (
            select unnest(amont.array_agg) as amont_list
            from '||trt_schema||'.usra_final_amont amont
            where amont.usra_id=u.usra_id
        )
    select distinct bv.bv_id from amont,
        '||trt_schema||'.usra_final_bv bv
        where bv.usra_id=amont.amont_list
    ) lat -- 3 secs 174 msec.
    );

    CREATE INDEX ON '||trt_schema||'.usra_final_bv_amont(usra_id);
    CREATE INDEX ON '||trt_schema||'.usra_final_bv_amont(bv_id);

    ';
    RAISE NOTICE '%',querystr;
	EXECUTE querystr;

    return 'traitement OK';
END;
$$;







select calc_amont_aval_usra_final('trt_martinique','ref_martinique','');
select calc_amont_aval_usra_final('trt_reunion','ref_reunion','');
select calc_amont_aval_usra_final('trt_mayotte','ref_mayotte','');
select calc_amont_aval_usra_final('trt_guyane','ref_guyane','');
select calc_amont_aval_usra_final('trt_guadeloupe','ref_guadeloupe','');
select calc_amont_aval_usra_final('trt_metro','ref_hexagone','');

select calc_amont_aval_tetes('trt_martinique','ref_martinique','');

select calc_amont_aval_tetes('trt_guadeloupe','ref_guadeloupe','');
select calc_amont_aval_tetes('trt_reunion','ref_reunion','');
select calc_amont_aval_tetes('trt_mayotte','ref_mayotte','');
select calc_amont_aval_tetes('trt_guyane','ref_guyane','');
select calc_amont_aval_tetes('trt_metro','ref_hexagone','');

-- usra amont-aval

select calc_amont_aval('trt_martinique','ref_martinique','');
select calc_amont_aval('trt_reunion','ref_reunion','');
select calc_amont_aval('trt_mayotte','ref_mayotte','');
select calc_amont_aval('trt_guyane','ref_guyane','');
select calc_amont_aval('trt_guadeloupe','ref_guadeloupe','');
select calc_amont_aval('trt_metro','ref_hexagone','');



-- uniquement les BV amont-aval
select calc_bv_amont_aval('trt_guadeloupe','ref_guadeloupe','');
select calc_bv_amont_aval('trt_martinique','ref_martinique','');
select calc_bv_amont_aval('trt_reunion','ref_reunion','');
select calc_bv_amont_aval('trt_mayotte','ref_mayotte','');
select calc_bv_amont_aval('trt_guyane','ref_guyane','');
select calc_bv_amont_aval('trt_metro','ref_hexagone','');

