-- Calcul des altitudes estimées au niveau de l'USRA
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_usra_altitudes(trt_schema text, 
ref_schema text,col_schema text)
returns text
language plpgsql
as
$$
DECLARE
	querystr text;
    bv_find_filter text;
BEGIN

    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    -- 


    querystr:= '
        alter table '||ref_schema||'.usra drop column if exists zamont ;
        alter table '||ref_schema||'.usra drop column if exists zaval ;
        alter table '||ref_schema||'.usra add column zamont double precision;
        alter table '||ref_schema||'.usra add column zaval double precision;';
    RAISE NOTICE '%',querystr;
	EXECUTE querystr;



    querystr:= 'with tmp as(
            select u.usra_id,tgh.alt_av+(nb_usra-usra_index+1)*((tgh.alt_am-tgh.alt_av)/d2.nb_usra) as zamont,
            tgh.alt_av+(nb_usra-usra_index)*((tgh.alt_am-tgh.alt_av)/d2.nb_usra) as zaval 
            from '||ref_schema||'.usra u,'||ref_schema||'.tgh tgh
            CROSS JOIN LATERAL (
                    SELECT max(usra_index) as nb_usra
                        FROM '||ref_schema||'.usra u2
                        WHERE tgh.tgh_id=u2.tgh_id
                    ) AS d2
            where u.tgh_id=tgh.tgh_id
    )
    update '||ref_schema||'.usra u set zamont = t.zamont,zaval = t.zaval
    from tmp t
    where u.usra_id = t.usra_id;
    ';
    RAISE NOTICE '%',querystr;
	EXECUTE querystr;

    return 'traitement OK';
END;
$$;


select calc_usra_altitudes('trt_metro','ref_hexagone','');
select calc_usra_altitudes('trt_martinique','ref_martinique','ode972');
select calc_usra_altitudes('trt_guadeloupe','ref_guadeloupe','ode971');
select calc_usra_altitudes('trt_reunion','ref_reunion','ode974');
select calc_usra_altitudes('trt_mayotte','ref_mayotte','ode976');
select calc_usra_altitudes('trt_guyane','ref_guyane','ode973');