-- calcul reseau coulant
show work_mem;
set work_mem='4GB';

-- calcul de la table trt*.reseau_coulant
-- découpage des usra aux confluences
-- calcul des altitudes des noeuds amonts/avals sur ce reseau
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
-- logonly ==> true pour tracer les requetes sans les executer
create or replace function calc_roe_reseau_coulant(trt_schema text, 
	ref_schema text,
	col_schema text,
	logonly boolean)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;

BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul du remous liquide';
	

  querystr:= '
--- detection des confluences
drop table if exists '||trt_schema||'.usra_final_confluences ;
 create table '||trt_schema||'.usra_final_confluences as(
   select w.endpoint,w.usra_id from '||trt_schema||'.usra_final w 
    inner join '||trt_schema||'.usra_final w2 on 
    (not(st_dwithin(w.endpoint,w2.startpoint ,0.1)
    or
    st_dwithin(w.startpoint,w2.endpoint ,0.1))
	and st_dwithin(w.endpoint,w2.geom ,0.1)
    and w.usra_id<>w2.usra_id
    )
    group by w.usra_id
 );

';

    RAISE NOTICE '%',querystr;
	if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '
-- découpage usra sur ces confluences => reseau_coulant
drop table if exists '||trt_schema||'.reseau_coulant;
drop table if exists points;
drop table if exists lines;
drop table if exists locus;
drop table if exists loc_with_idx;
create temporary table points as (
	select distinct(endpoint) as geom from '||trt_schema||'.usra_final_confluences
);
create temporary table lines as (
	select row_number() over() as id,(l.dump).geom,l.usra_id,l.usra_index,l.tgh_id from (select ST_DUMP(geom) as dump ,usra_id,usra_index,tgh_id from '||trt_schema||'.usra_final) l
);
CREATE INDEX "sidx_points_geom"
    ON points USING gist
    (geom)
    TABLESPACE pg_default;
CREATE INDEX "sidx_lines_geom"
    ON lines USING gist
    (geom)
    TABLESPACE pg_default;
ALTER TABLE lines
  ADD CONSTRAINT lines_pkey PRIMARY KEY(id);
--ALTER TABLE points
--  ADD CONSTRAINT points_pkey PRIMARY KEY(id);
create temporary table locus as (
 -- on genere la position du debut de la ligne (index 0)  pour le premier segment à découper
    select l.id, 0 as l
    from lines l
    UNION ALL
        -- on genere la position de la fin de la ligne (index 1)  pour le dernier segment à découper
    select l.id, 1 as l
    from lines l
    UNION ALL

        -- calcul des positions des points par rapport aux lignes
    select l.id, ST_LineLocatePoint(l.geom, p.geom) as  l
    from lines l, points p
    where st_dwithin(l.geom, p.geom, 0.01) and ST_LineLocatePoint(l.geom, p.geom)>0 and ST_LineLocatePoint(l.geom, p.geom)<1
    order by id, l
);
-- deuxieme table qui ajoute un index croissant par position croissante, pour permettre de faire la jointure plus tard sur elle-meme:
create temporary table loc_with_idx as (
    select id, l, rank() over (partition by id order by l) as idx
    from locus
);

';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '

-- decoupage final de chaque ligne avec les positions des points sur la ligne, grace a st_line_substring
create table '||trt_schema||'.reseau_coulant as (select 
    row_number() over () as reseau_coulant_id,
    0 as reseau_coulant_index, 
    ST_LineSubstring(l.geom, loc1.l, loc2.l) as geom,
	loc1.l as usra_start_v,
	loc2.l as usra_end_v,
    l.usra_id,
    l.usra_index,
    l.tgh_id,loc1.idx as dec_idx
from loc_with_idx loc1, loc_with_idx loc2, lines l
where l.id = loc1.id
and loc1.id = loc2.id
and loc2.idx = loc1.idx+1);

ALTER TABLE '||trt_schema||'.reseau_coulant
ALTER COLUMN reseau_coulant_id TYPE INT;
ALTER TABLE '||trt_schema||'.reseau_coulant
ALTER COLUMN dec_idx TYPE INT;
-- recalcul de l index pour ce reseau, on doit regénérer un index croissant pour un meme TGH


update '||trt_schema||'.reseau_coulant set reseau_coulant_index=(usra_index-1)*10+dec_idx;
create index on '||trt_schema||'.reseau_coulant (tgh_id);
create index on '||trt_schema||'.reseau_coulant (reseau_coulant_index);
create index on '||trt_schema||'.reseau_coulant  using gist(geom);

with tmp as (
       select reseau_coulant_id,row_number() over (partition by tgh_id order by reseau_coulant_index) as reseau_coulant_new_index 
    from '||trt_schema||'.reseau_coulant order by reseau_coulant_index
)
update '||trt_schema||'.reseau_coulant u set reseau_coulant_index = t.reseau_coulant_new_index
from tmp t
where u.reseau_coulant_id = t.reseau_coulant_id;



-- altitudes du reseau coulant
ALTER TABLE '||trt_schema||'.reseau_coulant
    ADD COLUMN alt_am double precision;

ALTER TABLE '||trt_schema||'.reseau_coulant
    ADD COLUMN alt_av double precision;

ALTER TABLE '||trt_schema||'.reseau_coulant
    ADD COLUMN pente_locale double precision;

with tmp as( 
    select u1.*,
    usra.zaval+((1-usra_end_v)*(usra.zamont-usra.zaval)) as zaval,
    usra.zaval+((1-usra_start_v)*(usra.zamont-usra.zaval)) as zamont
    from '||trt_schema||'.reseau_coulant u1
    inner join '||ref_schema||'.usra usra on usra.usra_id=u1.usra_id
)
update '||trt_schema||'.reseau_coulant u set alt_am = t.zamont,alt_av = t.zaval,pente_locale= (t.zamont-t.zaval)*100/st_length(t.geom)
from tmp t
where u.reseau_coulant_id = t.reseau_coulant_id;


';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
  return 0;
END;
$$;

--
-- Projection du ROE Enrichi sur le reseau coulant
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
-- logonly ==> true pour tracer les requetes sans les executer
create or replace function calc_roe_point_proj(trt_schema text, 
	ref_schema text,
	col_schema text,
	logonly boolean)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
	distance_max_obs_reseau text;
  srid int;

BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;

	distance_max_obs_reseau := '50';

    querystr:= '
          alter table '||col_schema||'.roe_enrichi drop column if exists geom_proj;
          alter table '||col_schema||'.roe_enrichi add column geom_proj Geometry;
          with tmp as (
            select roe.ogc_fid, t.usra_id, t.dist_lines,t.geom_proj
            from '||col_schema||'.roe_enrichi roe
                  cross join lateral (
                select usra.geom<->roe.geom as dist_lines,usra.usra_id,ST_ClosestPoint(usra.geom, roe.geom) as geom_proj  from '||ref_schema||'.usra usra
                where ST_DWITHIN(usra.geom,roe.geom,'||distance_max_obs_reseau||')
            order by dist_lines asc
            limit 1
            ) as t
            ) update '||col_schema||'.roe_enrichi roe set geom_proj = t.geom_proj
                                      
            from tmp t
        where roe.ogc_fid = t.ogc_fid;
		create index on '||col_schema||'.roe_enrichi using GIST(geom_proj); 
	';
 RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
  
  return 0;
END;
$$;	

-- creation de la table trt*.roe_reseau_coulant
-- 
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
-- logonly ==> true pour tracer les requetes sans les executer
create or replace function calc_roe_reseau_coulant_points(trt_schema text, 
	ref_schema text,
	col_schema text,
	logonly boolean)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
	distance_max_obs_reseau text;
  srid int;

BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul du remous liquide';

	distance_max_obs_reseau := '50';

querystr:= '

-- calcul du reseau_coulant le plus proche de chaque roe
-- depuis le ROE ENRICHI
drop table if exists  '||trt_schema||'.roe_reseau_coulant;			
create table '||trt_schema||'.roe_reseau_coulant as (
    select 
        CASE WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''De 1m à inférieure à 1.5m'' THEN 1.25 
            WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''De 1.5m à inférieure à 2m'' THEN 1.75
            WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''De 5m à inférieure à 10m'' THEN 7.5
            WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''De 0.5m à inférieure à 1m'' THEN 0.75
            WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''De 2m à inférieure à 3m'' THEN 2.5
            WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''Inférieure à 0.5m'' THEN 0.25
            WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''Supérieure ou égale à 10m'' THEN 10
            WHEN (HautChutEt is NULL or HautChutEt =''0'') and  HautChutcl = ''De 3m à inférieure à 5m'' THEN 4	
            WHEN HautChutEt is not NULL  THEN HautChutEt::double precision
            END haut_chut,ST_ClosestPoint(usra.geom, roe.geom) as projected_geom,
            1-ST_LineLocatePoint( usra.geom,ST_ClosestPoint(roe.geom, usra.geom)) as pos_in_usra,
            (1-ST_LineLocatePoint( usra.geom,ST_ClosestPoint(roe.geom, usra.geom)))*st_length(usra.geom) as r0,
        roe.*,usra.reseau_coulant_id,
		usra.alt_am,usra.alt_av,usra.pente_locale,tgh.tgh_id
		 from '||col_schema||'.roe_enrichi roe
         cross join lateral (
            select * from '||trt_schema||'.reseau_coulant usra
             where st_dwithin(roe.geom,usra.geom ,'||distance_max_obs_reseau||') 
             order by roe.geom<->usra.geom asc
		 limit 1
         ) usra
		 inner join '||ref_schema||'.tgh tgh on usra.tgh_id=tgh.tgh_id

);

delete from '||trt_schema||'.roe_reseau_coulant where haut_chut is null or haut_chut=0;
CREATE INDEX ON '||trt_schema||'.roe_reseau_coulant using GIST(projected_geom);
CREATE UNIQUE INDEX ON '||trt_schema||'.roe_reseau_coulant (ogc_fid);
CREATE INDEX ON '||trt_schema||'.roe_reseau_coulant (haut_chut);
ALTER TABLE '||trt_schema||'.roe_reseau_coulant
    ADD COLUMN alt_retenue double precision;


with tmp as( 
select u1.ogc_fid,
	u1.haut_chut+u1.alt_av+(u1.r0*u1.pente_locale)/100 as retenue 
    from '||trt_schema||'.roe_reseau_coulant u1
)
update '||trt_schema||'.roe_reseau_coulant u set alt_retenue = t.retenue
from tmp t
where u.ogc_fid = t.ogc_fid;


';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
  
  return 0;
END;
$$;

-- calcul des tetes de reseau pour préparer le calcul des liens amont/aval sur le reseau coulant
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
-- logonly ==> true pour tracer les requetes sans les executer
create or replace function calc_roe_reseau_coulant_tetes(trt_schema text, 
	ref_schema text,
	col_schema text,
	logonly boolean)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;

BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul du remous liquide';


	

  querystr:= '
-- calcul lien amont aval sur le reseau coulant
alter table '||trt_schema||'.reseau_coulant add column startpoint Geometry;
alter table '||trt_schema||'.reseau_coulant add column endpoint Geometry;
UPDATE '||trt_schema||'.reseau_coulant
set startpoint=ST_STARTPOINT(geom),
endpoint=ST_ENDPOINT(geom);

create index on '||trt_schema||'.reseau_coulant(reseau_coulant_id);
create index on '||trt_schema||'.reseau_coulant  using gist(startpoint);
create index on '||trt_schema||'.reseau_coulant  using gist(endpoint);


DROP TABLE IF EXISTS '||trt_schema||'.reseau_coulant_tetes;
CREATE TABLE '||trt_schema||'.reseau_coulant_tetes as(
    select tgh.* from '||trt_schema||'.reseau_coulant tgh
    left join '||trt_schema||'.reseau_coulant tgh2 
    on st_dwithin(tgh.startpoint,tgh2.geom ,0.1) 
	and tgh2.reseau_coulant_id<>tgh.reseau_coulant_id
    where tgh2.reseau_coulant_id is NULL 
);
create index on '||trt_schema||'.reseau_coulant_tetes  using gist(endpoint);
create index on '||trt_schema||'.reseau_coulant_tetes(reseau_coulant_id);


';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
  
  return 0;
END;
$$;

-- calcul du lien amont/aval du reseau coulant
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
-- logonly ==> true pour tracer les requetes sans les executer
create or replace function calc_roe_reseau_coulant_amont_aval(trt_schema text, 
	ref_schema text,
	col_schema text,
	logonly boolean)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
    srid int;

BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;

	
querystr:= '


-- la requete suivant fait crasher le serveur si on ne met pas de limite
-- on traite donc pas morceaux de 100000
drop table if exists '||trt_schema||'.reseau_coulant_amont_aval;
CREATE TABLE '||trt_schema||'.reseau_coulant_amont_aval as (
	WITH RECURSIVE reseau_coulant_tetes as (
		select * from '||trt_schema||'.reseau_coulant_tetes where reseau_coulant_id<100000
	),
	 rc AS(
		select 0 as cnt,reseau_coulant_id,endpoint,reseau_coulant_id as reseau_coulant_amont_id,
		ARRAY[reseau_coulant_id] as list 
		from reseau_coulant_tetes
		UNION 
		SELECT
				s.cnt+1 as cnt,
				e.reseau_coulant_id,
                e.endpoint,
				s.reseau_coulant_amont_id,
				array_append(s.list, e.reseau_coulant_id) as list
			FROM
				'||trt_schema||'.reseau_coulant e
			INNER JOIN rc s ON (st_dwithin(s.endpoint,e.startpoint,0.1) 
				and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
				and s.reseau_coulant_id<>e.reseau_coulant_id and s.cnt<300 and not ARRAY[e.reseau_coulant_id] <@ s.list) -- pour éviter les boucles

	) SELECT cnt,reseau_coulant_id,reseau_coulant_amont_id,list FROM rc
);-- 4min
';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '
INSERT INTO '||trt_schema||'.reseau_coulant_amont_aval(
WITH RECURSIVE reseau_coulant_tetes as (
		select * from '||trt_schema||'.reseau_coulant_tetes where reseau_coulant_id>=100000 and reseau_coulant_id<200000
	),
	 rc AS(
		select 0 as cnt,reseau_coulant_id,endpoint,reseau_coulant_id as reseau_coulant_amont_id,
		ARRAY[reseau_coulant_id] as list 
		from reseau_coulant_tetes
		UNION 
		SELECT
				s.cnt+1 as cnt,
				e.reseau_coulant_id,
                e.endpoint,
				s.reseau_coulant_amont_id,
				array_append(s.list, e.reseau_coulant_id) as list
			FROM
				'||trt_schema||'.reseau_coulant e
			INNER JOIN rc s ON (st_dwithin(s.endpoint,e.startpoint,0.1) 
				and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
				and s.reseau_coulant_id<>e.reseau_coulant_id and s.cnt<300 and not ARRAY[e.reseau_coulant_id] <@ s.list) -- pour éviter les boucles

	) SELECT cnt,reseau_coulant_id,reseau_coulant_amont_id,list FROM rc

);--10 min
';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '
INSERT INTO '||trt_schema||'.reseau_coulant_amont_aval(
WITH RECURSIVE reseau_coulant_tetes as (
		select * from '||trt_schema||'.reseau_coulant_tetes where reseau_coulant_id>=200000 and reseau_coulant_id<300000
	),
	 rc AS(
		select 0 as cnt,reseau_coulant_id,endpoint,reseau_coulant_id as reseau_coulant_amont_id,
		ARRAY[reseau_coulant_id] as list 
		from reseau_coulant_tetes
		UNION 
		SELECT
				s.cnt+1 as cnt,
				e.reseau_coulant_id,
                e.endpoint,
				s.reseau_coulant_amont_id,
				array_append(s.list, e.reseau_coulant_id) as list
			FROM
				'||trt_schema||'.reseau_coulant e
			INNER JOIN rc s ON (st_dwithin(s.endpoint,e.startpoint,0.1) 
				and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
				and s.reseau_coulant_id<>e.reseau_coulant_id and s.cnt<300 and not ARRAY[e.reseau_coulant_id] <@ s.list) -- pour éviter les boucles

	) SELECT cnt,reseau_coulant_id,reseau_coulant_amont_id,list FROM rc

);
';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '
INSERT INTO '||trt_schema||'.reseau_coulant_amont_aval(
WITH RECURSIVE reseau_coulant_tetes as (
		select * from '||trt_schema||'.reseau_coulant_tetes where reseau_coulant_id>=300000 and reseau_coulant_id<400000
	),
	 rc AS(
		select 0 as cnt,reseau_coulant_id,endpoint,reseau_coulant_id as reseau_coulant_amont_id,
		ARRAY[reseau_coulant_id] as list 
		from reseau_coulant_tetes
		UNION 
		SELECT
				s.cnt+1 as cnt,
				e.reseau_coulant_id,
                e.endpoint,
				s.reseau_coulant_amont_id,
				array_append(s.list, e.reseau_coulant_id) as list
			FROM
				'||trt_schema||'.reseau_coulant e
			INNER JOIN rc s ON (st_dwithin(s.endpoint,e.startpoint,0.1) 
				and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
				and s.reseau_coulant_id<>e.reseau_coulant_id and s.cnt<300 and not ARRAY[e.reseau_coulant_id] <@ s.list) -- pour éviter les boucles

	) SELECT cnt,reseau_coulant_id,reseau_coulant_amont_id,list FROM rc

);
';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '
INSERT INTO '||trt_schema||'.reseau_coulant_amont_aval(
WITH RECURSIVE reseau_coulant_tetes as (
		select * from '||trt_schema||'.reseau_coulant_tetes where reseau_coulant_id>=400000 and reseau_coulant_id<500000
	),
	 rc AS(
		select 0 as cnt,reseau_coulant_id,endpoint,reseau_coulant_id as reseau_coulant_amont_id,
		ARRAY[reseau_coulant_id] as list 
		from reseau_coulant_tetes
		UNION 
		SELECT
				s.cnt+1 as cnt,
				e.reseau_coulant_id,
                e.endpoint,
				s.reseau_coulant_amont_id,
				array_append(s.list, e.reseau_coulant_id) as list
			FROM
				'||trt_schema||'.reseau_coulant e
			INNER JOIN rc s ON (st_dwithin(s.endpoint,e.startpoint,0.1) 
				and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
				and s.reseau_coulant_id<>e.reseau_coulant_id and s.cnt<300 and not ARRAY[e.reseau_coulant_id] <@ s.list) -- pour éviter les boucles

	) SELECT cnt,reseau_coulant_id,reseau_coulant_amont_id,list FROM rc

);
';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '
INSERT INTO '||trt_schema||'.reseau_coulant_amont_aval(
WITH RECURSIVE reseau_coulant_tetes as (
		select * from '||trt_schema||'.reseau_coulant_tetes where reseau_coulant_id>=500000
	),
	 rc AS(
		select 0 as cnt,reseau_coulant_id,endpoint,reseau_coulant_id as reseau_coulant_amont_id,
		ARRAY[reseau_coulant_id] as list 
		from reseau_coulant_tetes
		UNION 
		SELECT
				s.cnt+1 as cnt,
				e.reseau_coulant_id,
                e.endpoint,
				s.reseau_coulant_amont_id,
				array_append(s.list, e.reseau_coulant_id) as list
			FROM
				'||trt_schema||'.reseau_coulant e
			INNER JOIN rc s ON (st_dwithin(s.endpoint,e.startpoint,0.1) 
				and not st_dwithin(s.endpoint,e.endpoint,0.1) -- on ne remonte pas si confluence
				and s.reseau_coulant_id<>e.reseau_coulant_id and s.cnt<300 and not ARRAY[e.reseau_coulant_id] <@ s.list) -- pour éviter les boucles

	) SELECT cnt,reseau_coulant_id,reseau_coulant_amont_id,list FROM rc

);
';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '

-- create index list_index on '||trt_schema||'.reseau_coulant_amont_aval using GIN (list gin__int_ops);--30 min utile cet index ?
create index on '||trt_schema||'.reseau_coulant_amont_aval(reseau_coulant_id);


DROP TABLE IF EXISTS '||trt_schema||'.reseau_coulant_amonts;
CREATE TABLE '||trt_schema||'.reseau_coulant_amonts as(
select us.reseau_coulant_id,ARRAY_AGG (lat.reseau_coulant_amont_id)
	from '||trt_schema||'.reseau_coulant us
cross join lateral (
	select distinct unnest(s.list)  as reseau_coulant_amont_id 
	from '||trt_schema||'.reseau_coulant_amont_aval s 
	where us.reseau_coulant_id=s.reseau_coulant_id
	) lat
group by us.reseau_coulant_id
); -- 17 min 30


create index on '||trt_schema||'.reseau_coulant_amonts using GIN (array_agg gin__int_ops); -- 1 min


';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;

  
  return 0;
END;
$$;


-- calcul du remous liquide
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
-- logonly ==> true pour tracer les requetes sans les executer
create or replace function calc_remous_liquide(trt_schema text, 
	ref_schema text,
	col_schema text,
	logonly boolean)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  	srid int;

BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul du remous liquide';


querystr:= '
-- calcul des remous liquides
drop table if exists '||ref_schema||'.remous_liquide ;
create table '||ref_schema||'.remous_liquide  as (
-- Z1
with amonts as(
	select u.reseau_coulant_id,u.ogc_fid,u.alt_retenue,unnest(amont.array_agg) as amont_id,u.pos_in_usra from 
	'||trt_schema||'.roe_reseau_coulant u 
	inner join '||trt_schema||'.reseau_coulant_amonts amont on amont.reseau_coulant_id=u.reseau_coulant_id
)
select ST_LineSubstring(usra.geom, 0 , 1-amont.pos_in_usra) as geom,
        amont.ogc_fid,amont.alt_retenue
	from amonts amont
inner join '||trt_schema||'.reseau_coulant usra on usra.reseau_coulant_id=amont.amont_id
where amont.alt_retenue>usra.alt_am and usra.reseau_coulant_id=amont.reseau_coulant_id
UNION ALL
(
--Z1 bis
with amonts as(
	select u.reseau_coulant_id,u.ogc_fid,u.alt_retenue,unnest(amont.array_agg) as amont_id,u.pos_in_usra from '||trt_schema||'.roe_reseau_coulant u 
	inner join '||trt_schema||'.reseau_coulant_amonts amont on amont.reseau_coulant_id=u.reseau_coulant_id
)
select ST_LineSubstring(usra.geom,  GREATEST(1-(((amont.alt_retenue-usra.alt_av  )/usra.pente_locale)*100)/st_length(usra.geom),0.0) , 1-amont.pos_in_usra) as geom,
        amont.ogc_fid,amont.alt_retenue
	from amonts amont
inner join '||trt_schema||'.reseau_coulant usra on usra.reseau_coulant_id=amont.amont_id
where amont.alt_retenue<usra.alt_am 
and usra.reseau_coulant_id=amont.reseau_coulant_id
)
UNION ALL
-- Z2
(
with amonts as(
	select u.reseau_coulant_id,u.ogc_fid,u.haut_chut,u.alt_retenue,unnest(amont.array_agg) as amont_id from '||trt_schema||'.roe_reseau_coulant u 
	inner join '||trt_schema||'.reseau_coulant_amonts amont on amont.reseau_coulant_id=u.reseau_coulant_id
)
select usra.geom,
	amont.ogc_fid,amont.alt_retenue
	from amonts amont
inner join '||trt_schema||'.reseau_coulant usra on usra.reseau_coulant_id=amont.amont_id
where amont.alt_retenue>usra.alt_am   
-- and (amont.alt_retenue-amont.haut_chut)<usra.alt_av 
and usra.reseau_coulant_id!=amont.reseau_coulant_id
)
UNION ALL (
-- Z3
	with amonts as(
		select u.reseau_coulant_id,u.ogc_fid,u.haut_chut,u.alt_retenue,unnest(amont.array_agg) as amont_id from '||trt_schema||'.roe_reseau_coulant u 
		inner join '||trt_schema||'.reseau_coulant_amonts amont on amont.reseau_coulant_id=u.reseau_coulant_id
	)
	select ST_LineSubstring(usra.geom, GREATEST(1-(((amont.alt_retenue-usra.alt_av  )/usra.pente_locale)*100)/st_length(usra.geom),0.0) , 1) as geom,
		amont.ogc_fid,amont.alt_retenue
		--,* 
		from amonts amont
	inner join '||trt_schema||'.reseau_coulant usra on usra.reseau_coulant_id=amont.amont_id
	where amont.alt_retenue>usra.alt_av   
	--and (amont.alt_retenue-amont.haut_chut)<usra.alt_av 
	and amont.alt_retenue<usra.alt_am and usra.reseau_coulant_id!=amont.reseau_coulant_id)

);
create index on '||ref_schema||'.remous_liquide (ogc_fid); 
create index on '||ref_schema||'.remous_liquide using GIST(geom); 
-- suppression des points
delete from '||ref_schema||'.remous_liquide where ST_Dimension(geom)=0;
';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;
querystr:= '
-- sur la couche '||ref_schema||'.remous_liquide on a des morceaux de remous lié à un obstacle qui apparaissent en amont et sont déconnectés du remous aval
-- c est lié à un probléme dans les altitudes probablement, les altitudes remontent puis redescendent ce qui n est pas normal
-- pour enlever ces parties on fait une union par id d obstacle et on ne prends que le morceaux qui touche l obstacle
drop table if exists '||ref_schema||'.remous_liquide_union ;
create table '||ref_schema||'.remous_liquide_union  as (
	with cluster as (
		select ogc_fid,st_unaryunion(unnest(st_clusterintersecting(geom))) as geom
		from '||ref_schema||'.remous_liquide
		group by ogc_fid
	)
	select l.* from cluster l
	inner join '||trt_schema||'.roe_reseau_coulant r on r.ogc_fid=l.ogc_fid
	where ST_DWITHIN(r.projected_geom,l.geom,1) 
);


';

    RAISE NOTICE '%',querystr;
    if not logonly then
    	EXECUTE querystr;
	end if;



  
  return 0;
END;
$$;

select calc_roe_reseau_coulant('trt_martinique','ref_martinique','col_martinique',false);
select calc_roe_reseau_coulant_points('trt_martinique','ref_martinique','col_martinique',false);
select calc_roe_point_proj('trt_martinique','ref_martinique','col_martinique',false);
select calc_roe_reseau_coulant_tetes('trt_martinique','ref_martinique','col_martinique',false);
select calc_roe_reseau_coulant_amont_aval('trt_martinique','ref_martinique','col_martinique',false);
select calc_remous_liquide('trt_martinique','ref_martinique','col_martinique',false);


select calc_roe_reseau_coulant('trt_reunion','ref_reunion','col_reunion',false);
select calc_roe_reseau_coulant_points('trt_reunion','ref_reunion','col_reunion',false);
select calc_roe_point_proj('trt_reunion','ref_reunion','col_reunion',false);
select calc_roe_reseau_coulant_tetes('trt_reunion','ref_reunion','col_reunion',false);
select calc_roe_reseau_coulant_amont_aval('trt_reunion','ref_reunion','col_reunion',false);
select calc_remous_liquide('trt_reunion','ref_reunion','col_reunion',false);


select calc_roe_reseau_coulant('trt_mayotte','ref_mayotte','col_mayotte',false);
select calc_roe_reseau_coulant_points('trt_mayotte','ref_mayotte','col_mayotte',false);
select calc_roe_point_proj('trt_mayotte','ref_mayotte','col_mayotte',false);
select calc_roe_reseau_coulant_tetes('trt_mayotte','ref_mayotte','col_mayotte',false);
select calc_roe_reseau_coulant_amont_aval('trt_mayotte','ref_mayotte','col_mayotte',false);
select calc_remous_liquide('trt_mayotte','ref_mayotte','col_mayotte',false);


select calc_roe_reseau_coulant('trt_guyane','ref_guyane','col_guyane',false);
select calc_roe_reseau_coulant_points('trt_guyane','ref_guyane','col_guyane',false);
select calc_roe_point_proj('trt_guyane','ref_guyane','col_guyane',false);
select calc_roe_reseau_coulant_tetes('trt_guyane','ref_guyane','col_guyane',false);
select calc_roe_reseau_coulant_amont_aval('trt_guyane','ref_guyane','col_guyane',false);
select calc_remous_liquide('trt_guyane','ref_guyane','col_guyane',false);



select calc_roe_reseau_coulant('trt_guadeloupe','ref_guadeloupe','col_guadeloupe',false);
select calc_roe_reseau_coulant_points('trt_guadeloupe','ref_guadeloupe','col_guadeloupe',false);
select calc_roe_point_proj('trt_guadeloupe','ref_guadeloupe','col_guadeloupe',false);
select calc_roe_reseau_coulant_tetes('trt_guadeloupe','ref_guadeloupe','col_guadeloupe',false);
select calc_roe_reseau_coulant_amont_aval('trt_guadeloupe','ref_guadeloupe','col_guadeloupe',false);
select calc_remous_liquide('trt_guadeloupe','ref_guadeloupe','col_guadeloupe',false);

select calc_roe_reseau_coulant('trt_metro','ref_hexagone','col_hexagone',false);
select calc_roe_reseau_coulant_points('trt_metro','ref_hexagone','col_hexagone',false);
select calc_roe_point_proj('trt_metro','ref_hexagone','col_hexagone',false);
select calc_roe_reseau_coulant_tetes('trt_metro','ref_hexagone','col_hexagone',false);
select calc_roe_reseau_coulant_amont_aval('trt_metro','ref_hexagone','col_hexagone',false);
select calc_remous_liquide('trt_metro','ref_hexagone','col_hexagone',false);


