

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_usi(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
    querystr text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;
  
    querystr:= '
        drop table if exists '||ref_schema||'.usi;
        CREATE TABLE '||ref_schema||'.usi AS (
            WITH
            data AS (
                SELECT usra.usra_id,usra.geom,
                CASE WHEN tgh.largeur_pb*25 >= 100 THEN tgh.largeur_pb*25 
                WHEN tgh.largeur_pb*25 < 100  THEN 100
                
                END size_usi FROM '||ref_schema||'.usra usra left join '||ref_schema||'.tgh tgh on usra.tgh_id=tgh.tgh_id
            )
            SELECT usra_id,usra_id||''_''||(i+1) usra_id_str,i+1 usi_index,ST_LineSubstring( d.geom, substart, 
                CASE WHEN subend > 1 THEN 1 ELSE subend END ) geom
            FROM (SELECT usra_id, geom, ST_Length(geom) len, ceil( ST_Length(geom)/size_usi)::integer nbusi FROM data) AS d
            CROSS JOIN LATERAL (
                SELECT i,  
                        ((len/nbusi) * i)/len AS substart,
                        ((len/nbusi) * (i+1))/len  AS subend
                    FROM generate_series(0, 
                        (nbusi-1) ) AS t(i)
                    WHERE ((len/nbusi) * i)/len <> 1.0  
                ) AS d2
        );

        create index on '||ref_schema||'.usi (usra_id);
        ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    
    querystr:= '
        -- longueur de l''''usi / distance entre les points amont et aval
        ALTER TABLE '||ref_schema||'.usi
            ADD COLUMN coef_sinuosite double precision;

        UPDATE '||ref_schema||'.usi
            set coef_sinuosite=ST_LENGTH(geom)/ST_Distance(ST_ENDPOINT(geom) , ST_STARTPOINT(geom));

        ALTER TABLE '||ref_schema||'.usi
            ADD COLUMN rectiligne boolean;

        UPDATE '||ref_schema||'.usi
            set rectiligne=true where coef_sinuosite<1.05 ;

        UPDATE '||ref_schema||'.usi
            set rectiligne=false where coef_sinuosite>=1.05 ;
    ';

    

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
 
  return 0;
END;
$$;


select calc_usi('trt_martinique','ref_martinique','col_martinique');
select calc_usi('trt_guadeloupe','ref_guadeloupe','col_guadeloupe');
select calc_usi('trt_mayotte','ref_mayotte','col_mayotte');
select calc_usi('trt_reunion','ref_reunion','col_reunion');
select calc_usi('trt_guyane','ref_guyane','col_guyane');
select calc_usi('trt_metro','ref_hexagone','col_hexagone');



