--
-- Script de calcul du lien entre les USRA et les masses d'eau
--
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
drop function if exists calc_usra_masse_eau(ref_schema text);
create or replace function calc_usra_masse_eau(ref_schema text)
    returns int
    language plpgsql
as
$calc_usra_masse_eau$
DECLARE
    time0 numeric;
    time1 numeric;
BEGIN

    select extract(epoch from clock_timestamp()) into time0;

    -- on cherche la masse d'eau associé à chaque usra, cad :
    -- si au moins une portion de 25% de l'usra est à moins de 50m d'une masse d'eau
    -- on ordonne en prenant la masse d'eau la plus proche du point médian de l'usra
    execute format($$
        drop table if exists %1$I.usra_me;
        create table %1$I.usra_me as (
            select usra.usra_id,lat.ogc_fid as me_ogc_fid from %1$I.usra usra cross join lateral(
                select * from %1$I.me where 
                 ( st_dwithin(st_lineinterpolatepoint(usra.geom,0.1),me.geom,50)
                and st_dwithin(st_lineinterpolatepoint(usra.geom,0.35),me.geom,50)  )
                or ( st_dwithin(st_lineinterpolatepoint(usra.geom,0.2),me.geom,50)
                and st_dwithin(st_lineinterpolatepoint(usra.geom,0.45),me.geom,50)  )
                or (   st_dwithin(st_lineinterpolatepoint(usra.geom,0.3),me.geom,50)
                and st_dwithin(st_lineinterpolatepoint(usra.geom,0.55),me.geom,50)  )
                or (   st_dwithin(st_lineinterpolatepoint(usra.geom,0.4),me.geom,50)
                and st_dwithin(st_lineinterpolatepoint(usra.geom,0.65),me.geom,50)  )
                or (   st_dwithin(st_lineinterpolatepoint(usra.geom,0.5),me.geom,50)
                and st_dwithin(st_lineinterpolatepoint(usra.geom,0.75),me.geom,50)  )
                or (   st_dwithin(st_lineinterpolatepoint(usra.geom,0.6),me.geom,50)
                and st_dwithin(st_lineinterpolatepoint(usra.geom,0.85),me.geom,50)  )
                or (   st_dwithin(st_lineinterpolatepoint(usra.geom,0.7),me.geom,50)
                and st_dwithin(st_lineinterpolatepoint(usra.geom,0.95),me.geom,50)  )
                order by usra_id,me.geom <-> st_lineInterpolatePoint(usra.geom, 0.5)
                limit 1
            )lat
        );
        
        analyse %1$I.usra_me
        $$, ref_schema);

    select extract(epoch from clock_timestamp()) into time1;
    raise notice 'table created in % s', (time1 - time0);

    return 0;
end
$calc_usra_masse_eau$;



-- l'objectif des select est de créer les tables de jointures usra <-> me  (usra_me) pour chaque territoire
select calc_usra_masse_eau('ref_reunion');
select calc_usra_masse_eau('ref_mayotte');
select calc_usra_masse_eau('ref_hexagone');
select calc_usra_masse_eau('ref_guyane');
select calc_usra_masse_eau('ref_martinique');
select calc_usra_masse_eau('ref_guadeloupe');