-- Calculs morphologie structure rive
-- attributs usra concernés: veget10, veget30, veget60, montagne, territoir1

-------------------------------------------------------------------------------------------------------------------
-- meme méthode pour veget10, veget30, veget60
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- val : 10, 30, 60 sont les seules valeurs possibles
drop function if exists calc_vegetX(ref_schema text, val int);
create or replace function calc_vegetX(ref_schema text, val int)
    returns int
    language plpgsql
as
$calc_vegetX$
DECLARE
    srid int;
    row_cnt int8;
    vege_table text;
    vege_where_clause text;
BEGIN
    RAISE NOTICE 'schéma ref (%)', ref_schema;

    -- gets srid from usra table:
    execute format($$select st_srid(geom) from %I.usra limit 1$$, ref_schema) into srid;

    if val not in ('10', '30', '60') then
        raise exception 'val not in accepted values: % (accepted values are 10,30,60)', val;
    end if;

    if ref_schema = 'ref_martinique' then
        vege_table := 'col_martinique.occsol_2017';
        vege_where_clause := $$(CODE_CS = 'CS2.1.1.1' and CODE_US = 'US6.3')
       or (CODE_CS = 'CS2.1.3' and CODE_US = 'US6.3')
       or (CODE_CS = 'CS2.2.2' and CODE_US = 'US6.3')$$;
    elsif ref_schema = 'ref_guadeloupe' then
        vege_table := 'col_guadeloupe.karucover_2017';
        vege_where_clause := $$(typcsn5 = 'CS2.1.1.1.1' and typusn2 in ('US6.2', 'US6.3')) or
                (typcsn5 = 'CS2.1.1.1.2' and typusn2 in ('US6.2', 'US6.3')) or
                (typcsn5 = 'CS2.1.1.1.3') or
                (typcsn5 = 'CS2.1.1.1.4' and typusn2 in ('US6.2', 'US6.3')) or
                (typcsn5 = 'CS2.1.1.1.5' and typusn2 in ('US6.2', 'US6.3')) or
                (typcsn5 = 'CS2.1.2.1.0') or
                (typcsn5 = 'CS2.1.2.3.0' and typusn2 in ('US6.2', 'US6.3'))$$;
    elsif ref_schema = 'ref_guyane' then
        vege_table := 'bdtopo_973.occsol_veget_sub';
        vege_where_clause := $$true$$;
    elsif ref_schema = 'ref_reunion' then
        vege_table := 'col_reunion.occsol';
        vege_where_clause := $$code3 in (15, 16, 18, 19, 21, 22, 23, 25, 26) $$;
    elsif ref_schema = 'ref_mayotte' then
        vege_table := 'col_mayotte.occsol_2016';
        vege_where_clause := $$(CODE_CS = 'CS2.1.1.1' and CODE_US = 'US6.3')
       or (CODE_CS = 'CS2.1.3' and CODE_US = 'US6.3')
       or (CODE_CS = 'CS2.2.2' and CODE_US = 'US6.3')$$;
    elsif ref_schema = 'ref_hexagone' then
        vege_table := 'bdtopo_metro.occsol_veget_sub';
        vege_where_clause := $$true$$;
    else
        raise exception 'Bad reference schema: %', ref_schema;
    end if;

    -- processing buffer vs vegetation
    execute format($$drop table if exists usra_veget%4$s;
        create temp table usra_veget%4$s as
            with tmp as (
                select usra_id, sum(st_area(geom)) as area
                from %1$I.usra_%4$sm_moins_1w
                group by usra_id
            ), tmp1 as (
                select a.usra_id,
                       sum(st_area(st_intersection(a.geom, b.geom))) as area_inter
                from %1$I.usra_%4$sm_moins_1w a
                         join %2$s b on st_dwithin(a.geom, b.geom,0.1)
                where %3$s
                group by a.usra_id
            )
            select tmp.usra_id, tmp1.area_inter * 100 / tmp.area as veget%4$s_v
            from tmp join tmp1 on tmp.usra_id = tmp1.usra_id
        $$, ref_schema, vege_table, vege_where_clause, val);

    RAISE NOTICE 'mise a jour de la table des usra, colonne veget%', val;

    execute format($$alter table %1$I.usra drop column if exists veget%2$s ;
      alter table %1$I.usra add column veget%2$s text default 'tres_faible'; -- tres_faible ici meme si la doc dit que fort est la valeur par defaut. b.veget%2$s_v est parfois null quand pas d'intersection avec la veget, il faut donc 0 et faible comme valeur par défaut quand la données d'occsol est connue
      alter table %1$I.usra drop column if exists veget%2$s_v ;
      alter table %1$I.usra add column veget%2$s_v double precision default 0;
      comment on column %1$I.usra.veget%2$s is 'taux de boisement de berge %2$sm autour du cours d''eau';
      comment on column %1$I.usra.veget%2$s_v is 'taux de boisement de berge %2$sm autour du cours d''eau';
      update %1$I.usra a set veget%2$s_v=b.veget%2$s_v,veget%2$s = case when b.veget%2$s_v < 20 then 'tres_faible'
                                         when b.veget%2$s_v >= 20 and b.veget%2$s_v < 40 then 'faible'
                                         when b.veget%2$s_v >= 40 and b.veget%2$s_v < 80 then 'moyen'
                                         when b.veget%2$s_v >= 80 then 'fort' end
      from usra_veget%2$s b
      where a.usra_id = b.usra_id
    $$, ref_schema, val);
    GET DIAGNOSTICS row_cnt = ROW_COUNT;
    raise notice 'Mise à jour de % usra pour la colonne veget%', row_cnt, val;

    return 0;
END
$calc_vegetX$;

-------------------------------------------------------------------------------------------------------------------
-- territoir1: valeurs suivant le territoire
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
drop function if exists calc_territoir1(ref_schema text);
create or replace function calc_territoir1(ref_schema text)
    returns int
    language plpgsql
as
$calc_territoir1$
DECLARE
    row_cnt int8;
    col_val text := 'autres';
BEGIN
    RAISE NOTICE 'schéma ref (%)', ref_schema;

    if ref_schema = 'ref_guyane' then
        col_val := 'guyane';
    end if;

    RAISE NOTICE 'mise a jour de la table des usra, colonne territoir1';

    execute format($$alter table %1$I.usra drop column if exists territoir1;
      alter table %1$I.usra add column territoir1 text default %2$L;
       comment on column %1$I.usra.territoir1 is 'classement des territoires en 2 groupes : Guyane et autres territoires';
    $$, ref_schema, col_val);
    GET DIAGNOSTICS row_cnt = ROW_COUNT;
    raise notice 'Mise à jour de % usra pour la colonne territoir1', row_cnt;

    return 0;
END
$calc_territoir1$;

-------------------------------------------------------------------------------------------------------------------
-- alti du noeud amont <= alti maxi définie par massif (valeur par défaut)
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
drop function if exists calc_montagne(ref_schema text);
create or replace function calc_montagne(ref_schema text)
    returns int
    language plpgsql
as
$calc_montagne$
DECLARE
    row_cnt int8;
    col_val text := 'dessous';
BEGIN
    RAISE NOTICE 'schéma ref (%)', ref_schema;

    RAISE NOTICE 'mise a jour de la table des usra, colonne montagne';

    execute format($$alter table %1$I.usra drop column if exists montagne;
      alter table %1$I.usra add column montagne text default 'dessous';
      comment on column %1$I.usra.montagne is 'position de l''USRA par rapport à l''altitude maximale des forêts';
    $$, ref_schema, col_val);
    
    if ref_schema = 'ref_hexagone' then
        execute format($$update %1$I.usra u set montagne = case when u.zamont > v.lim_veg then 'dessus' else 'dessous' end
        from col_hexagone.limite_alti_vege v
        where st_intersects(u.geom, v.geom);
        $$, ref_schema, col_val);
        GET DIAGNOSTICS row_cnt = ROW_COUNT;
        raise notice 'Mise à jour de % usra pour la colonne montagne', row_cnt;
    end if;

    return 0;
END
$calc_montagne$;
