
-- Calcul de alluvial : lithologie dominante du fond de vallée
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_alluvial(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
    querystr text;
    seuil_1 text;
    seuil_2 text;
    occ_filter text;
    occ_table text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

    seuil_1 := '10';
    seuil_2 := '25';
    occ_filter  := '';
    occ_table := 'occsol';

    querystr:= '

        alter table '||ref_schema||'.usra drop column if exists alluvial ;
        alter table '||ref_schema||'.usra add column alluvial text;
        comment on column '||ref_schema||'.usra.alluvial is ''lithologie dominante du fond de vallée'';
        update '||ref_schema||'.usra set alluvial=''non'';
        ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    if ref_schema = 'ref_guadeloupe' or ref_schema = 'ref_martinique' or ref_schema = 'ref_reunion' or ref_schema = 'ref_guyane' then 
        querystr:= '
        update '||ref_schema||'.usra a set alluvial = ''oui'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.substrat=''dominance d''''alluvions'';
        ';
    end if;
    if ref_schema = 'ref_mayotte' then 
        querystr:= '
        update '||ref_schema||'.usra set alluvial=''oui'';
        ';
    end if;
    if ref_schema = 'ref_hexagone' then 
        querystr:= '
        alter table '||ref_schema||'.tgh drop column if exists substrat ;
        alter table '||ref_schema||'.tgh add column substrat text;

        with tmp as(
            select distinct usra.usra_id from ref_hexagone.usra usra 
            ,col_hexagone.lithologie_fv_sub lit
            where st_intersects(usra.geom,lit.geom) and st_length(st_intersection(usra.geom,lit.geom))*100/st_length(usra.geom)>50
        )
        update '||ref_schema||'.usra u set alluvial = ''oui''
            from tmp t
            where u.usra_id = t.usra_id;
    ';
    end if;
    

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
 


  
  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_rectitude(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
    querystr text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;
  
    querystr:= '
    alter table '||ref_schema||'.usra drop column if exists rectitud_v ;
        ALTER TABLE '||ref_schema||'.usra ADD COLUMN rectitud_v double precision;
        alter table '||ref_schema||'.usra drop column if exists rectitude ;
        alter table '||ref_schema||'.usra add column rectitude character varying( 10);
        comment on column '||ref_schema||'.usra.rectitud_v is ''rectitude du tracé en plan du cours d''''eau'';
        comment on column '||ref_schema||'.usra.rectitude is ''rectitude du tracé en plan du cours d''''eau'';
        update '||ref_schema||'.usra set rectitude=''faible'';
        ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    
    querystr:= '
        WITH tmp as(
            select usra.usra_id,(usi_rect.count/usi.count::double precision)*100 as rectitud_v 
            from '||ref_schema||'.usra usra
            cross join lateral(
            select count(usra_id) from '||ref_schema||'.usi usi where usra.usra_id=usi.usra_id ) as usi
            cross join lateral(
            select count(usra_id) from '||ref_schema||'.usi usi where usra.usra_id=usi.usra_id and usi.rectiligne is true) as usi_rect
        )
        update '||ref_schema||'.usra u set rectitud_v = ROUND(t.rectitud_v::numeric,2)
        from tmp t
        where u.usra_id = t.usra_id;

        UPDATE '||ref_schema||'.usra
        set rectitude=''moyen'' where rectitud_v>=20 and rectitud_v<=50 ;

        UPDATE '||ref_schema||'.usra
            set rectitude=''fort'' where rectitud_v>50 ;
    ';

  -- En Guyane, on impose la valeur faible car le réseau hydro numérique 
  -- sous-estime largement la sinuosité réelle des cours d'eau
  if not ref_schema = 'ref_guyane' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;

   
  
  return 0;
END;
$$;
