
-- Calcul de l'etiage
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_etiage(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  EXECUTE 'select ST_SRID(geom) from '||ref_schema||'.usra limit 1' into srid USING ref_schema;

   querystr:= '
      alter table '||ref_schema||'.usra drop column if exists etiage ;
      alter table '||ref_schema||'.usra add column etiage text;
      comment on column '||ref_schema||'.usra.etiage is ''intensité du débit d''''étiage naturel'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  -- etiage tjrs fort en guyane
  if ref_schema = 'ref_guyane' then 
     querystr:= '
      update '||ref_schema||'.usra a set etiage = ''fort'';
    ';
  elsif ref_schema = 'ref_hexagone' then 
     querystr:= '
      update '||ref_schema||'.usra a set etiage = ''fort'' from ref_hexagone.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.q_etiage_n=''fort'';
      update '||ref_schema||'.usra a set etiage = ''faible'' from ref_hexagone.tgh tgh where tgh.tgh_id=a.tgh_id and (tgh.q_etiage_n=''faible'' or tgh.q_etiage_n is null);
    ';
  else
  -- etiage
    querystr:= '
      -- attention ici fort et faible n ont pas la meme signification dans les données d entree donc on inverse
      update '||ref_schema||'.usra a set etiage = ''fort'' from '||col_schema||'.deb_etiage b where st_intersects(a.geom,ST_Transform(b.geom,'||srid||')) and b.deb_etiage = ''faible'';
      update '||ref_schema||'.usra a set etiage = ''faible'' from '||col_schema||'.deb_etiage b where st_intersects(a.geom,ST_Transform(b.geom,'||srid||')) and b.deb_etiage = ''fort'';
    ';


  end if;
  
  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  return 0;
END;
$$;




ALTER TABLE col_hexagone.bnpe
ALTER COLUMN volume_m3 TYPE double precision USING volume_m3::double precision;

ALTER TABLE col_hexagone.bnpe
  ALTER COLUMN geom TYPE geometry(POINT, 4326)
    USING ST_SetSRID(geom,4326);

-- Calcul de la consommation par BV : Attention la couche col_hexagone.bnpe couvre tout les territoires
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_consomation(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul de la consommation par BV)';
  
  querystr:= '
      alter table '||ref_schema||'.bv drop column if exists conso ;
      alter table '||ref_schema||'.bv add column conso double precision;
      with tmp as (
	select 
    SUM(CASE WHEN code_usage_bnpe = ''IND'' THEN volume_m3*0.07
      WHEN code_usage_bnpe = ''IRR'' THEN volume_m3*0.8
      WHEN code_usage_bnpe = ''AEP'' THEN volume_m3*0.2
      WHEN code_usage_bnpe = ''ENE'' THEN volume_m3*0.03      
      END)/3 volume            
    ,b.bv_id
    from col_hexagone.bnpe a inner join '||ref_schema||'.bv b
    on st_intersects(a.geom,ST_Transform(b.geom,4326))
    where code_usage_bnpe IN (''IND'',''IRR'',''AEP'',''ENE'')
    group by b.bv_id 
)
update '||ref_schema||'.bv u set conso = t.volume
from tmp t
where u.bv_id = t.bv_id;
    update '||ref_schema||'.bv u set conso = 0 where conso is null;
  ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr USING srid;
  
  
  
  return 0;
END;
$$;



-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_consomation_usra(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul de la consommation par USRA';
  
  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists conso ;
      alter table '||ref_schema||'.usra add column conso double precision;
      comment on column '||ref_schema||'.usra.conso is ''volume d''''eau consommé dans le bassin versant en m3/km2/an'';
      
      alter table '||ref_schema||'.usra drop column if exists consom1 ;
      alter table '||ref_schema||'.usra add column consom1 character varying(10);
      comment on column '||ref_schema||'.usra.consom1 is ''volume d''''eau consommé dans le bassin versant - discrétisation pour l''''évaluation de l''''impact sur le débit d''''étiage'';
      alter table '||ref_schema||'.usra drop column if exists consom2 ;
      alter table '||ref_schema||'.usra add column consom2 character varying(10);
      comment on column '||ref_schema||'.usra.consom2 is ''volume d''''eau consommé dans le bassin versant - discrétisation pour l''''évaluation de l''''impact sur le débit moyen'';
      
      

      
      with tmp as(
        select u.usra_id,lat.consom,lat.surface from '||ref_schema||'.usra u
        cross join lateral (
        select sum(bv.conso) as consom,sum(st_area(bv.geom))/1000000 as surface from '||trt_schema||'.usra_final_bv_amont bv_amont,
          '||ref_schema||'.bv bv
          where u.usra_id=bv_amont.usra_id 
          and bv_amont.bv_id=bv.bv_id
      ) lat 
      )	
      update '||ref_schema||'.usra u set conso = t.consom/t.surface
      from tmp t
      where u.usra_id = t.usra_id;
  ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr USING srid;
  
   if ref_schema = 'ref_hexagone' then 
   -- consom1
    querystr:= '
      

      update '||ref_schema||'.usra a set consom1 = ''faible''  where  conso<2500 or conso is null ;
      update '||ref_schema||'.usra a set consom1 = ''moyen'' where conso>=2500 and conso<7500;
      update '||ref_schema||'.usra a set consom1 = ''fort'' where conso>=7500;
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    -- consom2
    querystr:= '

      update '||ref_schema||'.usra a set consom2 = ''faible''  where  conso<33000 or conso is null ;
      update '||ref_schema||'.usra a set consom2 = ''moyen'' where conso>=33000 and conso<100000;
      update '||ref_schema||'.usra a set consom2 = ''fort'' where conso>=100000;
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
    -- Pour la martinique les points de la BNPE sont mal geolocalisé donc on met un rustine temporairement
    --Voici la correction validée avec l'OFB : attribuer à toutes les USRA à 
    --étiage fort (*) la valeur consom1 = fort.
    --On conserve les valeurs par défaut ailleurs (consom1 = faible pour les 
    --USRA à étiage faible) et pour l'autre descripteur (consom2 = faible 
    --partout).
   elseif ref_schema = 'ref_martinique' then
      -- consom1
      querystr:= '
        update '||ref_schema||'.usra a set consom1 = ''faible'',consom2 = ''faible'';
        update '||ref_schema||'.usra a set consom1 = ''fort'' where etiage=''fort'';
      ';

      RAISE NOTICE '%',querystr;
      EXECUTE querystr;
      
   else
    
    -- consom1
    querystr:= '
      update '||ref_schema||'.usra a set consom1 = ''faible''  where  conso<7500 or conso is null;
      update '||ref_schema||'.usra a set consom1 = ''moyen'' where conso>=7500 and conso<22500;
      update '||ref_schema||'.usra a set consom1 = ''fort'' where conso>=22500;
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
    -- consom2
    querystr:= '
      update '||ref_schema||'.usra a set consom2 = ''faible''  where  conso<100000 or conso is null;
      update '||ref_schema||'.usra a set consom2 = ''moyen'' where conso>=100000 and conso<300000;
      update '||ref_schema||'.usra a set consom2 = ''fort'' where conso>=300000;
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;
  
  
  return 0;
END;
$$;


-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_canaux(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul de canaux';
  
  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists canaux ;
      alter table '||ref_schema||'.usra add column canaux character varying(10);
      comment on column '||ref_schema||'.usra.canaux is ''présence de canaux navigables dans le lit majeur'';
      update '||ref_schema||'.usra set canaux=''absence'';
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

  if ref_schema = 'ref_hexagone' then 
    querystr:= '
      With canaux as (
      select d.geometrie as geom from bdtopo_metro.troncon_hydrographique d
      where nature = ''Canal'' and navigabilite=true
      )
      update ref_hexagone.usra u2
      set canaux=''presence''
      from ref_hexagone.usra_12w u
      inner join canaux canaux
      on st_intersects(canaux.geom,u.geom)
      where u2.usra_id=u.usra_id and st_length(st_intersection(canaux.geom,u.geom,1))>st_length(u2.geom)*10/100;
    ';
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
    
  end if;
  
  
  
  return 0;
END;
$$;



-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_tcc(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$calc_tcc$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
    RAISE NOTICE 'calcul de tcc';
  

    execute format($$
      alter table %1$I.usra drop column if exists tcc ;
      alter table %1$I.usra add column tcc character varying(10) default 'absence';
      comment on column %1$I.usra.tcc is 'présence d''un tronçon court-circuité'$$, ref_schema);

  
  
  return 0;
END;
$calc_tcc$;


