-- Calcul du rang
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_rang(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
  

 
    querystr:= '
      alter table '||ref_schema||'.usra drop column if exists rang ;
      alter table '||ref_schema||'.usra add column rang text default ''petit'';
      comment on column '||ref_schema||'.usra.rang is ''rang de Strahler'';
      update '||ref_schema||'.usra a set rang = ''petit'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.rang<=3;
      update '||ref_schema||'.usra a set rang = ''grand'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.rang>3;
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  
  
  
  return 0;
END;
$$;




-- Calcul de la pente de l'USRA (en 2 classes)
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_pente2c(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
  

 
    querystr:= '
      alter table '||ref_schema||'.usra drop column if exists pente2c ;
      alter table '||ref_schema||'.usra add column pente2c text;
      comment on column '||ref_schema||'.usra.pente2c is ''pente de l''''USRA (en 2 classes)'';
      update '||ref_schema||'.usra a set pente2c = ''faible'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.pente_lit<6;
      update '||ref_schema||'.usra a set pente2c = ''fort'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.pente_lit>=6;
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  
  
  
  return 0;
END;
$$;




-- Calcul de la pente de l'USRA (en 3 classes)
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_pente3c(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
  

 
    querystr:= '
      alter table '||ref_schema||'.usra drop column if exists pente3c ;
      alter table '||ref_schema||'.usra add column pente3c text;
      comment on column '||ref_schema||'.usra.pente3c is ''pente de l''''USRA (en 3 classes)'';
      update '||ref_schema||'.usra a set pente3c = ''faible'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.pente_lit<0.5;
      update '||ref_schema||'.usra a set pente3c = ''moyen'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.pente_lit>=0.5 and tgh.pente_lit<1.5;
      update '||ref_schema||'.usra a set pente3c = ''fort'' from '||ref_schema||'.tgh tgh where tgh.tgh_id=a.tgh_id and tgh.pente_lit>=1.5;
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  
  
  
  return 0;
END;
$$;


-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_ret_us(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
  

 
    querystr:= '
      alter table '||ref_schema||'.bv drop column if exists vol_us_autre ;
      alter table '||ref_schema||'.bv add column vol_us_autre double precision;
      alter table '||ref_schema||'.bv drop column if exists vol_us_hydro ;
      alter table '||ref_schema||'.bv add column vol_us_hydro double precision;
      alter table '||ref_schema||'.bv drop column if exists vol_us_agri ;
      alter table '||ref_schema||'.bv add column vol_us_agri double precision;

      drop table if exists surf_by_bv;
      create temporary table surf_by_bv as (
          select b.bv_id,sum(a.volume_hm3) as surf
          from '||col_schema||'.retenues a 
          inner join '||ref_schema||'.bv b
              on st_intersects(a.geom,b.geom)
              where a.usage_1=''Agriculture''
              group by b.bv_id
      );
      update '||ref_schema||'.bv u set vol_us_agri = t.surf
      from surf_by_bv t
      where u.bv_id = t.bv_id;
      update '||ref_schema||'.bv u set vol_us_agri = 0 where vol_us_agri is null;

      drop table if exists surf_by_bv;
      create temporary table surf_by_bv as (
          select b.bv_id,sum(a.volume_hm3) as surf
          from '||col_schema||'.retenues a 
          inner join '||ref_schema||'.bv b
              on st_intersects(a.geom,b.geom)
              where a.usage_1=''Hydroelectricite''
              group by b.bv_id
      );
      update '||ref_schema||'.bv u set vol_us_hydro = t.surf
      from surf_by_bv t
      where u.bv_id = t.bv_id;
      update '||ref_schema||'.bv u set vol_us_hydro = 0 where vol_us_hydro is null;

      drop table if exists surf_by_bv;
      create temporary table surf_by_bv as (
          select b.bv_id,sum(a.volume_hm3) as surf
          from '||col_schema||'.retenues a 
          inner join '||ref_schema||'.bv b
              on st_intersects(a.geom,b.geom)
              where not(a.usage_1=''Hydroelectricite'' or  a.usage_1=''Agriculture'')
              group by b.bv_id
      );
      update '||ref_schema||'.bv u set vol_us_autre = t.surf
      from surf_by_bv t
      where u.bv_id = t.bv_id;
      update '||ref_schema||'.bv u set vol_us_autre = 0 where vol_us_autre is null;

      alter table '||ref_schema||'.usra drop column if exists ret_us ;
      alter table '||ref_schema||'.usra add column ret_us text;
      comment on column '||ref_schema||'.usra.ret_us is ''usage dominant du volume d''''eau stocké dans les retenues amont'';


      with tmp as(
        select u.usra_id,lat.vol_us_agri,lat.vol_us_hydro,lat.vol_us_autre,
        CASE WHEN lat.vol_us_hydro > lat.vol_us_agri and lat.vol_us_hydro > lat.vol_us_autre THEN ''hydroelec''
        WHEN lat.vol_us_agri > lat.vol_us_hydro and lat.vol_us_agri > lat.vol_us_autre THEN ''agri''
        ELSE
        ''autre''
        END usage 
        from '||ref_schema||'.usra u
                    cross join lateral (
                    select sum(bv.vol_us_autre) as vol_us_autre,sum(vol_us_agri) as vol_us_agri ,sum(vol_us_hydro) as vol_us_hydro 
                        from '||trt_schema||'.usra_final_bv_amont bv_amont,
                    '||ref_schema||'.bv bv
                    where u.usra_id=bv_amont.usra_id 
                    and bv_amont.bv_id=bv.bv_id
                ) lat 
    )
    update '||ref_schema||'.usra u set ret_us = t.usage
        from tmp t
        where u.usra_id = t.usra_id;


    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  
  
  
  return 0;
END;
$$;


-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_ret_vol1(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
  seuil_1 text;
  seuil_2 text;
  seuil_3 text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
  
    seuil_1 := '30000';
    seuil_2 := '100000';
    seuil_3 := '300000';

    if ref_schema = 'ref_mayotte' then 
      seuil_1 := '20000';
      seuil_2 := '67000';
      seuil_3 := '200000';
    end if;

    if ref_schema = 'ref_hexagone' then 
      seuil_1 := '10000';
      seuil_2 := '33000';
      seuil_3 := '100000';
    end if;
 
    querystr:= '
      alter table '||ref_schema||'.bv drop column if exists vol_ret1 ;
      alter table '||ref_schema||'.bv add column vol_ret1 double precision;

      drop table if exists surf_by_bv;
      create temporary table surf_by_bv as (
          select b.bv_id,sum(a.volume_hm3) as surf
          from '||col_schema||'.retenues a 
          inner join '||ref_schema||'.bv b
              on st_intersects(a.geom,b.geom)
              where not a.source=''INRAE - Ouvrages écrêteurs''
              group by b.bv_id
      );
      update '||ref_schema||'.bv u set vol_ret1 = t.surf
      from surf_by_bv t
      where u.bv_id = t.bv_id;
      update '||ref_schema||'.bv u set vol_ret1 = 0 where vol_ret1 is null;

      alter table '||ref_schema||'.usra drop column if exists ret_vol1_v ;
      alter table '||ref_schema||'.usra add column ret_vol1_v double precision;
      alter table '||ref_schema||'.usra drop column if exists ret_vol1 ;
      alter table '||ref_schema||'.usra add column ret_vol1 text;
      comment on column '||ref_schema||'.usra.ret_vol1 is ''volume d''''eau stocké dans les retenues amont - discrétisation pour l''''évaluation de l''''impact sur le régime saisonnier'';
      comment on column '||ref_schema||'.usra.ret_vol1_v is ''volume d''''eau stocké dans les retenues amont - discrétisation pour l''''évaluation de l''''impact sur le régime saisonnier'';


      with tmp as(
        select u.usra_id,lat.ret_vol1_v*1000000/(lat.surface/1000000) as ret_vol1_v
        from '||ref_schema||'.usra u
                    cross join lateral (
                    select sum(bv.vol_ret1) as ret_vol1_v,sum(st_area(bv.geom)) as surface  
                        from '||trt_schema||'.usra_final_bv_amont bv_amont,
                    '||ref_schema||'.bv bv
                    where u.usra_id=bv_amont.usra_id 
                    and bv_amont.bv_id=bv.bv_id
                ) lat 
    )
    update '||ref_schema||'.usra u set ret_vol1_v = ROUND(t.ret_vol1_v::numeric,2)
        from tmp t
        where u.usra_id = t.usra_id;

    update '||ref_schema||'.usra u set ret_vol1_v = 0 where ret_vol1_v is null;
    update '||ref_schema||'.usra set ret_vol1=''faible'' where ret_vol1_v<'||seuil_1||' or ret_vol1_v is null;
    update '||ref_schema||'.usra set ret_vol1=''moyen'' where ret_vol1_v>='||seuil_1||';
    update '||ref_schema||'.usra set ret_vol1=''fort'' where ret_vol1_v>='||seuil_2||';
    update '||ref_schema||'.usra set ret_vol1=''tres_fort'' where ret_vol1_v>='||seuil_3||';

    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  
  
  
  return 0;
END;
$$;


-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_ret_vol2(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  srid int;
  seuil_1 text;
  seuil_2 text;
  seuil_3 text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
	  RAISE NOTICE 'schéma collecte (%)', col_schema;
  
    seuil_1 := '6000';
    seuil_2 := '21000';


    if ref_schema = 'ref_mayotte' then 
      seuil_1 := '4000';
      seuil_2 := '14000';

    end if;

    if ref_schema = 'ref_hexagone' or ref_schema = 'ref_guyane' then 
      seuil_1 := '2000';
      seuil_2 := '7000';
    end if;
 
    querystr:= '
      alter table '||ref_schema||'.bv drop column if exists vol_ret2 ;
      alter table '||ref_schema||'.bv add column vol_ret2 double precision;

      drop table if exists surf_by_bv;
      create temporary table surf_by_bv as (
          select b.bv_id,sum(a.volume_hm3) as surf
          from '||col_schema||'.retenues a 
          inner join '||ref_schema||'.bv b
              on st_intersects(a.geom,b.geom)
              group by b.bv_id
      );
      update '||ref_schema||'.bv u set vol_ret2 = t.surf
      from surf_by_bv t
      where u.bv_id = t.bv_id;
      update '||ref_schema||'.bv u set vol_ret2 = 0 where vol_ret2 is null;

      alter table '||ref_schema||'.usra drop column if exists ret_vol2_v ;
      alter table '||ref_schema||'.usra add column ret_vol2_v double precision;
      alter table '||ref_schema||'.usra drop column if exists ret_vol2 ;
      alter table '||ref_schema||'.usra add column ret_vol2 text;
      comment on column '||ref_schema||'.usra.ret_vol2 is ''volume d''''eau stocké dans les retenues amont - discrétisation pour l''''évaluation de l''''impact sur le régime des crues'';
      comment on column '||ref_schema||'.usra.ret_vol2_v is ''volume d''''eau stocké dans les retenues amont - discrétisation pour l''''évaluation de l''''impact sur le régime des crues'';

      
      with tmp as(
        select u.usra_id,lat.ret_vol2_v*1000000/(lat.surface/1000000) as ret_vol2_v
        from '||ref_schema||'.usra u
                    cross join lateral (
                    select sum(bv.vol_ret2) as ret_vol2_v,sum(st_area(bv.geom)) as surface  
                        from '||trt_schema||'.usra_final_bv_amont bv_amont,
                    '||ref_schema||'.bv bv
                    where u.usra_id=bv_amont.usra_id 
                    and bv_amont.bv_id=bv.bv_id
                ) lat 
    )
    update '||ref_schema||'.usra u set ret_vol2_v = ROUND(t.ret_vol2_v::numeric,2)
        from tmp t
        where u.usra_id = t.usra_id;
    update '||ref_schema||'.usra u set ret_vol2_v = 0 where ret_vol2_v is null;
    update '||ref_schema||'.usra set ret_vol2=''faible'' where ret_vol2_v<'||seuil_1||';
    update '||ref_schema||'.usra set ret_vol2=''moyen'' where ret_vol2_v>='||seuil_1||';
    update '||ref_schema||'.usra set ret_vol2=''fort'' where ret_vol2_v>='||seuil_2||';


    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  
  
  
  return 0;
END;
$$;

-- eclusées
-- eclu: que pour la metro et reunion
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_eclu(trt_schema text,ref_schema text,col_schema text)
    returns int
    language plpgsql
as
$calc_eclu$
DECLARE
    querystr text;
    row_cnt int8 := 0;
    eclu_exist bool := false;
BEGIN
    RAISE NOTICE 'schéma traitement (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;




    execute format($$
      alter table %1$I.usra drop column if exists eclu ;
      alter table %1$I.usra add column eclu text default 'absence';
      comment on column %1$I.usra.eclu is 'présence d''un ouvrage hydroélectrique fonctionnant par éclusées en amont (10+1 USRA)'$$, ref_schema);

    -- check if eclu table exists in col_schema (currently, only reunion, metropole)
    select exists(
        select null
        from information_schema.tables
        where table_schema = col_schema and table_name = 'eclusee'
    ) into eclu_exist;

    if eclu_exist then

        execute format($$
          alter table %1$I.eclusee drop column if exists geom_proj;
          alter table %1$I.eclusee add column geom_proj Geometry;
          with tmp as (
            select eclu.gid, t.usra_id, t.dist_lines,t.geom_proj
            from %1$I.eclusee eclu
                  cross join lateral (
                select usra.geom<->eclu.geom as dist_lines,usra.usra_id,ST_ClosestPoint(usra.geom, eclu.geom) as geom_proj  from %2$I.usra usra
                where ST_DWITHIN(usra.geom,eclu.geom,500)
            order by dist_lines asc
            limit 1
            ) as t
            ) update %1$I.eclusee eclu set geom_proj = t.geom_proj
                                      
            from tmp t
        where eclu.gid = t.gid$$, col_schema, ref_schema, trt_schema);

        querystr := format($$
        with tmp as (
            select distinct u.usra_id from %2$I.usra u 
        cross join lateral (
            select u2.geom
                from %3$I.usra_final_amont_aval u_av,
				              %2$I.usra u3,
                      %3$I.usra_final_amont_aval u2
                inner join %1$I.eclusee c
                  on st_dwithin(u2.geom,c.geom_proj,1)
                where u_av.usra_id=u.usra_id and u2.usra_id=u3.usra_id
                  and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt>=(u_av.cnt-10) and u2.cnt<=u_av.cnt
              ) lat2
        )
        update %2$I.usra u set eclu = 'presence'
        from tmp n
        where u.usra_id = n.usra_id$$, col_schema, ref_schema, trt_schema);

        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
        GET DIAGNOSTICS row_cnt = ROW_COUNT;
    else
        raise notice 'table %.eclu does not exist, skipping update...', col_schema;
    end if;

    raise notice 'Mise à jour de % usra pour la colonne ''eclu''', row_cnt;

    return 0;
END;
$calc_eclu$;


-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_haies(trt_schema text,ref_schema text,col_schema text)
    returns int
    language plpgsql
as
$calc_haies$
DECLARE
    querystr text;
    row_cnt int8 := 0;
    haie_exist bool := false;
BEGIN
    RAISE NOTICE 'schéma traitement (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;

    execute format($$
      alter table %1$I.usra drop column if exists haies ;
      alter table %1$I.usra drop column if exists haies_v ;
      alter table %1$I.usra add column haies text default 'moyen';
      comment on column %1$I.usra.haies is 'densité de haies dans le bassin versant';
      alter table %1$I.usra add column haies_v double precision;
      comment on column %1$I.usra.haies_v is 'densité de haies dans le bassin versant en km/km2'$$, ref_schema);

    if ref_schema = 'ref_hexagone' then 
      drop table if exists trt_metro.bv_haie;
      create table trt_metro.bv_haie as
      select b.bv_id , sum(st_length(st_intersection(b.geom, h.geometrie))) as sum_len_haie
        from ref_hexagone.bv b join bdtopo_metro.haie h on st_intersects(b.geom, h.geometrie)
    end if;

    -- check if bdtopo haie table exists in col_schema (currently, only metropole)
    select exists(
        select null
        from information_schema.tables
        where table_schema = col_schema and table_name = 'haie'
    ) into haie_exist;

    if haie_exist then
        querystr := format($$
        with tmp as (
            select u.usra_id, lat.bv_id, lat.haie_per_area, lat.area_bv_km2
            from %1$I.usra u
                     cross join lateral (
                select bv.bv_id,
                       bh.sum_len_haie * 1e3 / st_area(bv.geom) as haie_per_area,
                       st_area(bv.geom)*1e-6                       as area_bv_km2
                from %3$I.usra_final_bv_amont bv_amont,
                     %1$I.bv bv,
                     %3$I.bv_haie bh
                where u.usra_id = bv_amont.usra_id
                  and bv_amont.bv_id = bv.bv_id
                  and bv.bv_id = bh.bv_id
                ) lat
        ), tmp1 as (
            select usra_id, sum(area_bv_km2) as area_total
            from tmp
            group by usra_id
        ), tmp2 as (
            select usra_id, sum((haie_per_area * area_bv_km2) / area_total) as haie
            from tmp1
                     join tmp using (usra_id)
            group by usra_id
        )
        update %1$I.usra u set haies_v = n.haie, haies = case when n.haie < 0.1 then 'faible'
                                           when n.haie >= 0.1 and n.haie < 1 then 'moyen'
                                           else 'fort' end
        from tmp2 n
        where u.usra_id = n.usra_id$$, ref_schema, col_schema, trt_schema);

--         RAISE NOTICE '%',querystr;
        EXECUTE querystr;
        GET DIAGNOSTICS row_cnt = ROW_COUNT;
    else
        raise notice 'table %.haie does not exist, skipping update...', col_schema;
    end if;

    raise notice 'Mise à jour de % usra pour la colonne ''haies''', row_cnt;

    return 0;
end;
$calc_haies$;

-- conf: que pour la reunion, metropole
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_conf(trt_schema text,ref_schema text,col_schema text)
    returns int
    language plpgsql
as
$calc_conf$
DECLARE
    querystr text;
    row_cnt int8 := 0;
    eclu_exist bool := false;
BEGIN
    RAISE NOTICE 'schéma traitement (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;

    execute format($$
      alter table %1$I.usra drop column if exists conf ;
      alter table %1$I.usra add column conf text default 'absence';
      comment on column %1$I.usra.conf is 'présence d''une confluence majeure (en aval d''une usine HE à éclusées)'$$, ref_schema);

    -- check if eclusee table exists in col_schema (currently, only reunion, metropole)
    select exists(
        select null
        from information_schema.tables
        where table_schema = col_schema and table_name = 'eclusee'
    ) into eclu_exist;

    if eclu_exist then
        querystr := format($$
        with tmp as (
            select distinct u.usra_id from %2$I.usra u 
        cross join lateral (
            select u2.geom
                from %3$I.usra_final_amont_aval u_av,
				              %2$I.usra u3,
                      %2$I.tgh tgh3,
                      %2$I.tgh tgh,
                      %3$I.usra_final_amont_aval u2
                inner join %1$I.eclusee c
                  on st_dwithin(u2.geom,c.geom_proj,1)
                where u_av.usra_id=u.usra_id and tgh.rang<>tgh3.rang 
                and u2.usra_id=u3.usra_id and u3.tgh_id=tgh3.tgh_id 
                and u.tgh_id=tgh.tgh_id
                  and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt>=(u_av.cnt-10) and u2.cnt<=u_av.cnt
              ) lat2
        )
        update %2$I.usra u set conf = 'presence'
        from tmp n
        where u.usra_id = n.usra_id$$, col_schema, ref_schema, trt_schema);

        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
        GET DIAGNOSTICS row_cnt = ROW_COUNT;
    else
        raise notice 'table %.conf does not exist, skipping update...', col_schema;
    end if;

    raise notice 'Mise à jour de % usra pour la colonne ''conf''', row_cnt;

    return 0;
END;
$calc_conf$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_sensisol(trt_schema text,ref_schema text,col_schema text)
    returns int
    language plpgsql
as
$calc_sensisol$
DECLARE
    querystr text;
    row_cnt int8 := 0;
    sensisol_exist bool := false;
BEGIN
    RAISE NOTICE 'schéma traitement (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;

    execute format($$
      alter table %1$I.usra drop column if exists sensisol ;
      alter table %1$I.usra drop column if exists sensisol_v ;
      alter table %1$I.usra add column sensisol text default 'moyen';
      comment on column %1$I.usra.sensisol is 'sensibilité des sols à l''érosion';
      alter table %1$I.usra add column sensisol_v double precision;
      comment on column %1$I.usra.sensisol_v is 'sensibilité des sols à l''érosion'$$, ref_schema);

    -- check if sensibilite_erosion_sols table exists in col_schema (currently, only metropole)
    select exists(
        select null
        from information_schema.tables
        where table_schema = col_schema and table_name = 'sensibilite_erosion_sols'
    ) into sensisol_exist;

    if sensisol_exist then
        querystr := format($$
        with tmp as (
            select u.usra_id, lat.bv_id, lat.kr_cor, lat.area_bv_km2
            from %2$I.usra u
                     cross join lateral (
                select bv.bv_id,
                       s.kr_cor,
                       st_area(bv.geom)*1e-6                       as area_bv_km2
                from %3$I.usra_final_bv_amont bv_amont,
                     %2$I.bv bv,
                     %1$I.sensibilite_erosion_sols s
                where u.usra_id = bv_amont.usra_id
                  and bv_amont.bv_id = bv.bv_id
                  and st_contains(bv.geom, st_pointonsurface(s.geom))
                ) lat
        ), tmp1 as (
            select usra_id, sum(area_bv_km2) as area_total
            from tmp
            group by usra_id
        ), tmp2 as (
            select usra_id, sum((kr_cor * area_bv_km2) / area_total) as sensisol
            from tmp1
                     join tmp using (usra_id)
            group by usra_id
        )
        update %2$I.usra u set sensisol_v=n.sensisol,sensisol = case when n.sensisol < 20 then 'faible'
                                            when n.sensisol >= 20 and n.sensisol < 34.5 then 'moyen'
                                            else 'fort' end
        from tmp2 n
        where u.usra_id = n.usra_id$$, col_schema, ref_schema, trt_schema);

        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
        GET DIAGNOSTICS row_cnt = ROW_COUNT;
    else
        raise notice 'table %.sensisol does not exist, skipping update...', col_schema;
    end if;

    raise notice 'Mise à jour de % usra pour la colonne ''sensisol''', row_cnt;

    return 0;
END;
$calc_sensisol$;
