
-- Calcul de intercepte : taux de bassin versant intercepté par les grands barrages


-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_intercepte(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
    querystr text;
    seuil_1 text;
    seuil_2 text;
    occ_filter text;
    occ_table text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

    seuil_1 := '10';
    seuil_2 := '30';

    querystr:= '
        alter table '||ref_schema||'.usra drop column if exists intercep_v ;
        alter table '||ref_schema||'.usra add column intercep_v double precision;
        alter table '||ref_schema||'.usra drop column if exists intercepte ;
        alter table '||ref_schema||'.usra add column intercepte text;
        comment on column '||ref_schema||'.usra.intercep_v is ''taux de bassin versant intercepté par les grands barrages'';
        comment on column '||ref_schema||'.usra.intercepte is ''taux de bassin versant intercepté par les grands barrages'';
        update '||ref_schema||'.usra set intercepte=''faible'';
        update '||ref_schema||'.usra set intercep_v=0;
        ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    querystr:= '
        -- GRANDS BARRAGES -- 
        DROP TABLE IF EXISTS '||trt_schema||'.gd_barrages;
        CREATE TABLE '||trt_schema||'.gd_barrages as (
            select roe.* from '||trt_schema||'.roe_reseau_coulant roe
            inner join '||ref_schema||'.tgh tgh on roe.tgh_id=tgh.tgh_id
            where 
            (
                (tgh.rang = 1 and roe.haut_chut >=3 and roe.haut_chut *roe.haut_chut*100 / tgh.pente_lit>=1500)
                OR (tgh.rang = 2 and roe.haut_chut >=4 and roe.haut_chut *roe.haut_chut*100 / tgh.pente_lit>=3000)
                OR (tgh.rang = 3 and roe.haut_chut >=6 and roe.haut_chut *roe.haut_chut*100 / tgh.pente_lit>=8000)
                OR (tgh.rang = 4 and roe.haut_chut >=8 and roe.haut_chut *roe.haut_chut*100 / tgh.pente_lit>=16000)
                OR (tgh.rang = 5 and roe.haut_chut >=10 and roe.haut_chut *roe.haut_chut*100 / tgh.pente_lit>=30000)
                OR (tgh.rang > 5 and roe.haut_chut >=10 and roe.haut_chut *roe.haut_chut*100 / tgh.pente_lit>=200000)
            )
            and tgh.pente_lit>0
        );


        -- USRA Avec gd barrage en amont
        DROP TABLE IF EXISTS usra_with_gd_barrages_amont;
        CREATE TEMPORARY TABLE usra_with_gd_barrages_amont as (
        select u.usra_id,
            ARRAY_AGG (distinct lat.usra_id) as list_usra_barrage,
            ARRAY_AGG ( distinct bvamont.bv_id) as list_bv_usra_barrage
             from '||ref_schema||'.usra u
            inner join '||trt_schema||'.usra_final_amont amonts
            on u.usra_id=amonts.usra_id 
        cross join lateral (
            select u2.usra_id from '||ref_schema||'.usra u2,'||trt_schema||'.gd_barrages bar where ARRAY[u2.usra_id] <@ amonts.array_agg
            and st_dwithin(bar.projected_geom,u2.geom,1)
        ) lat
        --liste des bv amonts des usras avec barrage
        cross join lateral (
            select bv.bv_id
                from '||trt_schema||'.usra_final_bv_amont bv_amont,
            '||ref_schema||'.bv bv
            where lat.usra_id=bv_amont.usra_id 
            and bv_amont.bv_id=bv.bv_id
        ) bvamont
        GROUP BY u.usra_id
        );

        ';

        RAISE NOTICE '%',querystr;
        EXECUTE querystr;

        -- defaut query using surface
        querystr:= '
            DROP TABLE IF EXISTS usra_taux_bv_inter;
            CREATE TEMPORARY TABLE usra_taux_bv_inter as (
                select u.usra_id,lat2.surface*100/surface_bv_usra as taux from usra_with_gd_barrages_amont u
                cross join lateral (
                    select sum(st_area(bv.geom)) as surface_bv_usra 
                        from '||trt_schema||'.usra_final_bv_amont bv_amont,
                        '||ref_schema||'.bv bv
                    where u.usra_id=bv_amont.usra_id 
                    and bv_amont.bv_id=bv.bv_id
                ) lat
                cross join lateral (
                    select sum(st_area(bv.geom)) as surface 
                        from '||ref_schema||'.bv bv
                    where ARRAY[bv.bv_id] <@ u.list_bv_usra_barrage 
                ) lat2
                order by u.usra_id	
            );
        ';

        if ref_schema = 'ref_hexagone' then

            --  query for hexagone using nb usra 
            querystr:= '
            DROP TABLE IF EXISTS usra_taux_bv_inter;
            CREATE TEMPORARY TABLE usra_taux_bv_inter as (
                select u.usra_id,count(distinct lat3.d)*100/array_length(array_agg,1) as taux from usra_with_gd_barrages_amont u
                cross join lateral (
                    select * from '||trt_schema||'.usra_final_amont amonts where u.usra_id=amonts.usra_id
                ) lat
                cross join lateral (
                    select distinct unnest(list_usra_barrage) as id_usra_bar from usra_with_gd_barrages_amont u2 
                    where u2.usra_id=u.usra_id
                                ) lat2
                cross join lateral (
                    select  unnest(array_agg) as d from '||trt_schema||'.usra_final_amont amonts
                    where amonts.usra_id=lat2.id_usra_bar
                ) lat3	
                group by u.usra_id,array_length(array_agg,1)
                order by u.usra_id
            );
            ';
        end if;
        

        RAISE NOTICE '%',querystr;
        EXECUTE querystr;

        querystr:= '
        update '||ref_schema||'.usra u set intercep_v = ROUND(t.taux::numeric,2)
            from usra_taux_bv_inter t
            where u.usra_id = t.usra_id;

        update '||ref_schema||'.usra set intercepte=''moyen'' where intercep_v>='||seuil_1||';
        update '||ref_schema||'.usra set intercepte=''fort'' where intercep_v>='||seuil_2||';
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
 
  
  return 0;
END;
$$;

-- taux d'imperméabilisation du bassin versant
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_imper(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
    querystr text;
    seuil_1 text;
    seuil_2 text;
    occ_filter text;
    occ_table text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

    seuil_1 := '10';
    seuil_2 := '25';
    occ_filter  := '';
    occ_table := 'occsol';

    querystr:= '
        alter table '||ref_schema||'.bv drop column if exists surf_imper ;
        alter table '||ref_schema||'.bv add column surf_imper double precision;
        alter table '||ref_schema||'.usra drop column if exists imper_v ;
        alter table '||ref_schema||'.usra add column imper_v double precision;
        alter table '||ref_schema||'.usra drop column if exists imper ;
        alter table '||ref_schema||'.usra add column imper text;
        comment on column '||ref_schema||'.usra.imper is ''taux d''''imperméabilisation du bassin versant'';
        comment on column '||ref_schema||'.usra.imper_v is ''taux d''''imperméabilisation du bassin versant'';
        update '||ref_schema||'.usra set imper=''faible'';
        ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    if ref_schema = 'ref_martinique' then 
        occ_table := 'occsol_2017';
        occ_filter  := 'CODE_CS = ''CS1.1.1.1'' or CODE_CS = ''CS1.1.1.2''';
    end if;
    if ref_schema = 'ref_guadeloupe' then 
        occ_table := 'karucover_2017';
        occ_filter  := '(typcsn3 = ''CS1.1.1'')';
    end if;
    if ref_schema = 'ref_mayotte' then 
        occ_table := 'occsol_2016';
         occ_filter  := 'CODE_CS = ''CS1.1.1.1'' or CODE_CS = ''CS1.1.1.2''';
    end if;
    if ref_schema = 'ref_guyane' then 
        occ_table := 'occsol_2015';
        occ_filter  := 'niveau3_15 IN( ''111'', ''112'',''121'',''122'',''123'',''124'')';
    end if;
    if ref_schema = 'ref_reunion' then 
        occ_table := 'occsol';
        occ_filter  := 'code3 IN (28,30) ';
    end if;
    if ref_schema = 'ref_hexagone' then 
        occ_table := 'oso2021';
        occ_filter  := 'classe IN (1,2,3,4) ';
    end if;
    querystr:= '
    drop table if exists '||trt_schema||'.imper;
    create table '||trt_schema||'.imper as (
        select * from '||col_schema||'.'||occ_table||' where '||occ_filter||'
       
    );
    update '||trt_schema||'.imper set geom=St_makevalid(geom) where not st_isvalid(geom);
    create index on '||trt_schema||'.imper using gist(geom);
    drop table if exists surf_by_bv;
    create temporary table surf_by_bv as (
        select b.bv_id,sum(st_area(st_intersection(a.geom,b.geom))) as surf_imper from '||trt_schema||'.imper a inner join '||ref_schema||'.bv b
            on st_intersects(a.geom,b.geom)
            group by b.bv_id
    );
    update '||ref_schema||'.bv u set surf_imper = t.surf_imper
    from surf_by_bv t
    where u.bv_id = t.bv_id;
    update '||ref_schema||'.bv u set surf_imper = 0 where surf_imper is null;

    with tmp as(
        select u.usra_id,lat.surf,lat.surface,(lat.surf/lat.surface)*100 as taux from '||ref_schema||'.usra u
            cross join lateral (
            select sum(surf_imper) as surf,sum(st_area(bv.geom)) as surface 
                from '||trt_schema||'.usra_final_bv_amont bv_amont,
            '||ref_schema||'.bv bv
            where u.usra_id=bv_amont.usra_id 
            and bv_amont.bv_id=bv.bv_id
        ) lat 
    )
    update '||ref_schema||'.usra u set imper_v = ROUND(t.taux::numeric,2)
        from tmp t
        where u.usra_id = t.usra_id;

    update '||ref_schema||'.usra set imper=''moyen'' where imper_v>='||seuil_1||';
    update '||ref_schema||'.usra set imper=''fort'' where imper_v>='||seuil_2||';
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
 


  
  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_orp_proche(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  


  querystr:= '

      alter table '||ref_schema||'.usra drop column if exists orp_proche ;
      alter table '||ref_schema||'.usra add column orp_proche text;
      comment on column '||ref_schema||'.usra.orp_proche is ''présence de site(s) d''''orpaillage sur le tronçon et en aval proche (5+1 USRA)'';
      update '||ref_schema||'.usra set orp_proche=''absence'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      CREATE TEMPORARY TABLE tmp as(
        select distinct u.usra_id from '||ref_schema||'.usra u 
        cross join lateral (
                select st_intersects(u2.geom,c.geom)
                from '||trt_schema||'.usra_final_amont_aval u_av,
                '||trt_schema||'.usra_final_amont_aval u2 
            inner join '||col_schema||'.camino c
                on st_intersects(u2.geom,c.geom)
                where u_av.usra_id=u.usra_id
                    and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt<(u_av.cnt+5) and u2.cnt>=u_av.cnt
              ) lat2
      );
      update '||ref_schema||'.usra u set orp_proche = ''presence''
      from tmp t
      where u.usra_id = t.usra_id;

    ';

  if ref_schema = 'ref_guyane' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_curage(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
  RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  


  querystr:= '

      alter table '||ref_schema||'.usra drop column if exists curage ;
      alter table '||ref_schema||'.usra add column curage text;
      comment on column '||ref_schema||'.usra.curage is ''travaux de curage sur le tronçon et en amont proche (5+1 USRA)'';
      update '||ref_schema||'.usra set curage=''absence'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      drop table if exists tmp;
      CREATE TEMPORARY TABLE tmp as(
        select distinct u.usra_id from '||ref_schema||'.usra u
        inner join '||ref_schema||'.tgh tgh
        on u.tgh_id=tgh.tgh_id
        cross join lateral (
                select u2.usra_id
                from '||trt_schema||'.usra_final_amont_aval u_av,
                '||trt_schema||'.usra_final_amont_aval u2 
            inner join '||col_schema||'.curage b
                on ( st_dwithin(st_lineinterpolatepoint(u2.geom,0.1),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.15),b.geom,tgh.largeur_pb/2)  )
                or ( st_dwithin(st_lineinterpolatepoint(u2.geom,0.2),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.25),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u2.geom,0.3),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.35),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u2.geom,0.4),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.45),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u2.geom,0.5),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.65),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u2.geom,0.6),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.65),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u2.geom,0.7),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.75),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u2.geom,0.8),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.85),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u2.geom,0.9),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u2.geom,0.95),b.geom,tgh.largeur_pb/2)  )
                where u_av.usra_id=u.usra_id
                    and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt>=(u_av.cnt-5) and u2.cnt<=u_av.cnt
              ) lat2
      );
      update '||ref_schema||'.usra u set curage = ''presence''
      from tmp t
      where u.usra_id = t.usra_id;

    ';

  if ref_schema = 'ref_martinique' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;

  
  return 0;
END;
$$;
