
-- Calcul de obsmax1 : hauteur maximale des obstacles en aval
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_obsmax1(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '2';
  seuil_2 := '25';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists obsmax1_v ;
      alter table '||ref_schema||'.usra add column obsmax1_v double precision;
      alter table '||ref_schema||'.usra drop column if exists obsmax1 ;
      alter table '||ref_schema||'.usra add column obsmax1 text;
      comment on column '||ref_schema||'.usra.obsmax1_v is ''hauteur maximale des obstacles en aval en m'';
      comment on column '||ref_schema||'.usra.obsmax1 is ''hauteur maximale des obstacles en aval'';
      update '||ref_schema||'.usra set obsmax1=''aucun'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;


  if ref_schema = 'ref_hexagone' then 
    seuil_1 := '1.75';
    seuil_2 := '10';
   end if;
  
  querystr:= '
      with tmp as(
        select u.usra_id,lat.obsmax1_v from '||ref_schema||'.usra u
        cross join lateral (
        select max(roe.haut_chut) obsmax1_v 
        from '||trt_schema||'.usra_final_amont usra_amont 
        inner join '||trt_schema||'.roe_reseau_coulant roe 
        on st_dwithin(roe.projected_geom,usra_amont.geom ,1)
            where ARRAY[u.usra_id] <@ usra_amont.array_agg and roe.haut_chut>=0.15
        ) lat 
      )	
      update '||ref_schema||'.usra u set obsmax1_v = ROUND(t.obsmax1_v::numeric,2)
      from tmp t
      where u.usra_id = t.usra_id;

      update '||ref_schema||'.usra set obsmax1=''faible'' where obsmax1_v>=0.15;
      update '||ref_schema||'.usra set obsmax1=''moyen'' where obsmax1_v>='||seuil_1||';
      update '||ref_schema||'.usra set obsmax1=''fort'' where obsmax1_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_obsmax2(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
  start_loop numeric;
  end_loop numeric;
  maxloop int;
  cutNumber int;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  
  cutNumber:= 50000;
  seuil_1 := '1.15';
  seuil_2 := '25';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists obsmax2_v ;
      alter table '||ref_schema||'.usra add column obsmax2_v double precision;
      alter table '||ref_schema||'.usra drop column if exists obsmax2 ;
      alter table '||ref_schema||'.usra add column obsmax2 text;
      comment on column '||ref_schema||'.usra.obsmax2_v is ''hauteur maximale des obstacles autour de l''''USRA (USRA évaluée + 5 amont + 5 aval) en m'';
      comment on column '||ref_schema||'.usra.obsmax2 is ''hauteur maximale des obstacles autour de l''''USRA (USRA évaluée + 5 amont + 5 aval)'';
      update '||ref_schema||'.usra set obsmax2=''aucun'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;


  if ref_schema = 'ref_hexagone' or ref_schema = 'ref_guyane' then 
    seuil_1 := '1';
    seuil_2 := '10';
   end if;
  



  

  querystr:= '
    drop table if exists '||trt_schema||'.usra_with_roe ;
    create table  '||trt_schema||'.usra_with_roe as (
    select u2.*,roe.haut_chut from '||ref_schema||'.usra  u2 
      inner join '||trt_schema||'.roe_reseau_coulant roe 
            on st_dwithin(roe.projected_geom,u2.geom ,1)
      where roe.haut_chut>=0.15
    );
    create index on '||trt_schema||'.usra_with_roe(usra_id);
    set enable_seqscan = off;
    drop table if exists tmp;
      create temporary table tmp as(
        with u as (select * from '||ref_schema||'.usra u where usra_id>0 and usra_id<'||cutNumber||')
        select u.usra_id,lat.obsmax2_v from  u
                cross join lateral (
                select max(usra_with_roe.haut_chut) obsmax2_v 
                from '||trt_schema||'.usra_final_amont_aval u_av,
                     '||trt_schema||'.usra_final_amont_aval u2,
                     '||trt_schema||'.usra_with_roe
                    where  u_av.usra_id=u.usra_id and u2.usra_id=usra_with_roe.usra_id
                    and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt<=(u_av.cnt+5) and u2.cnt>=(u_av.cnt-5)
                ) lat 
      );
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  EXECUTE 'select ceil(max(usra_id)/'||cutNumber||'::float) from '||ref_schema||'.usra u ' into maxloop;
  for counter in 1..maxloop loop
    start_loop := counter*cutNumber;
    end_loop := (counter+1)*cutNumber;
	  raise notice 'from: % to %', start_loop,end_loop;
    querystr:= '
       insert into tmp(
		with u as (select * from '||ref_schema||'.usra u where usra_id>='||start_loop||' and usra_id<'||end_loop||')
        select u.usra_id,lat.obsmax2_v from  u
                cross join lateral (
                select max(usra_with_roe.haut_chut) obsmax2_v
                from '||trt_schema||'.usra_final_amont_aval u_av,
                     '||trt_schema||'.usra_final_amont_aval u2,
                     '||trt_schema||'.usra_with_roe
                    where  u_av.usra_id=u.usra_id and u2.usra_id=usra_with_roe.usra_id
                    and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt<=(u_av.cnt+5) and u2.cnt>=(u_av.cnt-5)
                ) lat
      );
      ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

  end loop;

  querystr:= '
      update '||ref_schema||'.usra u set obsmax2_v = ROUND(t.obsmax2_v::numeric,2)
      from tmp t
      where u.usra_id = t.usra_id;

      update '||ref_schema||'.usra set obsmax2=''faible'' where obsmax2_v>=0.15;
      update '||ref_schema||'.usra set obsmax2=''moyen'' where obsmax2_v>='||seuil_1||';
      update '||ref_schema||'.usra set obsmax2=''fort'' where obsmax2_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  
  return 0;
END;
$$;


-- calcul du descripteur txetg1
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_txetg1(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '10';
  seuil_2 := '30';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists txetg1_v ;
      alter table '||ref_schema||'.usra add column txetg1_v double precision default 0;
      alter table '||ref_schema||'.usra drop column if exists txetg1 ;
      alter table '||ref_schema||'.usra add column txetg1 text;
      comment on column '||ref_schema||'.usra.txetg1_v is ''taux d''''étagement des tronçons aval'';
      comment on column '||ref_schema||'.usra.txetg1 is ''taux d''''étagement des tronçons aval'';
      update '||ref_schema||'.usra set txetg1=''faible'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      with tmp as(
        select u.usra_id,lat.taux as txetg1_v from '||ref_schema||'.usra u
        cross join lateral (
          select CASE WHEN sum(u2.zamont-u2.zaval)>0 THEN sum(u2.txetg3_v *(u2.zamont-u2.zaval))/sum(u2.zamont-u2.zaval) ELSE 0 END as taux
          from '||trt_schema||'.usra_final_amont usra_amont,'||ref_schema||'.usra u2
          where ARRAY[u.usra_id] <@ usra_amont.array_agg and u2.usra_id=usra_amont.usra_id
        ) lat
        order by u.usra_id
       
      )	
      update '||ref_schema||'.usra u set txetg1_v = ROUND(t.txetg1_v::numeric,2)
      from tmp t
      where u.usra_id = t.usra_id;

     
      update '||ref_schema||'.usra set txetg1=''moyen'' where txetg1_v>='||seuil_1||';
      update '||ref_schema||'.usra set txetg1=''fort'' where txetg1_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_txetg2(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '10';
  seuil_2 := '30';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists txetg2_v ;
      alter table '||ref_schema||'.usra add column txetg2_v double precision default 0;
      alter table '||ref_schema||'.usra drop column if exists txetg2 ;
      alter table '||ref_schema||'.usra add column txetg2 text;
      comment on column '||ref_schema||'.usra.txetg2_v is ''taux d''''étagement des tronçons autour de l''''USRA (USRA évaluée + 5 amont + 5 aval)'';
      comment on column '||ref_schema||'.usra.txetg2 is ''taux d''''étagement des tronçons autour de l''''USRA (USRA évaluée + 5 amont + 5 aval)'';
      update '||ref_schema||'.usra set txetg2=''faible'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
	  
 querystr:= '
      drop table if exists tmp2 ;
      create temporary table tmp2 as (
       select u.usra_id,lat2.taux as txetg2_v from '||ref_schema||'.usra u
        cross join lateral (
          select case when sum(ll.lg) >0 THEN sum(ll.v)/sum(ll.lg) ELSE 0 END as taux from (select distinct u3.usra_id as usid,
          u3.txetg3_v *(u3.zamont-u3.zaval) as v,
			      (u3.zamont-u3.zaval) as lg
           from '||trt_schema||'.usra_final_amont_aval u_av,
             '||trt_schema||'.usra_final_amont_aval u2,
             '||ref_schema||'.usra u3 
          where u_av.usra_id=u.usra_id
			      and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt<=(u_av.cnt+5) and u2.cnt>=(u_av.cnt-5)
            and u2.usra_id=u3.usra_id) ll
        ) lat2
      );
      create index on tmp2 (usra_id);

      update '||ref_schema||'.usra u set txetg2_v = ROUND(t2.txetg2_v::numeric,2)
      from tmp2 t2
      where u.usra_id=t2.usra_id;

     
      update '||ref_schema||'.usra set txetg2=''moyen'' where txetg2_v>='||seuil_1||';
      update '||ref_schema||'.usra set txetg2=''fort'' where txetg2_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_txetg3(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '10';
  seuil_2 := '30';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists txetg3_v ;
      alter table '||ref_schema||'.usra add column txetg3_v double precision default 0;
      alter table '||ref_schema||'.usra drop column if exists txetg3 ;
      alter table '||ref_schema||'.usra add column txetg3 text;
      comment on column '||ref_schema||'.usra.txetg3_v is ''taux d''''étagement du tronçon (appliqué aux faciès et à l''''artificialisation du lit)'';
      comment on column '||ref_schema||'.usra.txetg3 is ''taux d''''étagement du tronçon (appliqué aux faciès et à l''''artificialisation du lit)'';
      update '||ref_schema||'.usra set txetg3=''faible'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      with tmp as(
        select u.usra_id,ROUND((lat.lgremous*100/st_length(u.geom))::numeric,2) as txetg3_v from '||ref_schema||'.usra u
        cross join lateral (
        select st_length(st_intersection(st_union(distinct remous.geom),u.geom,0.1)) as lgremous
         from '||trt_schema||'.roe_reseau_coulant roe 
        inner join '||ref_schema||'.remous_liquide remous 
          on remous.ogc_fid=roe.ogc_fid
        where st_dwithin(remous.geom,u.geom ,1) and roe.haut_chut>=0.15
        ) lat 
       
      )	
      update '||ref_schema||'.usra u set txetg3_v = ROUND(t.txetg3_v::numeric,2)
      from tmp t
      where u.usra_id = t.usra_id;

     
      update '||ref_schema||'.usra set txetg3=''moyen'' where txetg3_v>='||seuil_1||';
      update '||ref_schema||'.usra set txetg3=''fort'' where txetg3_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_txetg4(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '10';
  seuil_2 := '30';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists txetg4_v ;
      alter table '||ref_schema||'.usra add column txetg4_v double precision default 0;
      alter table '||ref_schema||'.usra drop column if exists txetg4 ;
      alter table '||ref_schema||'.usra add column txetg4 text;
      comment on column '||ref_schema||'.usra.txetg4_v is ''taux d''''étagement du tronçon (appliqué à la continuité latérale et aux connexion avec la nappe)'';
      comment on column '||ref_schema||'.usra.txetg4 is ''taux d''''étagement du tronçon (appliqué à la continuité latérale et aux connexion avec la nappe)'';
      update '||ref_schema||'.usra set txetg4=''faible'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '

      with tmp as(
        select u.usra_id,ROUND((lat.lgremous*100/st_length(u.geom))::numeric,2) as txetg4_v from '||ref_schema||'.usra u
        cross join lateral (
        select st_length(st_intersection(st_union(distinct remous.geom),u.geom,0.1)) as lgremous
         from '||trt_schema||'.roe_reseau_coulant roe 
        inner join '||ref_schema||'.remous_liquide remous 
          on remous.ogc_fid=roe.ogc_fid
        where st_dwithin(remous.geom,u.geom ,1) and roe.haut_chut>=1 and not (roe.type_code=''1.4'' and roe.stype_code=''2'')
        ) lat 
       
      )	
      update '||ref_schema||'.usra u set txetg4_v = ROUND(t.txetg4_v::numeric,2)
      from tmp t
      where u.usra_id = t.usra_id;


     
      update '||ref_schema||'.usra set txetg4=''moyen'' where txetg4_v>='||seuil_1||';
      update '||ref_schema||'.usra set txetg4=''fort'' where txetg4_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  return 0;
END;
$$;

-- taux d'étagement des tronçons amont (appliqué aux flux sédimentaires)
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_txetg5(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '10';
  seuil_2 := '30';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists txetg5_v ;
      alter table '||ref_schema||'.usra add column txetg5_v double precision default 0;
      alter table '||ref_schema||'.usra drop column if exists txetg5 ;
      alter table '||ref_schema||'.usra add column txetg5 text;
      comment on column '||ref_schema||'.usra.txetg5_v is ''taux d''''étagement des tronçons amont (appliqué aux flux sédimentaires)'';
      comment on column '||ref_schema||'.usra.txetg5 is ''taux d''''étagement des tronçons amont (appliqué aux flux sédimentaires)'';
      update '||ref_schema||'.usra set txetg5=''faible'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      drop table if exists tmp2 ;
      create temporary table tmp2 as (
       select u.usra_id,lat2.taux as txetg5_v from '||ref_schema||'.usra u
        cross join lateral (
          select case when sum(ll.lg) >0 THEN sum(ll.v)/sum(ll.lg) ELSE 0 END as taux from (select distinct u3.usra_id as usid,
          u3.txetg4_v *(u3.zamont-u3.zaval) as v,
			      (u3.zamont-u3.zaval) as lg
           from '||trt_schema||'.usra_final_amont_aval u_av,
             '||trt_schema||'.usra_final_amont_aval u2,
             '||ref_schema||'.usra u3 
          where u_av.usra_id=u.usra_id
			      and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt<=u_av.cnt
            and u2.usra_id=u3.usra_id) ll
        ) lat2
      );
      create index on tmp2 (usra_id);

      update '||ref_schema||'.usra u set txetg5_v = ROUND(t2.txetg5_v::numeric,2)
      from tmp2 t2
      where u.usra_id=t2.usra_id;

     
      update '||ref_schema||'.usra set txetg5=''moyen'' where txetg5_v>='||seuil_1||';
      update '||ref_schema||'.usra set txetg5=''fort'' where txetg5_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_dobs1(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '0.05';
  seuil_2 := '0.2';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists dobs1_v ;
      alter table '||ref_schema||'.usra add column dobs1_v double precision default 0;
      alter table '||ref_schema||'.usra drop column if exists dobs1 ;
      alter table '||ref_schema||'.usra add column dobs1 text;
      comment on column '||ref_schema||'.usra.dobs1_v is ''densité d''''obstacles en aval'';
      comment on column '||ref_schema||'.usra.dobs1 is ''densité d''''obstacles en aval'';
      update '||ref_schema||'.usra set dobs1=''faible'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      with tmp as(
        select u.usra_id,ROUND(lat.ct/(lat2.lg/1000)::numeric,2) as dobs1_v from '||ref_schema||'.usra u
        cross join lateral (
          select st_length(st_union(distinct usra_amont.geom)) as lg
          from '||trt_schema||'.usra_final_amont usra_amont 
          where ARRAY[u.usra_id] <@ usra_amont.array_agg
        ) lat2
        cross join lateral (
        select count( roe.ogc_fid) as ct
        from '||trt_schema||'.usra_final_amont usra_aval 
        inner join '||trt_schema||'.roe_reseau_coulant roe 
          on st_dwithin(roe.projected_geom,usra_aval.geom ,1)
        where ARRAY[u.usra_id] <@ usra_aval.array_agg and roe.haut_chut>=0.15
        ) lat 
       
      )	
      update '||ref_schema||'.usra u set dobs1_v = ROUND(t.dobs1_v::numeric,2)
      from tmp t
      where u.usra_id = t.usra_id and t.dobs1_v is not null;

     
      update '||ref_schema||'.usra set dobs1=''moyen'' where dobs1_v>='||seuil_1||';
      update '||ref_schema||'.usra set dobs1=''fort'' where dobs1_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_dobs2(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
  seuil_1 text;
  seuil_2 text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  

  seuil_1 := '0.05';
  seuil_2 := '0.2';

  querystr:= '
      alter table '||ref_schema||'.usra drop column if exists dobs2_v ;
      alter table '||ref_schema||'.usra add column dobs2_v double precision default 0;
      alter table '||ref_schema||'.usra drop column if exists dobs2 ;
      alter table '||ref_schema||'.usra add column dobs2 text;
      comment on column '||ref_schema||'.usra.dobs2_v is ''densité d''''obstacles autour de l''''USRA (USRA évaluée + 5 amont + 5 aval)'';
      comment on column '||ref_schema||'.usra.dobs2 is ''densité d''''obstacles autour de l''''USRA (USRA évaluée + 5 amont + 5 aval)'';
      update '||ref_schema||'.usra set dobs2=''aucun'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '


    drop table if exists '||trt_schema||'.usra_with_roe;
    create table  '||trt_schema||'.usra_with_roe as (
    select u2.*,roe.haut_chut from '||ref_schema||'.usra  u2 
      inner join '||trt_schema||'.roe_reseau_coulant roe 
            on st_dwithin(roe.projected_geom,u2.geom ,1)
      where roe.haut_chut>=0.15
    );
    create index on '||trt_schema||'.usra_with_roe(usra_id);
    set enable_seqscan = off;



      with tmp as(
        select u.usra_id,ROUND(lat.ct/(lat2.lg/1000)::numeric,2) as dobs2_v from '||ref_schema||'.usra u
        cross join lateral (
          select sum(st_length(b.geom)) as lg from (select distinct u2.geom
          from '||trt_schema||'.usra_final_amont_aval u_av,'||trt_schema||'.usra_final_amont_aval u2 
          where u_av.usra_id=u.usra_id and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt<=(u_av.cnt+5) and u2.cnt>=(u_av.cnt-5)) b
        ) lat2
        cross join lateral (
          select count( usra_with_roe.usra_id) as ct
          from '||trt_schema||'.usra_final_amont_aval u_av,'||trt_schema||'.usra_final_amont_aval u2,
          '||trt_schema||'.usra_with_roe
        where u_av.usra_id=u.usra_id and  u2.usra_id=usra_with_roe.usra_id
			      and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt<=(u_av.cnt+5) and u2.cnt>=(u_av.cnt-5)
        ) lat 
       
      )	
      update '||ref_schema||'.usra u set dobs2_v = ROUND(t.dobs2_v::numeric,2)
      from tmp t
      where u.usra_id = t.usra_id and t.dobs2_v is not null;

      update '||ref_schema||'.usra set dobs2=''faible'' where dobs2_v>0;
      update '||ref_schema||'.usra set dobs2=''moyen'' where dobs2_v>='||seuil_1||';
      update '||ref_schema||'.usra set dobs2=''fort'' where dobs2_v>='||seuil_2||';

    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;

  
  return 0;
END;
$$;


-- !! le CREATE TEMPORARY TABLE tmp à la place de WITH tmp change le query plan ?? et la requete passe de 45min a 1 min
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_orp_aval(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  


  querystr:= '

      alter table '||ref_schema||'.usra drop column if exists orp_aval ;
      alter table '||ref_schema||'.usra add column orp_aval text;
      comment on column '||ref_schema||'.usra.orp_aval is ''présence de site(s) d''''orpaillage en aval'';
      update '||ref_schema||'.usra set orp_aval=''absence'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      CREATE TEMPORARY TABLE tmp as(
        select distinct u.usra_id from '||ref_schema||'.usra u 
        cross join lateral (
                select st_intersects(usra_amont.geom,c.geom)
                from '||trt_schema||'.usra_final_amont usra_amont 
            inner join '||col_schema||'.camino c
                on st_intersects(usra_amont.geom,c.geom)
                where ARRAY[u.usra_id] <@ usra_amont.array_agg
              ) lat2
      );
      update '||ref_schema||'.usra u set orp_aval = ''presence''
      from tmp t
      where u.usra_id = t.usra_id;

    ';

  if ref_schema = 'ref_guyane' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;
  

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_orp(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  


  querystr:= '

      alter table '||ref_schema||'.usra drop column if exists orp ;
      alter table '||ref_schema||'.usra add column orp text;
      comment on column '||ref_schema||'.usra.orp is ''présence de site(s) d''''orpaillage sur le tronçon'';
      update '||ref_schema||'.usra set orp=''absence'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      with tmp as(
        select u.usra_id from '||ref_schema||'.usra u inner join '||col_schema||'.camino c
        on st_intersects(u.geom,c.geom)
      )	
      update '||ref_schema||'.usra u set orp = ''presence''
      from tmp t
      where u.usra_id = t.usra_id;

    ';

  if ref_schema = 'ref_guyane' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_orp_amont(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  


  querystr:= '

      alter table '||ref_schema||'.usra drop column if exists orp_amont ;
      alter table '||ref_schema||'.usra add column orp_amont text;
      comment on column '||ref_schema||'.usra.orp_amont is ''présence de site(s) d''''orpaillage sur le tronçon et en amont proche (10+1 USRA)'';
      update '||ref_schema||'.usra set orp_amont=''absence'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      DROP TABLE IF EXISTS tmp;
      CREATE TEMPORARY TABLE tmp as(
        select distinct u.usra_id from '||ref_schema||'.usra u 
        cross join lateral (
            select st_intersects(u2.geom,c.geom)
                from '||trt_schema||'.usra_final_amont_aval u_av,
                '||trt_schema||'.usra_final_amont_aval u2 
            inner join '||col_schema||'.camino c
                on st_intersects(u2.geom,c.geom)
                where u_av.usra_id=u.usra_id
                    and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt>=(u_av.cnt-10) and u2.cnt<=u_av.cnt
              ) lat2
      );
      update '||ref_schema||'.usra u set orp_amont = ''presence''
      from tmp t
      where u.usra_id = t.usra_id;
    ';

  if ref_schema = 'ref_guyane' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;
  

  
  return 0;
END;
$$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_orp_autour(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$$
DECLARE
	querystr text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
	RAISE NOTICE 'schéma collecte (%)', col_schema;
  
  


  querystr:= '

      alter table '||ref_schema||'.usra drop column if exists orp_autour ;
      alter table '||ref_schema||'.usra add column orp_autour text;
      comment on column '||ref_schema||'.usra.orp_autour is ''présence de site(s) d''''orpaillage autour de l''''USRA (USRA évaluée + 5 amont + 5 aval)'';
      update '||ref_schema||'.usra set orp_autour=''absence'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
      DROP TABLE IF EXISTS tmp;
      CREATE TEMPORARY TABLE tmp as(
        select distinct u.usra_id from '||ref_schema||'.usra u 
        cross join lateral (
            select st_intersects(u2.geom,c.geom)
                from '||trt_schema||'.usra_final_amont_aval u_av,
                '||trt_schema||'.usra_final_amont_aval u2 
            inner join '||col_schema||'.camino c
                on st_intersects(u2.geom,c.geom)
                where u_av.usra_id=u.usra_id
                    and u2.usra_amont_id=u_av.usra_amont_id and u2.cnt>=(u_av.cnt-5) and u2.cnt<=(u_av.cnt+5)
              ) lat2
      );
      update '||ref_schema||'.usra u set orp_autour = ''presence''
      from tmp t
      where u.usra_id = t.usra_id;
    ';

  if ref_schema = 'ref_guyane' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;
  

  
  return 0;
END;
$$;

