-- Calcul de agribv : taux de cultures agricoles intensives dans le bassin versant

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_agribv(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$calc_agribv$
DECLARE
    querystr text;
    seuil_1 text;
    seuil_2 text;
    occ_filter text;
    occ_table text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;

    seuil_1 := '10';
    seuil_2 := '25';
    occ_filter  := '';
    occ_table := 'occsol';

    querystr:= '
        alter table '||ref_schema||'.bv drop column if exists surf_agribv ;
        alter table '||ref_schema||'.bv add column surf_agribv double precision;
        alter table '||ref_schema||'.usra drop column if exists agribv_v ;
        alter table '||ref_schema||'.usra add column agribv_v double precision;
        alter table '||ref_schema||'.usra drop column if exists agribv ;
        alter table '||ref_schema||'.usra add column agribv text;
        comment on column '||ref_schema||'.usra.agribv is ''taux de cultures agricoles intensives dans le bassin versant'';
        comment on column '||ref_schema||'.usra.agribv_v is ''taux de cultures agricoles intensives dans le bassin versant'';
        update '||ref_schema||'.usra set agribv=''faible'';
        ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    if ref_schema = 'ref_martinique' then 
        occ_table := 'occsol_2017';
        occ_filter  := '(CODE_CS = ''CS2.2.1'' and CODE_US = ''US1.1'') OR
        (CODE_CS = ''CS2.2.2'' and CODE_US = ''US1.1'')';
    end if;
    if ref_schema = 'ref_guadeloupe' then 
        occ_table := 'karucover_2017';
        occ_filter  := '(typcsn4 = ''CS2.2.1.2'' and typusn5 = ''US1.1.1.2.2'') OR
            (typcsn4 = ''CS2.2.1.2'' and typusn5 = ''US1.1.1.2.3'') OR
            (typcsn4 = ''CS2.2.1.2'' and typusn5 = ''US1.1.1.2.4'') ';
    end if;
    if ref_schema = 'ref_mayotte' then 
        occ_table := 'occsol_2016';
         occ_filter  := '(CODE_CS = ''CS2.2.1'' and CODE_US = ''US1.1'') OR
        (CODE_CS = ''CS2.2.2'' and CODE_US = ''US1.1'')';
    end if;
    if ref_schema = 'ref_guyane' then 
        occ_table := 'occsol_2015';
        occ_filter  := 'niveau3_15 IN( ''211'', ''213'',''222'',''242'')';
    end if;
    
    if ref_schema = 'ref_reunion' then 
        occ_table := 'occsol';
        occ_filter  := 'code3 IN (1,5,7,9,13,14) ';
    end if;
    if ref_schema = 'ref_hexagone' then 
        occ_table := 'oso2021';
        occ_filter  := 'classe IN (5,6,7,8,9,10,11,12,15) ';
    end if;
    querystr:= '
    drop table if exists '||trt_schema||'.agri_intens;
    create table '||trt_schema||'.agri_intens as (
        select * from '||col_schema||'.'||occ_table||' where '||occ_filter||'
       
    );
    update '||trt_schema||'.agri_intens set geom=St_makevalid(geom) where not st_isvalid(geom);
    create index on '||trt_schema||'.agri_intens using gist(geom);
    drop table if exists surf_by_bv;
    create temporary table surf_by_bv as (
        select b.bv_id,sum(st_area(st_intersection(a.geom,b.geom))) as surf_agribv from '||trt_schema||'.agri_intens a inner join '||ref_schema||'.bv b
            on st_intersects(a.geom,b.geom)
            group by b.bv_id
    );
    update '||ref_schema||'.bv u set surf_agribv = t.surf_agribv
    from surf_by_bv t
    where u.bv_id = t.bv_id;
    update '||ref_schema||'.bv u set surf_agribv = 0 where surf_agribv is null;

    with tmp as(
        select u.usra_id,lat.surf,lat.surface,(lat.surf/lat.surface)*100 as taux from '||ref_schema||'.usra u
            cross join lateral (
            select sum(surf_agribv) as surf,sum(st_area(bv.geom)) as surface 
                from '||trt_schema||'.usra_final_bv_amont bv_amont,
            '||ref_schema||'.bv bv
            where u.usra_id=bv_amont.usra_id 
            and bv_amont.bv_id=bv.bv_id
        ) lat 
    )
    update '||ref_schema||'.usra u set agribv_v = ROUND(t.taux::numeric,2)
        from tmp t
        where u.usra_id = t.usra_id;

    update '||ref_schema||'.usra set agribv=''moyen'' where agribv_v>='||seuil_1||';
    update '||ref_schema||'.usra set agribv=''fort'' where agribv_v>='||seuil_2||';
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

  return 0;
END;
$calc_agribv$;

-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_agri3w(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$calc_agri3w$
DECLARE
    querystr text;
    seuil_1 text;
    seuil_2 text;
    occ_filter text;
    occ_table text;
BEGIN
    RAISE NOTICE 'schéma trt (%)', trt_schema;
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;
  
    seuil_1 := '30';
    seuil_2 := '60';
    occ_filter  := '';
    occ_table := 'occsol';

    querystr:= '
        alter table '||ref_schema||'.usra drop column if exists agri3w_v ;
        alter table '||ref_schema||'.usra add column agri3w_v double precision;
        alter table '||ref_schema||'.usra drop column if exists agri3w ;
        alter table '||ref_schema||'.usra add column agri3w text;
        comment on column '||ref_schema||'.usra.agri3w is ''taux d''''agriculture intensive à proximité du lit mineur (3W)'';
        comment on column '||ref_schema||'.usra.agri3w_v is ''taux d''''agriculture intensive à proximité du lit mineur (3W)'';
        update '||ref_schema||'.usra set agri3w=''faible'';
        ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

    if ref_schema = 'ref_martinique' then 
        occ_table := 'occsol_2017';
        occ_filter  := '(CODE_CS = ''CS2.2.1'' and CODE_US = ''US1.1'') OR
        (CODE_CS = ''CS2.2.2'' and CODE_US = ''US1.1'')';
    end if;
    if ref_schema = 'ref_guadeloupe' then 
        occ_table := 'karucover_2017';
        occ_filter  := '(typcsn4 = ''CS2.2.1.2'' and typusn5 = ''US1.1.1.2.2'') OR
            (typcsn4 = ''CS2.2.1.2'' and typusn5 = ''US1.1.1.2.3'') OR
            (typcsn4 = ''CS2.2.1.2'' and typusn5 = ''US1.1.1.2.4'') ';
    end if;
    if ref_schema = 'ref_mayotte' then 
        occ_table := 'occsol_2016';
         occ_filter  := '(CODE_CS = ''CS2.2.1'' and CODE_US = ''US1.1'') OR
        (CODE_CS = ''CS2.2.2'' and CODE_US = ''US1.1'')';
    end if;
    if ref_schema = 'ref_guyane' then 
        occ_table := 'occsol_2015';
        occ_filter  := 'niveau3_15 IN( ''211'', ''213'',''222'',''242'')';
    end if;
    if ref_schema = 'ref_reunion' then 
        occ_table := 'occsol';
        occ_filter  := 'code3 IN (1,5,7,9,13,14) ';
    end if;
    if ref_schema = 'ref_hexagone' then 
        occ_table := 'oso2021';
        occ_filter  := 'classe IN (5,6,7,8,9,10,11,12,15) ';
    end if;
    querystr:= '
    
    drop table if exists surf_by_buffer;
    create temporary table surf_by_buffer as (
        select b.usra_id,sum(st_area(st_intersection(a.geom,b.geom))) as surf_agri from '||trt_schema||'.agri_intens a inner join '||ref_schema||'.usra_3w_moins_1w b
            on st_intersects(a.geom,b.geom)
            group by b.usra_id
    );
    drop table if exists surf_buffer;
    create temporary table surf_buffer as (
        select b.usra_id,sum(st_area(b.geom)) as surf_buffer from '||ref_schema||'.usra_3w_moins_1w b
            group by b.usra_id
    );
    update '||ref_schema||'.usra u set agri3w_v = ROUND((t.surf_agri*100/buff.surf_buffer)::numeric,2)
    from surf_by_buffer t,surf_buffer buff
    where u.usra_id = t.usra_id and u.usra_id = buff.usra_id;
    update '||ref_schema||'.usra u set agri3w_v = 0 where agri3w_v is null;


    update '||ref_schema||'.usra set agri3w=''moyen'' where agri3w_v>='||seuil_1||';
    update '||ref_schema||'.usra set agri3w=''fort'' where agri3w_v>='||seuil_2||';
    ';

    RAISE NOTICE '%',querystr;
    EXECUTE querystr;

  return 0;
END;
$calc_agri3w$;


-- beton: données que pour martinique et reunion
-- paramètres : 
-- trt_schema => schéma de traitement pour le stockage des tables temporaires
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_beton(trt_schema text, ref_schema text,col_schema text)
returns int
language plpgsql
as
$calc_beton$
DECLARE
	querystr text;
BEGIN
  RAISE NOTICE 'schéma trt (%)', trt_schema;
  RAISE NOTICE 'schéma ref (%)', ref_schema;
  RAISE NOTICE 'schéma collecte (%)', col_schema;

  querystr:= '

      alter table '||ref_schema||'.usra drop column if exists beton ;
      alter table '||ref_schema||'.usra add column beton text;
      comment on column '||ref_schema||'.usra.beton is ''fond du lit bétonné'';
      update '||ref_schema||'.usra set beton=''absence'';
    ';

  RAISE NOTICE '%',querystr;
  EXECUTE querystr;
  
  querystr:= '
  DROP TABLE IF EXISTS tmp;
      CREATE TEMPORARY TABLE tmp as(
        select distinct u.usra_id from '||ref_schema||'.usra u
        inner join '||ref_schema||'.tgh tgh
        on u.tgh_id=tgh.tgh_id
        cross join lateral (
                select b.*
                from '||col_schema||'.fond_beton b
                where ( st_dwithin(st_lineinterpolatepoint(u.geom,0.1),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.2),b.geom,tgh.largeur_pb/2)  )
                or ( st_dwithin(st_lineinterpolatepoint(u.geom,0.2),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.3),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u.geom,0.3),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.4),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u.geom,0.4),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.5),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u.geom,0.5),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.6),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u.geom,0.6),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.7),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u.geom,0.7),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.8),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u.geom,0.8),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.9),b.geom,tgh.largeur_pb/2)  )
                or (   st_dwithin(st_lineinterpolatepoint(u.geom,0.9),b.geom,tgh.largeur_pb/2)
                and st_dwithin(st_lineinterpolatepoint(u.geom,0.99),b.geom,tgh.largeur_pb/2)  )
              ) lat2
      );
      update '||ref_schema||'.usra u set beton = ''presence''
      from tmp t
      where u.usra_id = t.usra_id;

    ';

  if ref_schema = 'ref_martinique' or ref_schema = 'ref_reunion' then 
    RAISE NOTICE '%',querystr;
    EXECUTE querystr;
  end if;

  
  return 0;
END;
$calc_beton$;

-- pistes: que pour la guyane
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_pistes(ref_schema text,col_schema text)
    returns int
    language plpgsql
as
$calc_pistes$
DECLARE
    querystr text;
    row_cnt int8 := 0;
    piste_exist bool := false;
BEGIN
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;

    execute format($$
      alter table %1$I.usra drop column if exists pistes ;
      alter table %1$I.usra add column pistes text default 'absence';
      comment on column %1$I.usra.pistes is 'présence de piste forestière'$$, ref_schema);

    -- check if piste table exists in col_schema (currently, only guyane)
    select exists(
        select null
        from information_schema.tables
        where table_schema = col_schema and table_name = 'piste'
    ) into piste_exist;

    if piste_exist then
        querystr := format($$
        With piste as (
            select u.usra_id
            from %1$I.usra_3w u join %2$I.piste p on st_intersects(u.geom, p.geom)
            group by u.usra_id
        )
        update %1$I.usra u set pistes = 'presence'
        from piste n
        where u.usra_id = n.usra_id$$, ref_schema, col_schema);

        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
        GET DIAGNOSTICS row_cnt = ROW_COUNT;
    else 
        raise notice 'table %.piste does not exist, skipping update...', col_schema;
    end if;

    raise notice 'Mise à jour de % usra pour la colonne ''pistes''', row_cnt;

    return 0;
END;
$calc_pistes$;

-- carriere: que pour la guyane
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- col_schema => schéma contenant les données de collecte 
create or replace function calc_carriere(ref_schema text,col_schema text)
    returns int
    language plpgsql
as
$calc_carriere$
DECLARE
    querystr text;
    row_cnt int8 := 0;
    carriere_exist bool := false;
BEGIN
    RAISE NOTICE 'schéma ref (%)', ref_schema;
    RAISE NOTICE 'schéma collecte (%)', col_schema;

    execute format($$
      alter table %1$I.usra drop column if exists carriere ;
      alter table %1$I.usra add column carriere text default 'absence';
      comment on column %1$I.usra.carriere is 'présence de carrière'$$, ref_schema);

    -- check if carriere table exists in col_schema (currently, only guyane)
    select exists(
        select null
        from information_schema.tables
        where table_schema = col_schema and table_name = 'carriere'
    ) into carriere_exist;

    if carriere_exist then
        querystr := format($$
        With carriere as (
            select u.usra_id,p.materiaux
            from %1$I.usra_3w u join %2$I.carriere p on st_intersects(u.geom, p.geom)
            group by u.usra_id,p.materiaux
        )
        update %1$I.usra u set carriere = case when n.materiaux not like '%%SABLE%%' and n.materiaux not like '%%LATERITE%%' then  'roche'
         else 'lat_sab' end
        from carriere n
        where u.usra_id = n.usra_id$$, ref_schema, col_schema);

        RAISE NOTICE '%',querystr;
        EXECUTE querystr;
        GET DIAGNOSTICS row_cnt = ROW_COUNT;
    else
        raise notice 'table %.carriere does not exist, skipping update...', col_schema;
    end if;

    raise notice 'Mise à jour de % usra pour la colonne ''carriere''', row_cnt;

    return 0;
END;
$calc_carriere$;
