-- script de calcul des buffer xw des usra (w, 3w) et des buffer xm (10m, 30m, 60m)
-- Rappel : les buffers 10/30/60m ont une largeur de W + 2 fois10/30/60m, avec un minimum de 15m


-- calcul du buffer a X mètres
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- buffer_width => largeur du buffer en m
drop function if exists calc_buffer_usra_m(ref_schema text, buffer_width int);
create or replace function calc_buffer_usra_m(ref_schema text, buffer_width int)
    returns int
    language plpgsql
as
$calc_buffer_usra_m$
DECLARE
    table_name name;
    table_srid int;
    time0 numeric;
    time1 numeric;
BEGIN
    select srid from geometry_columns where f_table_schema = ref_schema and f_table_name = 'usra' into table_srid;
    table_name = format('usra_%sm', buffer_width)::name;

    raise notice 'creating table %.% (buffer width: % m, srid: %)', ref_schema, table_name, buffer_width, table_srid;
    select extract(epoch from clock_timestamp()) into time0;

    execute format($$
        drop table if exists %1$I.%2$I;
        create table %1$I.%2$I as
        select u.usra_id,st_subdivide(
                            st_buffer(
                                u.geom,
                                (g.largeur_pb * 0.5) + %3$L,
                                'endcap=flat join=round'
                            )
                        )::geometry(polygon, %4$L) as geom
        from %1$I.usra u
                 join %1$I.tgh g on u.tgh_id=g.tgh_id;

        create index on %1$I.%2$I  using gist(geom);
        analyse %1$I.%2$I
        $$, ref_schema, table_name, buffer_width, table_srid);

    select extract(epoch from clock_timestamp()) into time1;
    raise notice 'table created in % s', (time1 - time0);

    return 0;
end
$calc_buffer_usra_m$;


-- buffer 1w utilisé pour evider les autres buffers
drop function if exists calc_buffer_usra_w_for_diff(ref_schema text, buffer_width int);
create or replace function calc_buffer_usra_w_for_diff(ref_schema text, buffer_width int)
    returns int
    language plpgsql
as
$calc_buffer_usra_w_for_diff$
DECLARE
    table_name name;
    table_srid int;
    time0 numeric;
    time1 numeric;
BEGIN
    select srid from geometry_columns where f_table_schema = ref_schema and f_table_name = 'usra' into table_srid;
    table_name = format('usra_diff_%sw', buffer_width)::name;

    raise notice 'creating table %.% (buffer width: % times usra''s width, srid: %)', ref_schema, table_name, buffer_width, table_srid;
    select extract(epoch from clock_timestamp()) into time0;

    execute format($$
        drop table if exists %1$I.%2$I;
        create table %1$I.%2$I as
        select u.usra_id,st_subdivide(
                            st_buffer(
                                u.geom,
                                g.largeur_pb * (%3$L/2.0),
                                'endcap=flat join=round'
                            )
                        )::geometry(polygon, %4$L) as geom
        from %1$I.usra u
                 join %1$I.tgh g on u.tgh_id=g.tgh_id;

        create index on %1$I.%2$I  using gist(geom);
        analyse %1$I.%2$I
        $$, ref_schema, table_name, buffer_width, table_srid);

    select extract(epoch from clock_timestamp()) into time1;
    raise notice 'table created in % s', (time1 - time0);

    return 0;
end
$calc_buffer_usra_w_for_diff$;

-- buffer Xw avec 15m minimum
-- calcul du buffer Xw
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- buffer_width => nombre de W du buffer
drop function if exists calc_buffer_usra_w(ref_schema text, buffer_width int);
create or replace function calc_buffer_usra_w(ref_schema text, buffer_width int)
    returns int
    language plpgsql
as
$calc_buffer_usra_w$
DECLARE
    table_name name;
    min_size float := 7.5;
    table_srid int;
    time0 numeric;
    time1 numeric;
BEGIN
    select srid from geometry_columns where f_table_schema = ref_schema and f_table_name = 'usra' into table_srid;
    table_name = format('usra_%sw', buffer_width)::name;

    raise notice 'creating table %.% (buffer width: % times usra''s width, srid: %)', ref_schema, table_name, buffer_width, table_srid;
    select extract(epoch from clock_timestamp()) into time0;

    execute format($$
        drop table if exists %1$I.%2$I;
        create table %1$I.%2$I as
        select u.usra_id,st_subdivide(
                            st_buffer(
                                u.geom,
                                GREATEST(g.largeur_pb * (%3$L/2.0) , %4$L),
                                'endcap=flat join=round'
                            )
                        )::geometry(polygon, %5$L) as geom
        from %1$I.usra u
                 join %1$I.tgh g on u.tgh_id=g.tgh_id;

        create index on %1$I.%2$I  using gist(geom);
        analyse %1$I.%2$I
        $$, ref_schema, table_name, buffer_width, min_size, table_srid);

    select extract(epoch from clock_timestamp()) into time1;
    raise notice 'table created in % s', (time1 - time0);

    return 0;
end
$calc_buffer_usra_w$;


-- calcul de la différence entre 2 buffers buf_table_a sera évidé de buf_table_b
-- paramètres : 
-- ref_schema => schéma contenant les données de référence (usra, tgh, bv )
-- buf_table_a => buffer a 
-- buf_table_b => buffer b
drop function if exists calc_buffer_diff(ref_schema text, buf_table_a text, buf_table_b text);
create or replace function calc_buffer_diff(ref_schema text, buf_table_a text, buf_table_b text)
    returns int
    language plpgsql
as
$calc_buffer_diff$
DECLARE
    table_name name;
    table_srid int;
    time0 numeric;
    time1 numeric;
BEGIN
    table_name := format('usra_%s_moins_%s', replace(buf_table_a, 'usra_', ''), replace(buf_table_b, 'usra_diff_', ''));
    select srid from geometry_columns where f_table_schema = ref_schema and f_table_name = 'usra' into table_srid;

    raise notice 'creating table %.% (srid: %)', ref_schema, table_name, table_srid;
    select extract(epoch from clock_timestamp()) into time0;

    execute format($$
        drop table if exists %1$I.%2$I;
        create table %1$I.%2$I as
            with tmp as (
                select a.usra_id, st_union(a.geom) as geom
                from %1$I.%4$I a
                group by a.usra_id
            ), tmp1 as (
                select a.usra_id, st_union(a.geom) as geom
                from %1$I.%5$I a
                group by a.usra_id
            )
            select a.usra_id, st_subdivide(st_difference(a.geom, b.geom))::geometry(polygon, %3$L) as geom
            from tmp a
             join tmp1 b on a.usra_id = b.usra_id;
        create index on %1$I.%2$I using gist(geom);
        analyse %1$I.%2$I
        $$, ref_schema, table_name, table_srid, buf_table_a, buf_table_b);

    select extract(epoch from clock_timestamp()) into time1;
    raise notice 'table created in % s', (time1 - time0);

    return 0;
end
$calc_buffer_diff$;

