# Traitements SQL et SIG


## SYSTEMES de projection à utiliser



|Région	|système	|Définition	|ellipsoïde	|projection	|code EPSG	|registre IGN-F|
| ------ | ------ |----- |----- |----- |----- |----- |
|guadeloupe|	RGAF 09	|ITRS via IGS2005 époque 2009.0	|IAG-GRS 1980	|UTM 20 N	|5490	|RGAF09UTM20|
|martinique|	RGAF 09	|ITRS via IGS2005 époque 2009.0	|IAG-GRS 1980	|UTM 20 N	|5490	|RGAF09UTM20|
|guyane|	RGFG95	|ITRF93 époque 1995.0	|IAG-GRS 1980	|UTM 22 N	|2972	|RGFG95UTM22|
|réunion|	RGR92	|ITRF1991 époque 1993.0	|IAG-GRS 1980	|UTM 40 S	|2975	|RGR92UTM40S|
|mayotte|	RGM04	|ITRF2000 époque 2004.0	|IAG-GRS 1980	|UTM 38 S	|4471	|RGM04UTM38S|
|métropole|	RGF93 (v2b)	|ETRF2000 époque 2019.0	|IAG-GRS 1980	|Lambert-93	|2154	|RGF93LAMB93|


## Analyse référentiels hydro

Cf. 1-collecte pour le chargement des couches brutes dans la BD de travail.

### Réseaux disponibles

#### Métropole
 - Les tronçons de la BD Carthage
 - Les tronçons de la BD Topo (existent en différents millésimes)
 - Les tronçons de la BD Topage (déjà disponibles mais en cours de construction-vérification)
 - Les 2 couches SYRAH-CE 
   - Les tronçons géomorphologiquement homogènes (TGH) : couche construite par le Cemagref à partir de la BD Carthage 
en excluant de nombreux cours d’eau secondaires, en bouchant les trous pour assurer la continuité du réseau (parfaite ?), 
en délimitant et caractérisant chaque tronçon homogène du point de vue de ses caractéristiques géomorphologiques naturelles. 
Fichier shapefile : `Troncons_SYRAH_04_04_12_Lambert.shp`
   - Les Unités Spatiales de Recueil et d’Analyses (USRA) : Il existe les versions 2013 et 2017, on part sur 20#3.
couche construite par Ginger-Strategis en projetant les TGH 
produits par le Cemagref sur les tronçons de la BD Topo de l’époque. Les USRA résultant de ce traitement sont identifiables 
par le champ Source qui prend la valeur « syrah » ou par le champ Identifiant qui prend une valeur inférieur à 500 000. 
Ont ensuite été ajoutés d’autres cours d’eau à la demande des agences de l’eau. Ces derniers n’ont pas été sectorisés. 
Ils sont identifiables par le champ Source qui prend la valeur « tpme » ou par le champ Identifiant qui prend une valeur supérieur à 500 000. 
Fichiers shapefiles : 6 couches USRA_v2_initiales bassin_L93.shp

Seuls les cours d'eau naturels sont conservés:
 - BD Topo : il s’agit des tronçons dont l'attribut NATURE est `Aqueduc` ou `Canal` ou `Conduit forcé`
 - BD Carthage : il s’agit des tronçons dont l'attribut NATURE est `Aqueduc, conduite forcé` ou `Canal, chenal`.


### Outre mer

 - Les tronçons de la BD Carthage, si ce n’est que celle de Guadeloupe n’est plus diffusée
 - Les tronçons de la BD Topo (différents millésimes ?)
 - Les tronçons de la BD Topage pour Mayotte uniquement
 - Les tronçons homogènes et USRA issus de RHUM. Contrairement à SYRAH-CE, ces 2 couches ont strictement la même géométrie 
si ce n’est qu’on a découpé les TGH en 1 ou plusieurs USRA

### TODO

TODO: charger syrah à partir des shapes / vérifier couche actuelle
      trouver les tables bdcarthage, bdtopo pour les coursdeau !
      check si on retrouve tgh from carthage, usra from topo (charger les vieilles couches ?)


## Ruptures de pentes

cf. ticket [13220](https://redmine.neogeo.fr/issues/13220)

tests faits sur un bassin versant test (petite taille) dans les DROM à partir du référentiel RHUM (sauf Mayotte et Réunion):

extent: `'BOX(631606 1784581, 635525 1787402)'::box2D`

### Méthode

 - DEM métrique guadeloupe téléchargé depuis (http://data.cquest.org/ign/rgealti/) et transformé en geotiff compressé
 - gdaldem slope appliqué sur le tiff
 - gdallocationinfo appliqué sur une série de points issus des tables ode971.th_rhum et ode971.usi
(cf. `asc2tif.sh`)
 - SQL pour analyser deux points consécutifs et calculer la différence de pente entre eux (cf `ruptures.sql`)

Le script bash `ruptures.sh` résume ces opérations et permet de lancer l'algo sur une table, avec une méthode de sampling.
Il crée les tables `public.slopept_<table>` contenant les valeurs de slope pour les points samplés et `public.rupture_<table>` contenant
les points dont la valeur est supérieure au seuil (réglé dans `ruptures.bash`), `<table>` étant le nom de la table passée en 
paramètre du script

```
Usage: ./rupture.sh <table> <sampling>"
  <table>: doit avoir une colonne gid comme pk et geom pour la geometry"
  <sampling>: endpoints|allpoints"
    endpoints: prend les startpoint et endpoint de la geom de la table"
    allpoints: prend tous les points de la geom de la table"
```

Example:
```
./ruptures.sh ode971.usi endpoints

Produit les tables public.slopept_usi et rupture_usi
```

### Limites / Idées

• Sur le DEM métrique, les pentes peuvent changer brutalement => diff de pentes sur des grandes distances parait peu précis.
DEM resamplé à 5, 10, 50m ?

• Pentes moyennes de tronçons à comparer entre elles ? par ex: pentes moyennes des usi des th, détection du changement de pente
entre 2 tronçons consécutifs ?

## Correction des usra originales

Les usra syrah 2013 sont composées de multilinestring (MLN) par endroit, ce qui n'est pas normal, et ne sont pas bien
connectées entre elles, parois sur qq mm, parfois sur plusieurs dizaines de m.
Pour reconstruire des tgh, linestring (LN) a partir des usra, il faut que la connectivité soit correcte.

Pour corriger les usra, les vertex des usra proches à 0.3m (précision empririque basées sur l'analyse de qq gaps)
ont été snappés entre eux et les usra mises à jour avec 
ces nouveaux points. Cela améliore grandement la reconstruction des tgh projetés sur la bdtopo depuis les usra.

## Calage usra Syrah sur tronçon bdtopo

Plusieurs tests portant sur des algo différents ont été conduits.
Le calage usra sur troncons hydro (th) est difficile car:
 - il y a un décalage systématique entre les deux réseaux
 - le nombre de vertex ne correspond pas entre les deux réseaux
 - les th ne couvrent pas entièrement les zones des usra (trous th alors que usra présentes)

Une méthode semble marcher plutôt vite et bien : **le routing**

Le principe est le suivant:
 - Utiliser PgRouting avec un algo de plus court chemin (dijkstra, A*) pour router les th
 - projeter sur les th les start et end points des usra, pour avoir les points de départ (source) et d'arrivée (target) 
de chaque usra relatif au th le plus proche
 - router toutes les usra sur le réseau th
 - reconstruire les linestrings des usra

La table `public.usra_new_mln` contient les usra calées sur les th
La table `public.th_tmp` contient les th utilisés pour le routing (th initiaux dont on a viré les éléments eloignés de plus de 100m d'une usra)

La construction de la **topologie** de routing sur les th de france a pris **18min**
Le routage des **160 000+** usra sur ce réseau à pris **20min**
La 

**A noter**: un double routage a été effectué car certaines usra ne sont pas numérisées dans le meme sens que les th:
comme le réseau est orienté, le routage inverse ne marche pas et produit des linestrings fausses.
On peut donc s'attendre à un temps ~ 10min pour router toutes les usra une fois la méthode fixée

Dijkstra a été utilisé pour le plus court chemin: tests a faire sur A* et birectionnal Dijkstra/A*
    
On peut identifier les USRA non routées: on constate que ce sont surtout des usra qui n'ont pas de th correspondant (trou dans la topo th => routage impossible)

Dans certains rares cas, le plus court chemin (algo routing) n'est pas celui qui correspond au tracé de l'usra:
il aurait fallu prendre un th plus long, mais plus proche de l'usra pour caler correctement.
~~Pour palier ce problème, le cout utilisé dans le routing, qui permet de choisir entre plusieurs chemins celui à prendre 
n'est pas la longueur du troncon mais le produit de la longueur avec sa distance moyenne aux usra 
(distance de chaque point du th a l'usra la plus proche).
Cette distance moyenne est très lourde à calculer (énormément de vertex dans les th): il a fallu diviser le dataset
en 6 parties pour éviter des problèmes de mémoire sur le serveur.~~

Une nouvelle méthode est testée sur le dataset usra syrah 2013: la distance entre le milieu d'un troncon hydro et son
usra la plus proche est calculée et permet de calculer le cout d'un troncon pour le routing: 
`longueur du troncon * distance a l'usra` Ce critère semble donner de bons résultats et ai BCP plus rapide à calculer
(le serveur neogeo plante avec la méthode précédente)

Ce critère de cout donne de très bons résultats et dans les zones identifiées à la main, le routage est correct avec ce cout
alors qu'il est faux avec un cout = longueur du th.

Les images suivantes montrent des exemples du calage: (th en bleu, usra en vert)

Calage correct: le th a prendre, même assez éloigné de l'usra, est bien pris par le routing
(en rose les usra initiales, en vert les nouvelles usra, en bleu les th)
![](./images/usra-newrouting.png)
![](./images/usra-newrouting-res.png)

Correction des décalages systématiques: nouvelle usra en vert en th (en bleu dessous) sont confondus

![](./images/usra-calage.png)

Routing impossible:
![](./images/bad_usra1.png)

Routing impossible: l'usra verte en bas a gauche est proche d'un segment th deconnecté du reste
![](./images/bad_usra2.png) 

Mauvais routing: la nouvelle usra (vert) aurait du prendre le chemin bleu proche de l'usra rose, mais l'autre chemin est plus court => choisi par l'algo

**Le nouveau cout utilisé permet de résoudre ce problème et de router correctement l'usra sur les th**

![](./images/bad_routing.png)

## Stats recalage

 - 68.0*100/102637.0 (**0.07%**) usra n'ont pas été recalées avec cette méthode (trou dans le reseau th => routing impossible: traitement manuel ou algo de fusion des th avant reroutage)
 - ces 68 usra représentent 131752.0 m * 100 / 225526590.0 m (**0.06%** de la longueur totale)
 - La différence de longueur entre usra avant recallage et apres est de **0.8%** 
(les nouvelles usra représentent une longueur plus grande: bdtopo est plus précise => arcs plus longs)

**La méthode marche très bien et permet de reconstruire la très grande majorité des usra**


## Calcul des TGH 

le script ref_hydro/rebuild_tgh.sql reconstuit les TGH à partir de la couche usra_work

la couche usra_work contient les usra_syrah simplifiés avec pas mal de retouches manuelles pour corriger des erreurs ou améliorer le routing qui est effectué par la suite pour se caler sur la BD topo.

### réintégration de THG manquants dans usra_work


62 TGH à intégrer à usra_work
```
create table trt_metro.tgh_to_add as(
	select * from syrah.tgh where troncon_id in 
(90,306,666,1305,2022,2052,2865,3372,5211,5247,5282,5624,5738,5739,5887,5888,6562,6563,6663,6984,9426,9453,10671,
11150,11448,11556,12687,12689,13323,13343,13368,15556,16112,16311,16429,16431,17642,19354,20968,
21167,22281,
23241,23461,
25462,25486,
25764,25815,25830,
25885,25887,
25896,26384,
27484,28285,
30189,32093,
36223,36226,
57359,
57361,
57523,
64172)
)
```


### récupération des attributs TGH syrah

Après avoir recréé les géometries des TGH à partir des usras recalées sur la BD TOPO, on récupère les attributs TGH depuis syrah.tgh en faisant une jointure sur le troncon_id. 


pour les usras TPME qui ne sont pas associés à des TGH syrah, on va récupérer le rang et le toponyme dans les usra syrah d'origine

## Calcul des USRA à partir des TGH

les TGH sont ensuite découpés en USRA dont la longeur max va varier selon le range de strahler selon la règle suivante:

Pour la métropole:
```
 CASE WHEN rang = 1 THEN 300 
        WHEN rang = 2 THEN 600
        WHEN rang = 3 THEN 1100
        WHEN rang = 4 THEN 2000
        WHEN rang = 5 THEN 4500
        WHEN rang = 6 THEN 12500
        WHEN rang = 7 THEN 22000
        WHEN rang = 8 THEN 40000
        ELSE 1000
```



## Calcul des altitudes

- les altitudes sont calculées à partir du RGE ALTI 5m
- les noeuds amonts/avals sont déterminés par le sens de l'écoulement de la BD Topo => ils semblent ne pas toujours etre justes si on regarde les altitudes calculées à partir du MNT 5m. 

### Création du MNT
le MNT 5m est distribué par départements avec des zones qui se recoupent. On ne peut pas exploiter directement ces fichiers et il faut reassembler un MNT france entière à partir des différents départements de manière à pouvoir exploiter cette deconnecté

le script 1-collecte/process_rgealti_dds.sh permet de créer ce MNT


### Script 
le script ref_hydro/compute_tgh_alti.sh calcule les altitudes à partir du MNT /data/prhymo/rgealti_dds/input_ign/rgealti_5m.tif ainsi que la pente du lit.

Si la pente calculée est < 0, on met la pente à 0






### TODO
 - tester d'autres algo + verif sens de numérisation pour ne lancer le routing qu'une fois
 
